/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.common.referential.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import fr.gouv.vitam.storage.engine.common.referential.model.OfferReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class StorageStrategy {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="offers")
    private List<OfferReference> offers = new ArrayList<OfferReference>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<OfferReference> getOffers() {
        return this.offers;
    }

    public void setOffers(List<OfferReference> offers) {
        this.offers = offers;
    }

    public Integer getCopy() {
        return this.getOffers().size();
    }

    public void postInit() {
        this.setOffers(Collections.unmodifiableList(this.getOffers().stream().filter(offerReference -> offerReference.isEnabled()).collect(Collectors.toList())));
    }

    public boolean isStorageOfferEnabled(String offerId) {
        Optional<OfferReference> offerReference = this.getOffers().stream().filter(offerRef -> offerRef.getId().equals(offerId)).findFirst();
        return offerReference.isPresent() && offerReference.get().isEnabled();
    }

    public boolean isStorageOfferReferent(String offerId) {
        Optional<OfferReference> offerReference = this.getOffers().stream().filter(offerRef -> offerRef.getId().equals(offerId)).findFirst();
        return offerReference.isPresent() && offerReference.get().isReferent();
    }
}

