/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.common.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.storage.engine.common.model.QueueMessageEntity;
import fr.gouv.vitam.storage.engine.common.model.QueueMessageType;
import fr.gouv.vitam.storage.engine.common.model.TapeCatalogLabel;
import fr.gouv.vitam.storage.engine.common.model.TapeLocation;
import fr.gouv.vitam.storage.engine.common.model.TapeState;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TapeCatalog
extends QueueMessageEntity {
    public static final String CODE = "code";
    public static final String ALTERNATIVE_CODE = "alternative_code";
    public static final String BUCKET = "bucket";
    public static final String LABEL = "label";
    public static final String LIBRARY = "library";
    public static final String TYPE = "type";
    public static final String CAPACITY = "capacity";
    public static final String FILE_COUNT = "file_count";
    public static final String CURRENT_LOCATION = "current_location";
    public static final String PREVIOUS_LOCATION = "previous_location";
    public static final String COMPRESSED = "compressed";
    public static final String WORM = "worm";
    public static final String VERSION = "_v";
    public static final String WRITTEN_BYTES = "written_bytes";
    public static final String TAPE_STATE = "tape_state";
    @JsonProperty(value="code")
    private String code;
    @JsonProperty(value="alternative_code")
    private String alternativeCode;
    @JsonProperty(value="bucket")
    private String bucket;
    @JsonProperty(value="label")
    private TapeCatalogLabel label;
    @JsonProperty(value="library")
    private String library;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="written_bytes")
    private Long writtenBytes = 0L;
    @JsonProperty(value="tape_state")
    private TapeState tapeState = TapeState.EMPTY;
    @JsonProperty(value="capacity")
    private Long capacity;
    @JsonProperty(value="file_count")
    private Integer fileCount = 0;
    @JsonProperty(value="current_location")
    private TapeLocation currentLocation;
    @JsonProperty(value="previous_location")
    private TapeLocation previousLocation;
    @JsonProperty(value="compressed")
    private boolean compressed;
    @JsonProperty(value="worm")
    private boolean worm;
    @JsonProperty(value="_v")
    private int version;
    @JsonIgnore
    private Integer currentPosition = 0;

    public TapeCatalog() {
        super(GUIDFactory.newGUID().getId(), QueueMessageType.TapeCatalog);
    }

    public String getCode() {
        return this.code;
    }

    public TapeCatalog setCode(String code) {
        this.code = code;
        return this;
    }

    public TapeCatalogLabel getLabel() {
        return this.label;
    }

    public TapeCatalog setLabel(TapeCatalogLabel label) {
        this.label = label;
        return this;
    }

    public String getLibrary() {
        return this.library;
    }

    public TapeCatalog setLibrary(String library) {
        this.library = library;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public TapeCatalog setType(String type) {
        this.type = type;
        return this;
    }

    public Long getWrittenBytes() {
        return this.writtenBytes;
    }

    public TapeCatalog setWrittenBytes(Long writtenBytes) {
        this.writtenBytes = writtenBytes;
        return this;
    }

    public TapeState getTapeState() {
        return this.tapeState;
    }

    public TapeCatalog setTapeState(TapeState tapeState) {
        this.tapeState = tapeState;
        return this;
    }

    public Long getCapacity() {
        return this.capacity;
    }

    public TapeCatalog setCapacity(Long capacity) {
        this.capacity = capacity;
        return this;
    }

    public Integer getFileCount() {
        return this.fileCount;
    }

    public TapeCatalog setFileCount(Integer fileCount) {
        this.fileCount = fileCount;
        return this;
    }

    public TapeLocation getCurrentLocation() {
        return this.currentLocation;
    }

    public TapeCatalog setCurrentLocation(TapeLocation currentLocation) {
        this.currentLocation = currentLocation;
        return this;
    }

    public TapeLocation getPreviousLocation() {
        return this.previousLocation;
    }

    public TapeCatalog setPreviousLocation(TapeLocation previousLocation) {
        this.previousLocation = previousLocation;
        return this;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public TapeCatalog setCompressed(boolean compressed) {
        this.compressed = compressed;
        return this;
    }

    public boolean isWorm() {
        return this.worm;
    }

    public TapeCatalog setWorm(boolean worm) {
        this.worm = worm;
        return this;
    }

    public int getVersion() {
        return this.version;
    }

    public TapeCatalog setVersion(int version) {
        this.version = version;
        return this;
    }

    public String getAlternativeCode() {
        return this.alternativeCode;
    }

    public TapeCatalog setAlternativeCode(String alternativeCode) {
        this.alternativeCode = alternativeCode;
        return this;
    }

    public String getBucket() {
        return this.bucket;
    }

    public TapeCatalog setBucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    public Integer getCurrentPosition() {
        return this.currentPosition;
    }

    public TapeCatalog setCurrentPosition(Integer currentPosition) {
        this.currentPosition = currentPosition;
        return this;
    }
}

