/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.common.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.storage.engine.common.model.OfferLogAction;
import fr.gouv.vitam.storage.engine.common.model.OfferLogFormatVersion;
import java.time.LocalDateTime;
import java.util.Objects;

public class OfferLog
implements Comparable<OfferLog> {
    public static final String SEQUENCE = "Sequence";
    public static final String TIME = "Time";
    public static final String CONTAINER = "Container";
    public static final String FILENAME = "FileName";
    public static final String ACTION = "Action";
    @JsonProperty(value="Sequence")
    private long sequence;
    @JsonProperty(value="Time")
    private LocalDateTime time;
    @JsonProperty(value="Container")
    private String container;
    @JsonProperty(value="FileName")
    private String fileName;
    @JsonProperty(value="Action")
    private OfferLogAction action;
    @JsonProperty(value="_FormatVersion")
    private OfferLogFormatVersion formatVersion = OfferLogFormatVersion.V1;

    public OfferLog() {
    }

    public OfferLog(String container, String fileName, OfferLogAction action) {
        this.time = LocalDateUtil.now();
        this.container = container;
        this.fileName = fileName;
        this.action = action;
        this.formatVersion = OfferLogFormatVersion.V2;
    }

    public OfferLog(long sequence, LocalDateTime time, String container, String fileName, OfferLogAction action) {
        this.sequence = sequence;
        this.time = time;
        this.container = container;
        this.fileName = fileName;
        this.action = action;
        this.formatVersion = OfferLogFormatVersion.V2;
    }

    public long getSequence() {
        return this.sequence;
    }

    public OfferLog setSequence(long sequence) {
        this.sequence = sequence;
        return this;
    }

    public LocalDateTime getTime() {
        return this.time;
    }

    public OfferLog setTime(LocalDateTime time) {
        this.time = time;
        return this;
    }

    public String getContainer() {
        return this.container;
    }

    public OfferLog setContainer(String container) {
        this.container = container;
        return this;
    }

    public String getFileName() {
        return this.fileName;
    }

    public OfferLog setFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public OfferLogAction getAction() {
        return this.action;
    }

    public OfferLog setAction(OfferLogAction action) {
        this.action = action;
        return this;
    }

    public OfferLogFormatVersion getFormatVersion() {
        return this.formatVersion;
    }

    public OfferLog setFormatVersion(OfferLogFormatVersion formatVersion) {
        this.formatVersion = formatVersion;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfferLog offerLog = (OfferLog)o;
        return this.sequence == offerLog.sequence && Objects.equals(this.time, offerLog.time) && Objects.equals(this.container, offerLog.container) && Objects.equals(this.fileName, offerLog.fileName) && this.action == offerLog.action && this.formatVersion == offerLog.formatVersion;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sequence, this.time, this.container, this.fileName, this.action, this.formatVersion});
    }

    @Override
    public int compareTo(OfferLog o) {
        long diff = this.getSequence() - o.getSequence();
        if (diff < 0L) {
            return -1;
        }
        if (diff > 0L) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "OfferLog{sequence=" + this.sequence + ", time=" + String.valueOf(this.time) + ", container='" + this.container + "', fileName='" + this.fileName + "', action=" + String.valueOf((Object)this.action) + ", formatVersion=" + String.valueOf((Object)this.formatVersion) + "}";
    }
}

