/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.common.parameters;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.logbook.common.parameters.AbstractParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParametersFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;

class LogbookOperationParametersDeserializer
extends JsonDeserializer<AbstractParameters> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookOperationParametersDeserializer.class);

    public AbstractParameters deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        LogbookOperationParameters logbookOperationParams = LogbookParametersFactory.newLogbookOperationParameters();
        try {
            ObjectNode objNode = (ObjectNode)p.readValueAsTree();
            Iterator iter = objNode.fields();
            ArrayNode eventList = null;
            HashMap<String, String> parameters = new HashMap<String, String>();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                if (LogbookParameterName.events.name().equals(entry.getKey())) {
                    eventList = (ArrayNode)entry.getValue();
                    continue;
                }
                if (!((JsonNode)entry.getValue()).isTextual()) continue;
                parameters.put((String)entry.getKey(), ((JsonNode)entry.getValue()).asText());
            }
            logbookOperationParams.setMap(parameters);
            LinkedHashSet<LogbookParameters> events = new LinkedHashSet<LogbookParameters>();
            if (eventList != null) {
                for (JsonNode event : eventList) {
                    events.add(JsonHandler.getFromJsonNode(event, LogbookOperationParameters.class));
                }
            }
            logbookOperationParams.setEvents(events);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error(e);
        }
        return logbookOperationParams;
    }
}

