/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model.processing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import fr.gouv.vitam.common.model.processing.LifecycleState;
import fr.gouv.vitam.common.model.processing.Step;
import fr.gouv.vitam.common.model.processing.WorkFlowExecutionContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class WorkFlow {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="identifier")
    private String identifier;
    @JsonProperty(value="typeProc")
    private String typeProc;
    @JsonProperty(value="comment")
    private String comment;
    @JsonProperty(value="lifecycleLog")
    private LifecycleState lifecycleLog;
    @JsonProperty(value="executionContext")
    private WorkFlowExecutionContext executionContext;
    protected List<Step> steps;

    public WorkFlow() {
    }

    @JsonCreator
    public WorkFlow(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="identifier") String identifier, @JsonProperty(value="typeProc") String typeProc, @JsonProperty(value="comment") String comment, @JsonProperty(value="lifecycleLog") LifecycleState lifecycleLog, @JsonProperty(value="executionContext") WorkFlowExecutionContext executionContext, @JsonProperty(value="steps") List<Step> steps) {
        this.id = id;
        this.name = name;
        this.identifier = identifier;
        this.typeProc = typeProc;
        this.comment = comment;
        this.lifecycleLog = (LifecycleState)((Object)MoreObjects.firstNonNull((Object)((Object)lifecycleLog), (Object)((Object)LifecycleState.TEMPORARY)));
        this.executionContext = (WorkFlowExecutionContext)((Object)MoreObjects.firstNonNull((Object)((Object)executionContext), (Object)((Object)WorkFlowExecutionContext.VITAM)));
        this.steps = steps;
        if (steps == null) {
            this.steps = new ArrayList<Step>();
        }
        this.steps.forEach(step -> step.defaultLifecycleLog(this.lifecycleLog));
        this.checkCancellableSteps();
    }

    private void checkCancellableSteps() {
        int i;
        int notCancelableIndex = -1;
        for (i = 0; i < this.steps.size() - 1; ++i) {
            if (this.steps.get(i).isCancellable()) continue;
            notCancelableIndex = i;
            break;
        }
        if (notCancelableIndex != -1 && notCancelableIndex < this.steps.size() - 1) {
            for (i = notCancelableIndex + 1; i < this.steps.size(); ++i) {
                if (!this.steps.get(i).isCancellable()) continue;
                throw new IllegalStateException("All steps after a non-cancellable step must be non-cancellable");
            }
        }
    }

    public static WorkFlow of(String id, String identifier, String evTypeProc) {
        WorkFlow workFlow = new WorkFlow();
        workFlow.setId(id);
        workFlow.setIdentifier(identifier);
        workFlow.setTypeProc(evTypeProc);
        return workFlow;
    }

    public String getId() {
        if (this.id == null) {
            return "";
        }
        return this.id;
    }

    public WorkFlow setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public WorkFlow setName(String name) {
        this.name = name;
        return this;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public WorkFlow setIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public String getTypeProc() {
        if (this.typeProc == null) {
            return "";
        }
        return this.typeProc;
    }

    public WorkFlow setTypeProc(String typeProc) {
        this.typeProc = typeProc;
        return this;
    }

    public String getComment() {
        if (this.comment == null) {
            return "";
        }
        return this.comment;
    }

    public WorkFlow setComment(String comments) {
        this.comment = comments;
        return this;
    }

    public LifecycleState getLifecycleLog() {
        return this.lifecycleLog;
    }

    public WorkFlow setLifecycleLog(LifecycleState lifecycleLog) {
        this.lifecycleLog = lifecycleLog;
        return this;
    }

    public WorkFlowExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public WorkFlow setExecutionContext(WorkFlowExecutionContext executionContext) {
        this.executionContext = executionContext;
        return this;
    }

    public List<Step> getSteps() {
        if (this.steps == null) {
            return Collections.emptyList();
        }
        return this.steps;
    }

    public WorkFlow setSteps(List<Step> steps) {
        this.steps = steps;
        this.checkCancellableSteps();
        return this;
    }

    public String toString() {
        return String.format("ID=%s\nname=%s\nidentifier=%s\ntypeProc=%s\ncomments=%s\nlifecycleLog=%s\n", new Object[]{this.getId(), this.getName(), this.getIdentifier(), this.getTypeProc(), this.getComment(), this.getLifecycleLog()});
    }
}

