/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model.administration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ProfileSedaVersion {
    VERSION_2_1("2.1"),
    VERSION_2_2("2.2"),
    VERSION_2_3("2.3");

    public static final ProfileSedaVersion DEFAULT;
    private static final Map<String, ProfileSedaVersion> VERSION_MAP;
    private final String version;

    private ProfileSedaVersion(String version) {
        this.version = version;
    }

    @JsonValue
    public String getVersion() {
        return this.version;
    }

    @JsonCreator
    public static ProfileSedaVersion forVersion(String version) throws IllegalArgumentException {
        if (version == null) {
            return DEFAULT;
        }
        return Optional.ofNullable(VERSION_MAP.get(version)).orElseThrow(() -> new IllegalArgumentException("Cannot find ProfileSedaVersion " + version));
    }

    static {
        DEFAULT = VERSION_2_3;
        VERSION_MAP = Stream.of(ProfileSedaVersion.values()).collect(Collectors.toMap(ProfileSedaVersion::getVersion, Function.identity()));
    }
}

