/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.logging;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.logging.FormattingTuple;
import fr.gouv.vitam.common.logging.SysErrLogger;
import java.util.HashMap;
import java.util.Map;

final class MessageFormatter {
    static final char DELIM_START = '{';
    static final char DELIM_STOP = '}';
    static final String DELIM_STR = "{}";
    private static final char ESCAPE_CHAR = '\\';

    private MessageFormatter() {
    }

    static final FormattingTuple format(String messagePattern, Object arg) {
        return MessageFormatter.arrayFormat(messagePattern, new Object[]{arg});
    }

    static final FormattingTuple format(String messagePattern, Object argA, Object argB) {
        return MessageFormatter.arrayFormat(messagePattern, new Object[]{argA, argB});
    }

    static final Throwable getThrowableCandidate(Object[] argArray) {
        if (argArray == null || argArray.length == 0) {
            return null;
        }
        Object lastEntry = argArray[argArray.length - 1];
        if (lastEntry instanceof Throwable) {
            return (Throwable)lastEntry;
        }
        return null;
    }

    static final FormattingTuple arrayFormat(String messagePattern, Object[] argArray) {
        int l;
        Throwable throwableCandidate = MessageFormatter.getThrowableCandidate(argArray);
        if (messagePattern == null) {
            return new FormattingTuple(null, argArray, throwableCandidate);
        }
        if (argArray == null) {
            return new FormattingTuple(messagePattern);
        }
        int i = 0;
        StringBuilder sbuild = new StringBuilder(messagePattern.length() + 50);
        for (l = 0; l < argArray.length; ++l) {
            int j = messagePattern.indexOf(DELIM_STR, i);
            if (j == -1) {
                if (i == 0) {
                    return new FormattingTuple(messagePattern, argArray, throwableCandidate);
                }
                sbuild.append(messagePattern.substring(i, messagePattern.length()));
                return new FormattingTuple(sbuild.toString(), argArray, throwableCandidate);
            }
            if (MessageFormatter.isEscapedDelimeter(messagePattern, j)) {
                if (!MessageFormatter.isDoubleEscaped(messagePattern, j)) {
                    --l;
                    sbuild.append(messagePattern.substring(i, j - 1)).append('{');
                    i = j + 1;
                    continue;
                }
                sbuild.append(messagePattern.substring(i, j - 1));
                MessageFormatter.deeplyAppendParameter(sbuild, argArray[l], new HashMap<Object[], Void>());
                i = j + 2;
                continue;
            }
            sbuild.append(messagePattern.substring(i, j));
            MessageFormatter.deeplyAppendParameter(sbuild, argArray[l], new HashMap<Object[], Void>());
            i = j + 2;
        }
        sbuild.append(messagePattern.substring(i, messagePattern.length()));
        if (l < argArray.length - 1) {
            return new FormattingTuple(sbuild.toString(), argArray, throwableCandidate);
        }
        return new FormattingTuple(sbuild.toString(), argArray, null);
    }

    static final boolean isEscapedDelimeter(String messagePattern, int delimeterStartIndex) {
        ParametersChecker.checkParameterNullOnly("Must not be null", messagePattern);
        if (delimeterStartIndex == 0) {
            return false;
        }
        return messagePattern.charAt(delimeterStartIndex - 1) == '\\';
    }

    static final boolean isDoubleEscaped(String messagePattern, int delimeterStartIndex) {
        ParametersChecker.checkParameterNullOnly("Must not be null", messagePattern);
        return delimeterStartIndex >= 2 && delimeterStartIndex - 2 > messagePattern.length() && messagePattern.charAt(delimeterStartIndex - 2) == '\\';
    }

    static final void deeplyAppendParameter(StringBuilder sbuild, Object o, Map<Object[], Void> seenMap) {
        if (o == null) {
            sbuild.append("null");
            return;
        }
        if (!o.getClass().isArray()) {
            MessageFormatter.safeObjectAppend(sbuild, o);
        } else if (o instanceof boolean[]) {
            MessageFormatter.booleanArrayAppend(sbuild, (boolean[])o);
        } else if (o instanceof byte[]) {
            MessageFormatter.byteArrayAppend(sbuild, (byte[])o);
        } else if (o instanceof char[]) {
            MessageFormatter.charArrayAppend(sbuild, (char[])o);
        } else if (o instanceof short[]) {
            MessageFormatter.shortArrayAppend(sbuild, (short[])o);
        } else if (o instanceof int[]) {
            MessageFormatter.intArrayAppend(sbuild, (int[])o);
        } else if (o instanceof long[]) {
            MessageFormatter.longArrayAppend(sbuild, (long[])o);
        } else if (o instanceof float[]) {
            MessageFormatter.floatArrayAppend(sbuild, (float[])o);
        } else if (o instanceof double[]) {
            MessageFormatter.doubleArrayAppend(sbuild, (double[])o);
        } else {
            MessageFormatter.objectArrayAppend(sbuild, (Object[])o, seenMap);
        }
    }

    private static final void safeObjectAppend(StringBuilder sbuild, Object o) {
        try {
            String oAsString = o.toString();
            sbuild.append(oAsString);
        }
        catch (Exception t) {
            SysErrLogger.FAKE_LOGGER.ignoreLog(t);
            SysErrLogger.FAKE_LOGGER.syserr("SLF4J: Failed toString() invocation on an object of type [" + o.getClass().getName() + "]" + t.getMessage());
            sbuild.append("[FAILED toString()]");
        }
    }

    private static final void objectArrayAppend(StringBuilder sbuild, Object[] a, Map<Object[], Void> seenMap) {
        sbuild.append('[');
        if (!seenMap.containsKey(a)) {
            seenMap.put(a, null);
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                MessageFormatter.deeplyAppendParameter(sbuild, a[i], seenMap);
                if (i == len - 1) continue;
                sbuild.append(", ");
            }
            seenMap.remove(a);
        } else {
            sbuild.append("...");
        }
        sbuild.append(']');
    }

    private static final void booleanArrayAppend(StringBuilder sbuild, boolean[] a) {
        sbuild.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuild.append(a[i]);
            if (i == len - 1) continue;
            sbuild.append(", ");
        }
        sbuild.append(']');
    }

    private static final void byteArrayAppend(StringBuilder sbuild, byte[] a) {
        sbuild.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuild.append(a[i]);
            if (i == len - 1) continue;
            sbuild.append(", ");
        }
        sbuild.append(']');
    }

    private static final void charArrayAppend(StringBuilder sbuild, char[] a) {
        sbuild.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuild.append(a[i]);
            if (i == len - 1) continue;
            sbuild.append(", ");
        }
        sbuild.append(']');
    }

    private static final void shortArrayAppend(StringBuilder sbuild, short[] a) {
        sbuild.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuild.append(a[i]);
            if (i == len - 1) continue;
            sbuild.append(", ");
        }
        sbuild.append(']');
    }

    private static final void intArrayAppend(StringBuilder sbuild, int[] a) {
        sbuild.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuild.append(a[i]);
            if (i == len - 1) continue;
            sbuild.append(", ");
        }
        sbuild.append(']');
    }

    private static final void longArrayAppend(StringBuilder sbuild, long[] a) {
        sbuild.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuild.append(a[i]);
            if (i == len - 1) continue;
            sbuild.append(", ");
        }
        sbuild.append(']');
    }

    private static final void floatArrayAppend(StringBuilder sbuild, float[] a) {
        sbuild.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuild.append(a[i]);
            if (i == len - 1) continue;
            sbuild.append(", ");
        }
        sbuild.append(']');
    }

    private static final void doubleArrayAppend(StringBuilder sbuild, double[] a) {
        sbuild.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuild.append(a[i]);
            if (i == len - 1) continue;
            sbuild.append(", ");
        }
        sbuild.append(']');
    }
}

