/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.logging;

import fr.gouv.vitam.common.ServerIdentityInterface;
import fr.gouv.vitam.common.logging.VitamLogLevel;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.io.ObjectStreamException;
import java.io.Serializable;

public abstract class AbstractVitamLogger
implements VitamLogger,
Serializable {
    private static final char PACKAGE_SEPARATOR_CHAR = '.';
    private static final long serialVersionUID = -6382972526573193470L;
    private static final String EXCEPTION_MESSAGE = "Unexpected exception:";
    static final String TIME_TRACE_PREFIX = "[TIMEINFO] ";
    private final String name;
    private boolean hasServerIdentity;

    protected AbstractVitamLogger(String name) {
        boolean bl = this.hasServerIdentity = VitamLoggerFactory.serverIdentity != null;
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isEnabled(VitamLogLevel level) {
        switch (level) {
            case TRACE: {
                return this.isTraceEnabled();
            }
            case DEBUG: {
                return this.isDebugEnabled();
            }
            case INFO: {
                return this.isInfoEnabled();
            }
            case WARN: {
                return this.isWarnEnabled();
            }
            case ERROR: {
                return this.isErrorEnabled();
            }
        }
        return true;
    }

    @Override
    public void trace(Throwable t) {
        this.trace(this.getMessagePrepend() + EXCEPTION_MESSAGE, t);
    }

    @Override
    public void debug(Throwable t) {
        this.debug(this.getMessagePrepend() + EXCEPTION_MESSAGE, t);
    }

    @Override
    public void info(Throwable t) {
        this.info(this.getMessagePrepend() + EXCEPTION_MESSAGE, t);
    }

    @Override
    public void warn(Throwable t) {
        this.warn(this.getMessagePrepend() + EXCEPTION_MESSAGE, t);
    }

    @Override
    public void error(Throwable t) {
        this.error(this.getMessagePrepend() + EXCEPTION_MESSAGE, t);
    }

    @Override
    public void log(VitamLogLevel level, String msg, Throwable cause) {
        String newmsg = this.getMessagePrepend() + msg;
        switch (level) {
            case TRACE: {
                this.trace(newmsg, cause);
                break;
            }
            case DEBUG: {
                this.debug(newmsg, cause);
                break;
            }
            case INFO: {
                this.info(newmsg, cause);
                break;
            }
            case WARN: {
                this.warn(newmsg, cause);
                break;
            }
            default: {
                this.error(newmsg, cause);
            }
        }
    }

    @Override
    public void log(VitamLogLevel level, Throwable cause) {
        switch (level) {
            case TRACE: {
                this.trace(this.getMessagePrepend() + cause.getMessage(), cause);
                break;
            }
            case DEBUG: {
                this.debug(this.getMessagePrepend() + cause.getMessage(), cause);
                break;
            }
            case INFO: {
                this.info(this.getMessagePrepend() + cause.getMessage(), cause);
                break;
            }
            case WARN: {
                this.warn(this.getMessagePrepend() + cause.getMessage(), cause);
                break;
            }
            default: {
                this.error(this.getMessagePrepend() + cause.getMessage(), cause);
            }
        }
    }

    @Override
    public void log(VitamLogLevel level, String msg) {
        String newmsg = this.getMessagePrepend() + msg;
        switch (level) {
            case TRACE: {
                this.trace(newmsg);
                break;
            }
            case DEBUG: {
                this.debug(newmsg);
                break;
            }
            case INFO: {
                this.info(newmsg);
                break;
            }
            case WARN: {
                this.warn(newmsg);
                break;
            }
            default: {
                this.error(newmsg);
            }
        }
    }

    @Override
    public void log(VitamLogLevel level, String format, Object arg) {
        String newmsg = this.getMessagePrepend() + format;
        switch (level) {
            case TRACE: {
                this.trace(newmsg, arg);
                break;
            }
            case DEBUG: {
                this.debug(newmsg, arg);
                break;
            }
            case INFO: {
                this.info(newmsg, arg);
                break;
            }
            case WARN: {
                this.warn(newmsg, arg);
                break;
            }
            default: {
                this.error(newmsg, arg);
            }
        }
    }

    @Override
    public void log(VitamLogLevel level, String format, Object argA, Object argB) {
        String newmsg = this.getMessagePrepend() + format;
        switch (level) {
            case TRACE: {
                this.trace(newmsg, argA, argB);
                break;
            }
            case DEBUG: {
                this.debug(newmsg, argA, argB);
                break;
            }
            case INFO: {
                this.info(newmsg, argA, argB);
                break;
            }
            case WARN: {
                this.warn(newmsg, argA, argB);
                break;
            }
            default: {
                this.error(newmsg, argA, argB);
            }
        }
    }

    @Override
    public void log(VitamLogLevel level, String format, Object ... arguments) {
        String newmsg = this.getMessagePrepend() + format;
        switch (level) {
            case TRACE: {
                this.trace(newmsg, arguments);
                break;
            }
            case DEBUG: {
                this.debug(newmsg, arguments);
                break;
            }
            case INFO: {
                this.info(newmsg, arguments);
                break;
            }
            case WARN: {
                this.warn(newmsg, arguments);
                break;
            }
            default: {
                this.error(newmsg, arguments);
            }
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        return VitamLoggerFactory.getInstance(this.name());
    }

    public static final String simpleClassName(Object o) {
        if (o == null) {
            return "null_object";
        }
        return AbstractVitamLogger.simpleClassName(o.getClass());
    }

    public static final String simpleClassName(Class<?> clazz) {
        if (clazz == null) {
            return "null_class";
        }
        String className = clazz.getName();
        int lastDotIdx = className.lastIndexOf(46);
        if (lastDotIdx > -1) {
            return className.substring(lastDotIdx + 1);
        }
        return className;
    }

    public String toString() {
        return AbstractVitamLogger.simpleClassName(this) + "(" + this.name() + ")";
    }

    final String getMessagePrepend() {
        if (this.hasServerIdentity) {
            return ((ServerIdentityInterface)VitamLoggerFactory.serverIdentity).getLoggerMessagePrepend();
        }
        return "";
    }
}

