/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.guid;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import fr.gouv.vitam.common.ServerIdentity;
import fr.gouv.vitam.common.SystemPropertyUtil;
import fr.gouv.vitam.common.exception.InvalidGuidOperationException;
import fr.gouv.vitam.common.guid.GUIDImpl;
import fr.gouv.vitam.common.logging.SysErrLogger;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.SecureRandom;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@class")
final class GUIDImplPrivate
extends GUIDImpl {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(GUIDImplPrivate.class);
    private static final String FR_GOUV_VITAM_PROCESS_ID = "fr.gouv.vitam.processId";
    private static final Object FORSYNC = new Object();
    private static final int MAX_PID = 0x400000;
    private static final int JVMPID;
    private static final SecureRandom RANDOM;
    private static volatile int counter;
    private static volatile long lastTimeStamp;

    GUIDImplPrivate() {
        this(0, 0, ServerIdentity.getInstance().getGlobalPlatformId(), false);
    }

    GUIDImplPrivate(int objectTypeId) {
        this(objectTypeId, 0, ServerIdentity.getInstance().getGlobalPlatformId(), false);
    }

    GUIDImplPrivate(int objectTypeId, int tenantId) {
        this(objectTypeId, tenantId, ServerIdentity.getInstance().getGlobalPlatformId(), false);
    }

    GUIDImplPrivate(boolean worm) {
        this(0, 0, ServerIdentity.getInstance().getGlobalPlatformId(), worm);
    }

    GUIDImplPrivate(int objectTypeId, boolean worm) {
        this(objectTypeId, 0, ServerIdentity.getInstance().getGlobalPlatformId(), worm);
    }

    GUIDImplPrivate(int objectTypeId, int tenantId, boolean worm) {
        this(objectTypeId, tenantId, ServerIdentity.getInstance().getGlobalPlatformId(), worm);
    }

    GUIDImplPrivate(int objectTypeId, int tenantId, int platformId) {
        this(objectTypeId, tenantId, platformId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GUIDImplPrivate(int objectTypeId, int tenantId, int platformId, boolean worm) {
        long time;
        int count;
        if (objectTypeId < 0 || objectTypeId > 255) {
            throw new IllegalArgumentException("Object Type ID must be between 0 and 255: " + objectTypeId);
        }
        if (tenantId < 0 || tenantId > 0x3FFFFFFF) {
            throw new IllegalArgumentException("DomainId must be between 0 and 2^30-1: " + tenantId);
        }
        if (platformId < 0) {
            throw new IllegalArgumentException("PlatformId must be between 0 and 2^31-1: " + platformId);
        }
        Object object = FORSYNC;
        synchronized (object) {
            long tmptime = System.currentTimeMillis();
            if (lastTimeStamp != tmptime) {
                counter = 0;
                lastTimeStamp = tmptime;
            }
            if ((count = ++counter) > 0xFFFFFF) {
                try {
                    FORSYNC.wait(1L);
                }
                catch (InterruptedException e) {
                    SysErrLogger.FAKE_LOGGER.ignoreLog(e);
                }
                tmptime = System.currentTimeMillis();
                counter = 0;
                lastTimeStamp = tmptime;
            }
            time = tmptime;
        }
        this.guid[0] = 1;
        this.guid[1] = (byte)(objectTypeId & 0xFF);
        int value = tenantId;
        this.guid[5] = (byte)(value & 0xFF);
        this.guid[4] = (byte)((value >>>= 8) & 0xFF);
        this.guid[3] = (byte)((value >>>= 8) & 0xFF);
        this.guid[2] = (byte)((value >>>= 8) & 0x3F);
        value = platformId;
        this.guid[9] = (byte)(value & 0xFF);
        this.guid[8] = (byte)((value >>>= 8) & 0xFF);
        this.guid[7] = (byte)((value >>>= 8) & 0xFF);
        this.guid[6] = worm ? (byte)(0x80 | value & 0x7F) : (byte)((value >>>= 8) & 0x7F);
        value = JVMPID;
        this.guid[12] = (byte)(value & 0xFF);
        this.guid[11] = (byte)((value >>>= 8) & 0xFF);
        this.guid[10] = (byte)((value >>>= 8) & 0xFF);
        long lvalue = time;
        this.guid[18] = (byte)(lvalue & 0xFFL);
        this.guid[17] = (byte)((lvalue >>>= 8) & 0xFFL);
        this.guid[16] = (byte)((lvalue >>>= 8) & 0xFFL);
        this.guid[15] = (byte)((lvalue >>>= 8) & 0xFFL);
        this.guid[14] = (byte)((lvalue >>>= 8) & 0xFFL);
        this.guid[13] = (byte)((lvalue >>>= 8) & 0xFFL);
        value = count;
        this.guid[21] = (byte)(value & 0xFF);
        this.guid[20] = (byte)((value >>>= 8) & 0xFF);
        this.guid[19] = (byte)((value >>>= 8) & 0xFF);
    }

    GUIDImplPrivate(byte[] bytes) throws InvalidGuidOperationException {
        super(bytes);
    }

    GUIDImplPrivate(String idsource) throws InvalidGuidOperationException {
        super(idsource);
    }

    private static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(ClassLoader::getSystemClassLoader);
    }

    static int jvmProcessId() {
        try {
            int processId = -1;
            String customProcessId = SystemPropertyUtil.getNoCheck(FR_GOUV_VITAM_PROCESS_ID);
            if (customProcessId != null) {
                processId = GUIDImplPrivate.parseProcessId(processId, customProcessId);
            }
            if (processId < 0) {
                Class[] emptyClasses;
                Object[] emptyObjects;
                ClassLoader loader = GUIDImplPrivate.getSystemClassLoader();
                String value = GUIDImplPrivate.jvmProcessIdManagementFactory(loader, emptyObjects = new Object[0], emptyClasses = new Class[0]);
                int atIndex = value.indexOf(64);
                if (atIndex >= 0) {
                    value = value.substring(0, atIndex);
                }
                if ((processId = GUIDImplPrivate.parseProcessId(processId, value)) < 0 || processId > 0x400000) {
                    processId = RANDOM.nextInt(0x400001);
                }
            }
            return processId;
        }
        catch (Exception e) {
            LOGGER.error("Error while getting JVMPID", e);
            return RANDOM.nextInt(0x400001);
        }
    }

    private static int parseProcessId(int oldProcessId, String customProcessId) {
        int processId = oldProcessId;
        try {
            processId = Integer.parseInt(customProcessId);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (processId < 0 || processId > 0x400000) {
            processId = -1;
        }
        return processId;
    }

    private static String jvmProcessIdManagementFactory(ClassLoader loader, Object[] emptyObjects, Class<?>[] emptyClasses) {
        String value;
        try {
            Class<?> mgmtFactoryType = Class.forName("java.lang.management.ManagementFactory", true, loader);
            Class<?> runtimeMxBeanType = Class.forName("java.lang.management.RuntimeMXBean", true, loader);
            Method getRuntimeMXBean = mgmtFactoryType.getMethod("getRuntimeMXBean", emptyClasses);
            Object bean = getRuntimeMXBean.invoke(null, emptyObjects);
            Method getName = runtimeMxBeanType.getDeclaredMethod("getName", emptyClasses);
            value = (String)getName.invoke(bean, emptyObjects);
        }
        catch (Exception e) {
            LOGGER.debug("Unable to get PID, try another way", e);
            try {
                Class<?> processType = Class.forName("android.os.Process", true, loader);
                Method myPid = processType.getMethod("myPid", emptyClasses);
                value = myPid.invoke(null, emptyObjects).toString();
            }
            catch (Exception e2) {
                LOGGER.debug("Unable to get PID", e2);
                value = "";
            }
        }
        return value;
    }

    static {
        RANDOM = new SecureRandom();
        JVMPID = GUIDImplPrivate.jvmProcessId();
        counter = 0;
        lastTimeStamp = 0L;
    }
}

