/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.Date;

public final class LocalDateUtil {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LocalDateUtil.class);
    private static final DateTimeFormatter DATE_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).appendPattern("[zz]").toFormatter();
    private static final DateTimeFormatter ZONED_DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm[:ss][.SSS][zz]");
    private static final DateTimeFormatter SLASHED_DATE = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    private static final DateTimeFormatter ISO_OFFSET_DATE_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_OFFSET_DATE).parseDefaulting(ChronoField.SECOND_OF_DAY, 0L).toFormatter();
    private static final DateTimeFormatter ISO_OFFSET_DATE_TIME_FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZZ";
    public static final String SIMPLE_DATE_FORMAT = "yyyy-MM-dd";
    private static final DateTimeFormatter INDEX_DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
    public static final String LONG_SECOND_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static LocalDateTime EPOCH = LocalDateTime.of(1970, 1, 1, 0, 0);
    private static Clock clock = Clock.systemUTC();

    private LocalDateUtil() {
    }

    public static String getString(LocalDateTime localDateTime) {
        return localDateTime.format(DateTimeFormatter.ISO_DATE_TIME);
    }

    public static String getStringFormatted(LocalDateTime localDateTime) {
        return localDateTime.format(DateTimeFormatter.ISO_DATE_TIME);
    }

    public static String getString(Date date) {
        return LocalDateUtil.fromDate(date).format(DateTimeFormatter.ISO_DATE_TIME);
    }

    public static LocalDateTime now() {
        return LocalDateTime.now(clock).truncatedTo(ChronoUnit.MILLIS);
    }

    public static LocalDate today() {
        return LocalDate.now(clock);
    }

    public static String nowFormatted() {
        return LocalDateUtil.getFormattedDateTimeForMongo(LocalDateUtil.now());
    }

    public static String todayFormatted() {
        return LocalDateUtil.today().toString();
    }

    public static Date getDate(String date) throws ParseException {
        ParametersChecker.checkParameter("Date", date);
        if (date.length() == SIMPLE_DATE_FORMAT.length()) {
            return LocalDateUtil.getSimpleFormattedDate(date);
        }
        if (date.indexOf(84) == -1) {
            return Date.from(LocalDate.parse(date, DateTimeFormatter.ISO_DATE).atStartOfDay(ZoneId.systemDefault()).toInstant());
        }
        return LocalDateUtil.getDate(LocalDateTime.parse(date, DATE_FORMATTER));
    }

    public static LocalDateTime fromDate(Date date) {
        if (date == null) {
            return LocalDateUtil.now();
        }
        return LocalDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC);
    }

    public static Date getDate(LocalDateTime ldt) {
        if (ldt == null) {
            return new Date();
        }
        return Date.from(ldt.toInstant(ZoneOffset.UTC));
    }

    public static String getFormattedDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        return dateFormat.format(date);
    }

    public static String getFormattedDate(LocalDateTime date) {
        return date.format(DateTimeFormatter.ofPattern(LONG_SECOND_DATE_FORMAT));
    }

    public static String getFormattedSimpleDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(SIMPLE_DATE_FORMAT);
        return dateFormat.format(date);
    }

    public static String getFormattedSimpleDate(LocalDate date) {
        return date.format(DateTimeFormatter.ofPattern(SIMPLE_DATE_FORMAT));
    }

    private static Date getSimpleFormattedDate(String date) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(SIMPLE_DATE_FORMAT);
        return dateFormat.parse(date);
    }

    public static LocalDate getLocalDateFromSimpleFormattedDate(String date) {
        if (date == null) {
            return LocalDate.now(clock);
        }
        return LocalDate.parse(date, DateTimeFormatter.ofPattern(SIMPLE_DATE_FORMAT));
    }

    public static String getFormattedDateTimeForMongo(String dateTime) {
        LocalDateTime ldt = LocalDateUtil.parseDateTime(dateTime);
        return LocalDateUtil.getFormattedDateTimeForMongo(ldt);
    }

    public static String getFormattedDateTimeForMongo(LocalDateTime date) {
        return date.format(ZONED_DATE_TIME_FORMAT);
    }

    public static String getFormattedDateForMongo(String dateTime) {
        return LocalDateUtil.getFormattedDateTimeForMongo(dateTime);
    }

    public static String getFormattedDateOnlyForMongo(String date) {
        LocalDate ld = LocalDateUtil.parseDateOnly(date);
        return LocalDateUtil.getFormattedSimpleDate(ld);
    }

    public static String getFormattedDateForMongo(LocalDateTime dateTime) {
        return LocalDateUtil.getFormattedDateTimeForMongo(dateTime);
    }

    public static String transformIsoOffsetDateToIsoOffsetDateTime(String date) {
        if (date == null) {
            return null;
        }
        try {
            TemporalAccessor parse1 = ISO_OFFSET_DATE_FORMATTER.parse(date);
            return ZonedDateTime.from(parse1).format(ISO_OFFSET_DATE_TIME_FORMATTER);
        }
        catch (DateTimeParseException exc) {
            return date;
        }
    }

    public static LocalDateTime parseMongoFormattedDate(String str) {
        return LocalDateTime.parse(str, ZONED_DATE_TIME_FORMAT);
    }

    public static LocalDate parseDate(String endDateStr) {
        if (endDateStr == null) {
            return null;
        }
        return LocalDate.parse(endDateStr, DateTimeFormatter.ISO_LOCAL_DATE);
    }

    static LocalDateTime parseDateTime(String dateTime) {
        LocalDateTime ldt;
        try {
            ldt = LocalDateTime.parse(dateTime, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
        catch (DateTimeParseException e) {
            LOGGER.debug("Cannot use ISO_LOCAL_DATE_TIME formatter, try with Zoned one");
            try {
                ldt = LocalDateTime.parse(dateTime, ZONED_DATE_TIME_FORMAT);
            }
            catch (DateTimeParseException ex) {
                LOGGER.debug("Cannot use Zoned LOCAL_DATE_TIME formatter, try with ISO_DATE one and time to 00:00:00.000");
                try {
                    ldt = LocalDate.parse(dateTime, DateTimeFormatter.ISO_DATE).atTime(0, 0, 0, 0);
                }
                catch (DateTimeParseException exc) {
                    LOGGER.debug("Cannot use ISO_DATE formatter, try with SLASH_DATE on and set time to 00:00:00.000");
                    ldt = LocalDate.parse(dateTime, SLASHED_DATE).atTime(0, 0, 0, 0);
                }
            }
        }
        return ldt;
    }

    static LocalDate parseDateOnly(String date) {
        LocalDate ld;
        try {
            ld = LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE);
        }
        catch (DateTimeParseException e) {
            LOGGER.debug("Cannot use ISO_LOCAL_DATE formatter, try with Zoned one");
            ld = LocalDate.parse(date, SLASHED_DATE);
        }
        return ld;
    }

    public static String getFormattedDateForEsIndexes(LocalDateTime localDateTime) {
        return localDateTime.format(INDEX_DATE_TIME_FORMAT);
    }

    public static DateTimeFormatter getDateTimeFormatterForFileNames() {
        return new DateTimeFormatterBuilder().appendPattern("yyyyMMddHHmmss").appendValue(ChronoField.MILLI_OF_SECOND, 3).toFormatter().withZone(ZoneOffset.UTC);
    }

    public static DateTimeFormatter getDateTimeFormatterForStorageTraceabilityFileNames() {
        return DateTimeFormatter.ofPattern("uuuuMMdd-HHmmss");
    }

    public static DateTimeFormatter getDateTimeFormatterForStorageLogFileNames() {
        return DateTimeFormatter.ofPattern("uuuuMMdd-HHmmssSSS");
    }

    public static long currentTimeMillis() {
        return clock.millis();
    }

    public static LocalDateTime max(LocalDateTime localDateTime1, LocalDateTime localDateTime2) {
        if (localDateTime1 == null) {
            return localDateTime2;
        }
        if (localDateTime2 == null) {
            return localDateTime1;
        }
        if (localDateTime1.isAfter(localDateTime2)) {
            return localDateTime1;
        }
        return localDateTime2;
    }

    public static LocalDateTime parse(String dateTimeStr, DateTimeFormatter formatter) {
        return LocalDateTime.from(formatter.parse(dateTimeStr));
    }

    public static LocalDateTime fromEpochMilliUTC(long epochMilli) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), ZoneOffset.UTC);
    }

    public static long toEpochMilliUTC(LocalDateTime localDateTime) {
        return localDateTime.atOffset(ZoneOffset.UTC).toInstant().toEpochMilli();
    }

    public static Instant getInstant() {
        return clock.instant();
    }

    @VisibleForTesting
    public static Clock getClock() {
        return clock;
    }

    @VisibleForTesting
    public static void setClock(Clock clock) {
        LocalDateUtil.clock = clock;
    }

    @VisibleForTesting
    public static void resetClock() {
        clock = Clock.systemUTC();
    }
}

