/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.elastic.kibana.interceptor.rest;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.elastic.kibana.interceptor.rest.InterceptorConfiguration;
import fr.gouv.vitam.elastic.kibana.interceptor.rest.ReplacePatternUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.io.IOUtils;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;

@Path(value="/")
public class InterceptorResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(InterceptorResource.class);
    private static final String UTF_8 = "UTF-8";
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String KEEP_ALIVE = "keep-alive";
    private static final String HOST = "Host";
    private static final String CONNECTION = "Connection";
    private static final String TRANSFER_ENCODING = "Transfer-encoding";
    private InterceptorConfiguration interceptorConfiguration;

    public InterceptorResource(InterceptorConfiguration interceptorConfiguration) {
        LOGGER.info("InterceptorResource initialized");
        this.interceptorConfiguration = interceptorConfiguration;
    }

    @HEAD
    @Path(value="{url: .*}")
    public Response handleHeadElasticRequestFromKibana(@Context UriInfo info, @PathParam(value="url") String url, @Context HttpServletRequest req, @Context HttpHeaders headers) {
        LOGGER.debug("Head sur " + String.valueOf(req.getRequestURL()));
        String urlEs = this.getUrlEs(req);
        ResteasyWebTarget target = ((ResteasyClientBuilder)ClientBuilder.newBuilder()).build().target(urlEs);
        for (Map.Entry entry : info.getQueryParameters().entrySet()) {
            for (String value : (List)entry.getValue()) {
                target = target.queryParam((String)entry.getKey(), new Object[]{value});
            }
        }
        Invocation.Builder request = target.request();
        this.setHeaderAndSuppressUndesiredOne(headers, request);
        return request.build("HEAD").invoke();
    }

    private void setHeaderAndSuppressUndesiredOne(@Context HttpHeaders headers, Invocation.Builder request) {
        headers.getRequestHeaders().forEach((key, value1) -> {
            LOGGER.debug("Header key " + key + "Header value " + String.valueOf(value1));
            for (String value : value1) {
                if (CONTENT_LENGTH.equals(key) || KEEP_ALIVE.equals(key) || HOST.equals(key) || CONNECTION.equals(key) || TRANSFER_ENCODING.equalsIgnoreCase((String)key)) continue;
                request.header(key, (Object)value);
            }
        });
    }

    private String getUrlEs(@Context HttpServletRequest req) {
        StringBuilder urlEs = new StringBuilder("http://").append(this.interceptorConfiguration.getElasticsearchNodes().get(0).getHostName()).append(":").append(this.interceptorConfiguration.getElasticsearchNodes().get(0).getHttpPort()).append(req.getRequestURI());
        LOGGER.debug("urlEs " + String.valueOf(urlEs));
        return urlEs.toString();
    }

    @GET
    @POST
    @OPTIONS
    @DELETE
    @PUT
    @Path(value="{url: .*}")
    public Response process(@PathParam(value="url") String url, @Context UriInfo info, @Context HttpServletRequest req, @Context HttpHeaders headers) throws IOException {
        Response response;
        LOGGER.debug(req.getMethod() + " sur " + String.valueOf(req.getRequestURL()));
        ReplacePatternUtils replacePatternUtils = new ReplacePatternUtils(this.interceptorConfiguration.getWhitelist());
        String urlEs = this.getUrlEs(req);
        ResteasyWebTarget target = ((ResteasyClientBuilder)ClientBuilder.newBuilder()).build().target(urlEs);
        for (Map.Entry entry : info.getQueryParameters().entrySet()) {
            for (String value : (List)entry.getValue()) {
                target = target.queryParam((String)entry.getKey(), new Object[]{value});
            }
        }
        Invocation.Builder request = target.request();
        this.setHeaderAndSuppressUndesiredOne(headers, request);
        if (headers.getMediaType() != null) {
            ServletInputStream inputStream = req.getInputStream();
            String requestBodyWithoutSharp = replacePatternUtils.replaceSharpByUnderscore(IOUtils.toString((InputStream)inputStream, (String)UTF_8));
            response = request.build(req.getMethod(), Entity.entity((Object)IOUtils.toInputStream((String)requestBodyWithoutSharp, (String)UTF_8), (MediaType)headers.getMediaType())).invoke();
        } else {
            response = request.build(req.getMethod()).invoke();
        }
        HashMap responseHeader = new HashMap();
        response.getHeaders().forEach((key, value1) -> {
            for (Object value : value1) {
                if (CONTENT_LENGTH.equalsIgnoreCase((String)key) || KEEP_ALIVE.equalsIgnoreCase((String)key) || HOST.equalsIgnoreCase((String)key) || CONNECTION.equalsIgnoreCase((String)key) || TRANSFER_ENCODING.equalsIgnoreCase((String)key)) continue;
                responseHeader.put(key, value);
            }
        });
        String entity = (String)response.readEntity(String.class);
        Response.ResponseBuilder responseWithoutHeader = Response.status((int)response.getStatus()).entity((Object)replacePatternUtils.replaceUnderscoreBySharp(entity));
        for (String key2 : responseHeader.keySet()) {
            responseWithoutHeader.header(key2, responseHeader.get(key2));
        }
        return responseWithoutHeader.build();
    }
}

