/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.scheduler.server.client;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.client.DefaultClient;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.VitamRequestBuilder;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.scheduler.server.client.SchedulerClient;
import javax.ws.rs.core.Response;

class SchedulerClientRest
extends DefaultClient
implements SchedulerClient {
    SchedulerClientRest(VitamClientFactoryInterface<?> factory) {
        super(factory);
    }

    @Override
    public RequestResponse<JsonNode> findCurrentJobs() throws VitamClientException {
        RequestResponse requestResponse;
        block8: {
            Response response = this.make(VitamRequestBuilder.get().withPath("/current-jobs").withJsonAccept());
            try {
                this.check(response);
                requestResponse = RequestResponseOK.parseFromResponse((Response)response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new VitamClientException((Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> findJobs() throws VitamClientException {
        RequestResponse requestResponse;
        block8: {
            Response response = this.make(VitamRequestBuilder.get().withPath("/jobs").withJsonAccept());
            try {
                this.check(response);
                requestResponse = RequestResponseOK.parseFromResponse((Response)response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new VitamClientException((Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponseOK<JsonNode> jobState(String jobName) throws VitamClientException {
        RequestResponseOK requestResponseOK;
        block8: {
            Response response = this.make(VitamRequestBuilder.get().withPath("/job-state/" + jobName).withJsonContentType());
            try {
                this.check(response);
                requestResponseOK = (RequestResponseOK)RequestResponseOK.parseFromResponse((Response)response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new VitamClientException((Throwable)e);
                }
            }
            response.close();
        }
        return requestResponseOK;
    }

    @Override
    public RequestResponse<JsonNode> scheduleJob(byte[] job) throws VitamClientException {
        RequestResponse requestResponse;
        block8: {
            Response response = this.make(VitamRequestBuilder.post().withPath("/schedule-job").withBody((Object)job).withJson());
            try {
                this.check(response);
                requestResponse = RequestResponseOK.parseFromResponse((Response)response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new VitamClientException((Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> triggerJob(String jobName) throws VitamClientException {
        RequestResponse requestResponse;
        block8: {
            Response response = this.make(VitamRequestBuilder.post().withPath("/trigger-job/" + jobName).withJson());
            try {
                this.check(response);
                requestResponse = RequestResponseOK.parseFromResponse((Response)response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new VitamClientException((Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> triggerJob(String jobName, JsonNode jobDataMap) throws VitamClientException {
        RequestResponse requestResponse;
        block8: {
            Response response = this.make(VitamRequestBuilder.post().withPath("/trigger-job/" + jobName).withBody((Object)jobDataMap).withJson());
            try {
                this.check(response);
                requestResponse = RequestResponseOK.parseFromResponse((Response)response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new VitamClientException((Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> triggerJob(byte[] trigger) throws VitamClientException {
        RequestResponse requestResponse;
        block8: {
            Response response = this.make(VitamRequestBuilder.post().withPath("/trigger-job").withBody((Object)trigger).withJson());
            try {
                this.check(response);
                requestResponse = RequestResponseOK.parseFromResponse((Response)response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new VitamClientException((Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    private void check(Response response) throws VitamClientInternalException {
        Response.Status status = response.getStatusInfo().toEnum();
        if (Response.Status.Family.SUCCESSFUL.equals((Object)status.getFamily()) || Response.Status.Family.REDIRECTION.equals((Object)status.getFamily())) {
            return;
        }
        throw new VitamClientInternalException(String.format("Error with the response, get status: '%d' and reason '%s'.", response.getStatus(), Response.Status.fromStatusCode((int)response.getStatus()).getReasonPhrase()));
    }
}

