/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.batch.report.rest.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.mongodb.client.MongoCursor;
import fr.gouv.vitam.batch.report.exception.BatchReportException;
import fr.gouv.vitam.batch.report.model.AuditObjectGroupModel;
import fr.gouv.vitam.batch.report.model.EliminationActionUnitModel;
import fr.gouv.vitam.batch.report.model.EvidenceAuditObjectModel;
import fr.gouv.vitam.batch.report.model.EvidenceStatus;
import fr.gouv.vitam.batch.report.model.MergeSortedIterator;
import fr.gouv.vitam.batch.report.model.PurgeAccessionRegisterModel;
import fr.gouv.vitam.batch.report.model.PurgeObjectGroupModel;
import fr.gouv.vitam.batch.report.model.PurgeUnitModel;
import fr.gouv.vitam.batch.report.model.Report;
import fr.gouv.vitam.batch.report.model.ReportExportRequest;
import fr.gouv.vitam.batch.report.model.ReportResults;
import fr.gouv.vitam.batch.report.model.TraceabilityObjectModel;
import fr.gouv.vitam.batch.report.model.TransferReplyUnitModel;
import fr.gouv.vitam.batch.report.model.UnitComputedInheritedRulesInvalidationModel;
import fr.gouv.vitam.batch.report.model.entry.AuditObjectGroupReportEntry;
import fr.gouv.vitam.batch.report.model.entry.BulkUpdateUnitMetadataReportEntry;
import fr.gouv.vitam.batch.report.model.entry.DeleteGotVersionsComputedDetails;
import fr.gouv.vitam.batch.report.model.entry.DeleteGotVersionsReportEntry;
import fr.gouv.vitam.batch.report.model.entry.EliminationActionUnitReportEntry;
import fr.gouv.vitam.batch.report.model.entry.EvidenceAuditReportEntry;
import fr.gouv.vitam.batch.report.model.entry.PreservationReportEntry;
import fr.gouv.vitam.batch.report.model.entry.PurgeObjectGroupReportEntry;
import fr.gouv.vitam.batch.report.model.entry.PurgeUnitReportEntry;
import fr.gouv.vitam.batch.report.model.entry.TraceabilityReportEntry;
import fr.gouv.vitam.batch.report.model.entry.TransferReplyUnitReportEntry;
import fr.gouv.vitam.batch.report.model.entry.UnitComputedInheritedRulesInvalidationReportEntry;
import fr.gouv.vitam.batch.report.model.entry.UpdateUnitMetadataReportEntry;
import fr.gouv.vitam.batch.report.rest.repository.AuditReportRepository;
import fr.gouv.vitam.batch.report.rest.repository.BulkUpdateUnitMetadataReportRepository;
import fr.gouv.vitam.batch.report.rest.repository.DeleteGotVersionsReportRepository;
import fr.gouv.vitam.batch.report.rest.repository.EliminationActionUnitRepository;
import fr.gouv.vitam.batch.report.rest.repository.EvidenceAuditReportRepository;
import fr.gouv.vitam.batch.report.rest.repository.ExtractedMetadataRepository;
import fr.gouv.vitam.batch.report.rest.repository.PreservationReportRepository;
import fr.gouv.vitam.batch.report.rest.repository.PurgeObjectGroupRepository;
import fr.gouv.vitam.batch.report.rest.repository.PurgeUnitRepository;
import fr.gouv.vitam.batch.report.rest.repository.TraceabilityReportRepository;
import fr.gouv.vitam.batch.report.rest.repository.TransferReplyUnitRepository;
import fr.gouv.vitam.batch.report.rest.repository.UnitComputedInheritedRulesInvalidationRepository;
import fr.gouv.vitam.batch.report.rest.repository.UpdateUnitReportRepository;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.database.server.mongodb.BsonHelper;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ExtractedMetadata;
import fr.gouv.vitam.common.model.processing.WorkFlowExecutionContext;
import fr.gouv.vitam.common.security.IllegalPathException;
import fr.gouv.vitam.common.security.SafeFileChecker;
import fr.gouv.vitam.worker.core.distribution.JsonLineModel;
import fr.gouv.vitam.worker.core.distribution.JsonLineWriter;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;

public class BatchReportServiceImpl {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(BatchReportServiceImpl.class);
    private static final String JSONL_EXTENSION = ".jsonl";
    private static final String REPORT_JSONL = "report.jsonl";
    private final EliminationActionUnitRepository eliminationActionUnitRepository;
    private final PurgeUnitRepository purgeUnitRepository;
    private final PurgeObjectGroupRepository purgeObjectGroupRepository;
    private final TransferReplyUnitRepository transferReplyUnitRepository;
    private final PreservationReportRepository preservationReportRepository;
    private final UpdateUnitReportRepository updateUnitReportRepository;
    private final BulkUpdateUnitMetadataReportRepository bulkUpdateUnitMetadataReportRepository;
    private final AuditReportRepository auditReportRepository;
    private final UnitComputedInheritedRulesInvalidationRepository unitComputedInheritedRulesInvalidationRepository;
    private final EvidenceAuditReportRepository evidenceAuditReportRepository;
    private final TraceabilityReportRepository traceabilityReportRepository;
    private final ExtractedMetadataRepository extractedMetadataRepository;
    private final DeleteGotVersionsReportRepository deleteGotVersionsReportRepository;
    private final WorkspaceClientFactory workspaceClientFactory;

    public BatchReportServiceImpl(WorkspaceClientFactory workspaceClientFactory, EliminationActionUnitRepository eliminationActionUnitRepository, PurgeUnitRepository purgeUnitRepository, PurgeObjectGroupRepository purgeObjectGroupRepository, TransferReplyUnitRepository transferReplyUnitRepository, UpdateUnitReportRepository updateUnitReportRepository, BulkUpdateUnitMetadataReportRepository bulkUpdateUnitMetadataReportRepository, PreservationReportRepository preservationReportRepository, AuditReportRepository auditReportRepository, UnitComputedInheritedRulesInvalidationRepository unitComputedInheritedRulesInvalidationRepository, EvidenceAuditReportRepository evidenceAuditReportRepository, TraceabilityReportRepository traceabilityReportRepository, ExtractedMetadataRepository extractedMetadataRepository, DeleteGotVersionsReportRepository deleteGotVersionsReportRepository) {
        this(eliminationActionUnitRepository, purgeUnitRepository, purgeObjectGroupRepository, transferReplyUnitRepository, updateUnitReportRepository, bulkUpdateUnitMetadataReportRepository, preservationReportRepository, auditReportRepository, unitComputedInheritedRulesInvalidationRepository, evidenceAuditReportRepository, traceabilityReportRepository, extractedMetadataRepository, deleteGotVersionsReportRepository, workspaceClientFactory);
    }

    @VisibleForTesting
    public BatchReportServiceImpl(EliminationActionUnitRepository eliminationActionUnitRepository, PurgeUnitRepository purgeUnitRepository, PurgeObjectGroupRepository purgeObjectGroupRepository, TransferReplyUnitRepository transferReplyUnitRepository, UpdateUnitReportRepository updateUnitReportRepository, BulkUpdateUnitMetadataReportRepository bulkUpdateUnitMetadataReportRepository, PreservationReportRepository preservationReportRepository, AuditReportRepository auditReportRepository, UnitComputedInheritedRulesInvalidationRepository unitComputedInheritedRulesInvalidationRepository, EvidenceAuditReportRepository evidenceAuditReportRepository, TraceabilityReportRepository traceabilityReportRepository, ExtractedMetadataRepository extractedMetadataRepository, DeleteGotVersionsReportRepository deleteGotVersionsReportRepository, WorkspaceClientFactory workspaceClientFactory) {
        this.eliminationActionUnitRepository = eliminationActionUnitRepository;
        this.purgeUnitRepository = purgeUnitRepository;
        this.purgeObjectGroupRepository = purgeObjectGroupRepository;
        this.transferReplyUnitRepository = transferReplyUnitRepository;
        this.updateUnitReportRepository = updateUnitReportRepository;
        this.bulkUpdateUnitMetadataReportRepository = bulkUpdateUnitMetadataReportRepository;
        this.preservationReportRepository = preservationReportRepository;
        this.auditReportRepository = auditReportRepository;
        this.unitComputedInheritedRulesInvalidationRepository = unitComputedInheritedRulesInvalidationRepository;
        this.evidenceAuditReportRepository = evidenceAuditReportRepository;
        this.traceabilityReportRepository = traceabilityReportRepository;
        this.extractedMetadataRepository = extractedMetadataRepository;
        this.deleteGotVersionsReportRepository = deleteGotVersionsReportRepository;
        this.workspaceClientFactory = workspaceClientFactory;
    }

    public void appendEliminationActionUnitReport(String processId, List<EliminationActionUnitReportEntry> entries, int tenantId) {
        List<EliminationActionUnitModel> documents = entries.stream().map(unitEntry -> new EliminationActionUnitModel(processId, tenantId, LocalDateUtil.nowFormatted(), unitEntry)).collect(Collectors.toList());
        this.eliminationActionUnitRepository.bulkAppendReport(documents);
    }

    public void appendPurgeUnitReport(String processId, List<PurgeUnitReportEntry> entries, int tenantId) {
        List<PurgeUnitModel> documents = entries.stream().map(unitEntry -> new PurgeUnitModel(processId, tenantId, LocalDateUtil.nowFormatted(), unitEntry)).collect(Collectors.toList());
        this.purgeUnitRepository.bulkAppendReport(documents);
    }

    public void appendPurgeObjectGroupReport(String processId, List<PurgeObjectGroupReportEntry> entries, int tenantId) {
        List<PurgeObjectGroupModel> documents = entries.stream().map(ogEntry -> new PurgeObjectGroupModel(processId, LocalDateUtil.nowFormatted(), ogEntry, tenantId)).collect(Collectors.toList());
        this.purgeObjectGroupRepository.bulkAppendReport(documents);
    }

    public void appendTransferReplyUnitReport(String processId, List<TransferReplyUnitReportEntry> entries, int tenantId) {
        List<TransferReplyUnitModel> documents = entries.stream().map(unitEntry -> new TransferReplyUnitModel(processId, tenantId, LocalDateUtil.nowFormatted(), unitEntry)).collect(Collectors.toList());
        this.transferReplyUnitRepository.bulkAppendReport(documents);
    }

    public void appendPreservationReport(String processId, List<PreservationReportEntry> preservationEntries, int tenantId) throws BatchReportException {
        List<PreservationReportEntry> documents = preservationEntries.stream().map(preservationEntry -> this.checkValuesAndGetNewPreservationReportEntry(processId, tenantId, (PreservationReportEntry)preservationEntry)).collect(Collectors.toList());
        this.preservationReportRepository.bulkAppendReport(documents);
    }

    public void appendUnitReport(List<UpdateUnitMetadataReportEntry> unitEntries) {
        this.updateUnitReportRepository.bulkAppendReport(unitEntries);
    }

    public void appendBulkUpdateUnitMetadataReport(List<BulkUpdateUnitMetadataReportEntry> unitEntries) {
        this.bulkUpdateUnitMetadataReportRepository.bulkAppendReport(unitEntries);
    }

    public void appendUnitComputedInheritedRulesInvalidationReport(String processId, List<UnitComputedInheritedRulesInvalidationReportEntry> unitEntries, int tenantId) throws BatchReportException {
        List<UnitComputedInheritedRulesInvalidationModel> documents = unitEntries.stream().map(entry -> new UnitComputedInheritedRulesInvalidationModel(processId, tenantId, LocalDateUtil.nowFormatted(), entry)).collect(Collectors.toList());
        this.unitComputedInheritedRulesInvalidationRepository.bulkAppendReport(documents);
    }

    public void appendDeleteGotVersionsReport(List<DeleteGotVersionsReportEntry> unitEntries) {
        this.deleteGotVersionsReportRepository.bulkAppendReport(unitEntries);
    }

    public void deleteUnitComputedInheritedRulesInvalidationReport(String processId, int tenantId) {
        this.unitComputedInheritedRulesInvalidationRepository.deleteReportByIdAndTenant(processId, tenantId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportUnitsToInvalidate(String processId, int tenantId, ReportExportRequest reportExportRequest, WorkFlowExecutionContext executionContext) throws IOException, ContentAddressableStorageServerException, IllegalPathException {
        File file = this.createTemporaryFile(processId, reportExportRequest.getFilename());
        try {
            try (FileOutputStream outputStream = new FileOutputStream(file);
                 JsonLineWriter jsonLineWriter = new JsonLineWriter((OutputStream)outputStream);
                 CloseableIterator<Document> units = this.unitComputedInheritedRulesInvalidationRepository.findCollectionByProcessIdTenant(processId, tenantId);){
                while (units.hasNext()) {
                    Document unit = (Document)units.next();
                    jsonLineWriter.addEntry(new JsonLineModel((String)unit.get((Object)"id")));
                }
            }
            this.storeFileToWorkspace(processId, reportExportRequest.getFilename(), file);
        }
        finally {
            this.deleteQuietly(file.getParentFile());
        }
    }

    private PreservationReportEntry checkValuesAndGetNewPreservationReportEntry(String processId, int tenantId, PreservationReportEntry entry) {
        this.checkIfPresent("UnitId", entry.getUnitId());
        this.checkIfPresent("ObjectGroupId", entry.getObjectGroupId());
        this.checkIfPresent("Action", entry.getAction());
        this.checkIfPresent("InputObjectId", entry.getInputObjectId());
        this.checkIfPresent("GriffinId", entry.getGriffinId());
        return new PreservationReportEntry(GUIDFactory.newGUID().toString(), processId, tenantId, LocalDateUtil.nowFormatted(), entry.getStatus(), entry.getUnitId(), entry.getObjectGroupId(), entry.getAction(), entry.getAnalyseResult(), entry.getInputObjectId(), entry.getOutputObjectId(), entry.getOutcome(), entry.getGriffinId(), entry.getPreservationScenarioId());
    }

    public void appendAuditReport(String processId, List<AuditObjectGroupReportEntry> auditEntries, int tenantId) {
        List<AuditObjectGroupModel> documents = auditEntries.stream().map(auditEntry -> this.checkValuesAndGetAuditObjectGroupModel(processId, tenantId, (AuditObjectGroupReportEntry)auditEntry)).collect(Collectors.toList());
        this.auditReportRepository.bulkAppendReport(documents);
    }

    public void appendEvidenceAuditReport(String processId, List<EvidenceAuditReportEntry> auditEntries, int tenantId) throws BatchReportException {
        List<EvidenceAuditObjectModel> documents = auditEntries.stream().map(auditEntry -> this.checkValuesAndGetEvidenceAuditObjectGroupModel(processId, tenantId, (EvidenceAuditReportEntry)auditEntry)).collect(Collectors.toList());
        this.evidenceAuditReportRepository.bulkAppendReport(documents);
    }

    public void appendTraceabilityReport(String processId, List<TraceabilityReportEntry> entries, int tenantId) {
        List<TraceabilityObjectModel> documents = entries.stream().peek(this::checkTraceabilityObjectModelValues).map(reportEntry -> new TraceabilityObjectModel(processId, reportEntry, tenantId)).collect(Collectors.toList());
        this.traceabilityReportRepository.bulkAppendReport(documents);
    }

    private void checkTraceabilityObjectModelValues(TraceabilityReportEntry traceabilityReportEntry) {
        this.checkIfPresent("operationId", traceabilityReportEntry.getOperationId());
        this.checkIfPresent("operationType", traceabilityReportEntry.getOperationType());
        this.checkIfPresent("status", traceabilityReportEntry.getStatus());
    }

    private AuditObjectGroupModel checkValuesAndGetAuditObjectGroupModel(String processId, int tenantId, AuditObjectGroupReportEntry auditEntry) {
        this.checkIfPresent("DetailId", auditEntry.getDetailId());
        this.checkIfPresent("Outcome", auditEntry.getOutcome());
        this.checkIfPresent("DetailType", auditEntry.getDetailType());
        this.checkIfPresent("Opi", auditEntry.getOpi());
        this.checkIfPresent("OriginatingAgency", auditEntry.getOriginatingAgency());
        this.checkIfPresent("ParentUnitIds", auditEntry.getParentUnitIds());
        this.checkIfPresent("Status", auditEntry.getStatus());
        return new AuditObjectGroupModel(processId, LocalDateUtil.nowFormatted(), auditEntry, tenantId);
    }

    private EvidenceAuditObjectModel checkValuesAndGetEvidenceAuditObjectGroupModel(String processId, int tenantId, EvidenceAuditReportEntry evidenceAuditEntry) {
        this.checkIfPresent("identifier", evidenceAuditEntry.getIdentifier());
        this.checkIfPresent("status", evidenceAuditEntry.getEvidenceStatus());
        this.checkIfPresent("message", evidenceAuditEntry.getMessage());
        this.checkIfPresent("strategyId", evidenceAuditEntry.getStrategyId());
        this.checkIfPresent("objectType", evidenceAuditEntry.getObjectType());
        return new EvidenceAuditObjectModel(processId, tenantId, LocalDateUtil.nowFormatted(), evidenceAuditEntry);
    }

    private void checkIfPresent(String name, Object value) throws BatchReportException {
        if (value == null) {
            throw new BatchReportException(String.format("field Name mandatory %s", name));
        }
    }

    private void writeDocumentsInFile(JsonLineWriter reportWriter, MongoCursor<Document> documentsIterator) throws IOException {
        while (documentsIterator.hasNext()) {
            Document document = (Document)documentsIterator.next();
            reportWriter.addEntry((Object)document);
        }
    }

    private JsonNode getExtendedInfo(Report reportInfo) throws InvalidParseOperationException {
        switch (reportInfo.getReportSummary().getReportType()) {
            case PRESERVATION: {
                return JsonHandler.toJsonNode((Object)this.preservationReportRepository.stats(reportInfo.getOperationSummary().getEvId(), reportInfo.getOperationSummary().getTenant()));
            }
            case AUDIT: {
                return JsonHandler.toJsonNode((Object)this.auditReportRepository.stats(reportInfo.getOperationSummary().getEvId(), reportInfo.getOperationSummary().getTenant()));
            }
            case EVIDENCE_AUDIT: {
                return JsonHandler.toJsonNode((Object)this.evidenceAuditReportRepository.stats(reportInfo.getOperationSummary().getEvId(), reportInfo.getOperationSummary().getTenant()));
            }
            case TRACEABILITY: {
                return JsonHandler.toJsonNode((Object)this.traceabilityReportRepository.stats(reportInfo.getOperationSummary().getEvId(), reportInfo.getOperationSummary().getTenant()));
            }
        }
        return reportInfo.getReportSummary().getExtendedInfo();
    }

    private ReportResults getReportResults(Report reportInfo) {
        switch (reportInfo.getReportSummary().getReportType()) {
            case AUDIT: {
                return this.auditReportRepository.computeVitamResults(reportInfo.getOperationSummary().getEvId(), reportInfo.getOperationSummary().getTenant());
            }
            case EVIDENCE_AUDIT: {
                return this.evidenceAuditReportRepository.computeVitamResults(reportInfo.getOperationSummary().getEvId(), reportInfo.getOperationSummary().getTenant());
            }
            case TRACEABILITY: {
                return this.traceabilityReportRepository.computeVitamResults(reportInfo.getOperationSummary().getEvId(), reportInfo.getOperationSummary().getTenant());
            }
            case DELETE_GOT_VERSIONS: {
                return this.deleteGotVersionsReportRepository.computeVitamResults(reportInfo.getOperationSummary().getEvId(), reportInfo.getOperationSummary().getTenant());
            }
        }
        return reportInfo.getReportSummary().getVitamResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void storeFileToWorkspace(Report reportInfo) throws IOException, ContentAddressableStorageServerException, InvalidParseOperationException, IllegalPathException {
        operationSummary = reportInfo.getOperationSummary();
        processId = operationSummary.getEvId();
        tenantId = operationSummary.getTenant();
        reportSummary = reportInfo.getReportSummary();
        reportSummary.setExtendedInfo(this.getExtendedInfo(reportInfo));
        reportSummary.setVitamResults(this.getReportResults(reportInfo));
        tempReport = this.createTemporaryFile(processId, "report.jsonl");
        reportWriter = new JsonLineWriter((OutputStream)new FileOutputStream(tempReport));
        try {
            reportWriter.addEntry((Object)operationSummary);
            reportWriter.addEntry((Object)reportSummary);
            reportWriter.addEntry((Object)reportInfo.getContext());
            switch (1.$SwitchMap$fr$gouv$vitam$batch$report$model$ReportType[reportSummary.getReportType().ordinal()]) {
                case 6: {
                    eliminationArchiveUnitIterator = this.eliminationActionUnitRepository.findCollectionByProcessIdTenant(processId, tenantId);
                    this.writeDocumentsInFile(reportWriter, eliminationArchiveUnitIterator);
                    purgeUnitIterator = this.purgeUnitRepository.findCollectionByProcessIdTenant(processId, tenantId);
                    this.writeDocumentsInFile(reportWriter, purgeUnitIterator);
                    objectGroupIterator = this.purgeObjectGroupRepository.findCollectionByProcessIdTenant(processId, tenantId);
                    this.writeDocumentsInFile(reportWriter, objectGroupIterator);
                    ** break;
lbl22:
                    // 1 sources

                    break;
                }
                case 7: {
                    transferReplyUnitIterator = this.transferReplyUnitRepository.findCollectionByProcessIdTenant(processId, tenantId);
                    this.writeDocumentsInFile(reportWriter, transferReplyUnitIterator);
                    purgeUnitIterator = this.purgeUnitRepository.findCollectionByProcessIdTenant(processId, tenantId);
                    this.writeDocumentsInFile(reportWriter, purgeUnitIterator);
                    objectGroupIterator = this.purgeObjectGroupRepository.findCollectionByProcessIdTenant(processId, tenantId);
                    this.writeDocumentsInFile(reportWriter, objectGroupIterator);
                    ** break;
lbl31:
                    // 1 sources

                    break;
                }
                case 1: {
                    preservationIterator = this.preservationReportRepository.findCollectionByProcessIdTenant(processId, tenantId);
                    this.writeDocumentsInFile(reportWriter, preservationIterator);
                    ** break;
lbl36:
                    // 1 sources

                    break;
                }
                case 2: {
                    auditIterator = this.auditReportRepository.findCollectionByProcessIdTenantAndStatus(processId, tenantId, new String[]{"WARNING", "KO"});
                    this.writeDocumentsInFile(reportWriter, auditIterator);
                    ** break;
lbl41:
                    // 1 sources

                    break;
                }
                case 3: {
                    evidenceAuditIterator = this.evidenceAuditReportRepository.findCollectionByProcessIdTenantAndStatus(processId, tenantId, new String[]{EvidenceStatus.WARN.name(), EvidenceStatus.KO.name()});
                    this.writeDocumentsInFile(reportWriter, evidenceAuditIterator);
                    ** break;
lbl46:
                    // 1 sources

                    break;
                }
                case 4: {
                    traceabilityIterator = this.traceabilityReportRepository.findCollection(processId, tenantId);
                    this.writeDocumentsInFile(reportWriter, traceabilityIterator);
                    ** break;
lbl51:
                    // 1 sources

                    break;
                }
                case 8: {
                    updates = this.updateUnitReportRepository.findCollectionByProcessIdTenant(processId, tenantId);
                    this.writeDocumentsInFile(reportWriter, updates);
                    ** break;
lbl56:
                    // 1 sources

                    break;
                }
                case 9: {
                    bulkUpdates = this.bulkUpdateUnitMetadataReportRepository.findCollectionByProcessIdTenant(processId, tenantId);
                    this.writeDocumentsInFile(reportWriter, bulkUpdates);
                    ** break;
lbl61:
                    // 1 sources

                    break;
                }
                case 5: {
                    deleteGotVersionsIterator = this.deleteGotVersionsReportRepository.findCollectionByProcessIdTenant(processId, tenantId);
                    this.writeDocumentsInFile(reportWriter, deleteGotVersionsIterator);
                    ** break;
lbl66:
                    // 1 sources

                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unsupported report type : '%s'.", new Object[]{reportSummary.getReportType()}));
                }
            }
        }
        finally {
            reportWriter.close();
        }
        try {
            this.storeFileToWorkspace(processId, "report.jsonl", tempReport);
        }
        finally {
            this.deleteQuietly(tempReport.getParentFile());
        }
    }

    public List<DeleteGotVersionsComputedDetails> readDeletedGotVersionsComputedDetailsFromReport(String processId, int tenantId) throws InvalidParseOperationException {
        ArrayList<DeleteGotVersionsComputedDetails> deleteGotVersionsComputedDetails = new ArrayList<DeleteGotVersionsComputedDetails>();
        MongoCursor<Document> deleteGotVersionsIteratorComputed = this.deleteGotVersionsReportRepository.computeDeleteGotVersionsEntriesByProcessIdTenant(processId, tenantId);
        while (deleteGotVersionsIteratorComputed.hasNext()) {
            deleteGotVersionsComputedDetails.add((DeleteGotVersionsComputedDetails)BsonHelper.fromDocumentToObject((Document)((Document)deleteGotVersionsIteratorComputed.next()), DeleteGotVersionsComputedDetails.class));
        }
        return deleteGotVersionsComputedDetails;
    }

    private void createFileFromTwoMongoCursorWithDocument(File tempFile, MongoCursor<Document> unitCursor, MongoCursor<Document> objectGroupCursor) throws IOException, InvalidParseOperationException {
        Comparator<Document> comparator = this.compareDocument();
        BiFunction<Document, Document, PurgeAccessionRegisterModel> mergeFunction = this.mergeDocuments();
        MergeSortedIterator mergeSortedIterator = new MergeSortedIterator(unitCursor, objectGroupCursor, comparator, mergeFunction);
        try (JsonLineWriter jsonLineWriter = new JsonLineWriter((OutputStream)new FileOutputStream(tempFile));){
            while (mergeSortedIterator.hasNext()) {
                PurgeAccessionRegisterModel purgeAccessionRegisterModel = (PurgeAccessionRegisterModel)mergeSortedIterator.next();
                JsonLineModel jsonLineModel = new JsonLineModel();
                jsonLineModel.setId(purgeAccessionRegisterModel.getOpi());
                jsonLineModel.setParams(JsonHandler.toJsonNode((Object)purgeAccessionRegisterModel));
                jsonLineWriter.addEntry(jsonLineModel);
            }
        }
    }

    private BiFunction<Document, Document, PurgeAccessionRegisterModel> mergeDocuments() {
        return (unit, objectGroup) -> {
            PurgeAccessionRegisterModel purgeAccessionRegisterModel = new PurgeAccessionRegisterModel();
            if (unit != null) {
                purgeAccessionRegisterModel.setOpi(unit.getString((Object)"opi"));
                purgeAccessionRegisterModel.setOriginatingAgency(unit.getString((Object)"originatingAgency"));
                purgeAccessionRegisterModel.setTotalUnits(((Number)unit.get((Object)"totalUnits")).longValue());
            }
            if (objectGroup != null) {
                purgeAccessionRegisterModel.setOpi(objectGroup.getString((Object)"opi"));
                purgeAccessionRegisterModel.setOriginatingAgency(objectGroup.getString((Object)"originatingAgency"));
                purgeAccessionRegisterModel.setTotalObjectGroups(((Number)objectGroup.get((Object)"totalObjectGroups")).longValue());
                purgeAccessionRegisterModel.setTotalObjects(((Number)objectGroup.get((Object)"totalObjects")).longValue());
                purgeAccessionRegisterModel.setTotalSize(((Number)objectGroup.get((Object)"totalSize")).longValue());
            }
            return purgeAccessionRegisterModel;
        };
    }

    private Comparator<Document> compareDocument() {
        return (unit, objectGroup) -> {
            String opiUnit = unit == null ? null : unit.getString((Object)"opi");
            String opiObjectGroup = objectGroup == null ? null : objectGroup.getString((Object)"opi");
            return StringUtils.compare((String)opiUnit, (String)opiObjectGroup);
        };
    }

    private void createFileFromMongoCursorWithString(File tempFile, MongoCursor<String> iterator) throws IOException {
        try (JsonLineWriter jsonLineWriter = new JsonLineWriter((OutputStream)new FileOutputStream(tempFile));){
            while (iterator.hasNext()) {
                String objectGroupId = (String)iterator.next();
                JsonLineModel jsonLineModel = this.getJsonLineModelWithString(objectGroupId);
                jsonLineWriter.addEntry(jsonLineModel);
            }
        }
    }

    private JsonLineModel getJsonLineModelWithString(String next) {
        return new JsonLineModel(next, null, null);
    }

    private void storeFileToWorkspace(String processId, String name, File file) throws IOException, ContentAddressableStorageServerException {
        try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();
             FileInputStream inputStream = new FileInputStream(file);){
            workspaceClient.putAtomicObject(processId, name, (InputStream)inputStream, file.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportPurgeDistinctObjectGroupOfDeletedUnits(String processId, String filename, int tenantId) throws IOException, ContentAddressableStorageServerException, IllegalPathException {
        File tempFile = this.createTemporaryFile(processId, filename);
        try (MongoCursor<String> iterator = this.purgeUnitRepository.distinctObjectGroupOfDeletedUnits(processId, tenantId);){
            this.createFileFromMongoCursorWithString(tempFile, iterator);
            this.storeFileToWorkspace(processId, filename, tempFile);
        }
        finally {
            this.deleteQuietly(tempFile.getParentFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportPurgeAccessionRegister(String processId, String filename, int tenantId) throws IOException, ContentAddressableStorageServerException, InvalidParseOperationException, IllegalPathException {
        File tempFile = this.createTemporaryFile(processId, filename);
        try (MongoCursor<Document> unitCursor = this.purgeUnitRepository.computeOwnAccessionRegisterDetails(processId, tenantId);
             MongoCursor<Document> gotCursor = this.purgeObjectGroupRepository.computeOwnAccessionRegisterDetails(processId, tenantId);){
            this.createFileFromTwoMongoCursorWithDocument(tempFile, unitCursor, gotCursor);
            this.storeFileToWorkspace(processId, filename, tempFile);
        }
        finally {
            this.deleteQuietly(tempFile.getParentFile());
        }
    }

    public void deleteEliminationUnitByProcessId(String processId, int tenantId) {
        this.eliminationActionUnitRepository.deleteReportByIdAndTenant(processId, tenantId);
    }

    public void deletePurgeUnitByProcessId(String processId, int tenantId) {
        this.purgeUnitRepository.deleteReportByIdAndTenant(processId, tenantId);
    }

    public void deletePurgeObjectGroupByIdAndTenant(String processId, int tenantId) {
        this.purgeObjectGroupRepository.deleteReportByIdAndTenant(processId, tenantId);
    }

    public void deleteTransferReplyUnitByProcessId(String processId, int tenantId) {
        this.transferReplyUnitRepository.deleteReportByIdAndTenant(processId, tenantId);
    }

    public void deletePreservationByIdAndTenant(String processId, int tenantId) {
        this.preservationReportRepository.deleteReportByIdAndTenant(processId, tenantId);
    }

    public void deleteAuditByIdAndTenant(String processId, int tenantId) {
        this.auditReportRepository.deleteReportByIdAndTenant(processId, tenantId);
    }

    public void deleteUpdateUnitByIdAndTenant(String processId, int tenantId) {
        this.updateUnitReportRepository.deleteReportByIdAndTenant(processId, tenantId);
    }

    public void deleteBulkUpdateUnitMetadataByIdAndTenant(String processId, int tenantId) {
        this.bulkUpdateUnitMetadataReportRepository.deleteReportByIdAndTenant(processId, tenantId);
    }

    public void deleteEvidenceAuditByIdAndTenant(String processId, int tenantId) {
        this.evidenceAuditReportRepository.deleteReportByIdAndTenant(processId, tenantId);
    }

    public void deleteGotVersionsByIdAndTenant(String processId, int tenantId) {
        this.deleteGotVersionsReportRepository.deleteReportByIdAndTenant(processId, tenantId);
    }

    private void deleteQuietly(File directory) {
        try {
            FileUtils.deleteDirectory((File)directory);
        }
        catch (IOException e) {
            LOGGER.warn("Could not delete directory " + directory.getAbsolutePath());
            throw new VitamRuntimeException((Throwable)e);
        }
    }

    public void storeExtractedMetadataForAu(List<ExtractedMetadata> extractedMetadatas) {
        this.extractedMetadataRepository.addExtractedMetadataForAu(extractedMetadatas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createExtractedMetadataDistributionFileForAu(String processId, int tenant, WorkFlowExecutionContext executionContext) throws IOException, ContentAddressableStorageServerException, IllegalPathException {
        File tempFile = this.createTemporaryFile(processId, processId);
        try (MongoCursor<ExtractedMetadata> extractedMetadatas = this.extractedMetadataRepository.getExtractedMetadataByProcessId(processId, tenant);){
            try (JsonLineWriter jsonLineWriter = new JsonLineWriter((OutputStream)new FileOutputStream(tempFile));){
                while (extractedMetadatas.hasNext()) {
                    ExtractedMetadata metadata = (ExtractedMetadata)extractedMetadatas.next();
                    for (String unitId : metadata.getUnitIds()) {
                        this.writeToJsonLine(jsonLineWriter, unitId, metadata.getMetadata());
                    }
                }
            }
            this.storeFileToWorkspace(processId, "distributionFileAU.jsonl", tempFile);
            this.extractedMetadataRepository.deleteExtractedMetadataByProcessId(processId, tenant);
        }
        finally {
            this.deleteQuietly(tempFile.getParentFile());
        }
    }

    private void writeToJsonLine(JsonLineWriter jsonLineWriter, String unitId, Map<String, Object> metadata) {
        try {
            JsonLineModel line = new JsonLineModel(unitId, null, JsonHandler.toJsonNode(metadata));
            jsonLineWriter.addEntry(line);
        }
        catch (InvalidParseOperationException | IOException e) {
            throw new VitamRuntimeException(e);
        }
    }

    public void deleteTraceabilityByIdAndTenant(String processId, int tenantId) {
        this.traceabilityReportRepository.deleteReportByIdAndTenant(processId, tenantId);
    }

    @NotNull
    private File createTemporaryFile(@NotNull String processId, @NotNull String filename) throws IOException, IllegalPathException {
        File file = SafeFileChecker.checkSafeFilePath((String)VitamConfiguration.getVitamTmpFolder(), (String[])new String[]{processId, filename});
        FileUtils.forceMkdirParent((File)file);
        return file;
    }
}

