/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.batch.report.rest.server;

import com.fasterxml.jackson.jaxrs.base.JsonParseExceptionMapper;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import fr.gouv.vitam.batch.report.rest.repository.AuditReportRepository;
import fr.gouv.vitam.batch.report.rest.repository.BulkUpdateUnitMetadataReportRepository;
import fr.gouv.vitam.batch.report.rest.repository.DeleteGotVersionsReportRepository;
import fr.gouv.vitam.batch.report.rest.repository.EliminationActionUnitRepository;
import fr.gouv.vitam.batch.report.rest.repository.EvidenceAuditReportRepository;
import fr.gouv.vitam.batch.report.rest.repository.ExtractedMetadataRepository;
import fr.gouv.vitam.batch.report.rest.repository.PreservationReportRepository;
import fr.gouv.vitam.batch.report.rest.repository.PurgeObjectGroupRepository;
import fr.gouv.vitam.batch.report.rest.repository.PurgeUnitRepository;
import fr.gouv.vitam.batch.report.rest.repository.TraceabilityReportRepository;
import fr.gouv.vitam.batch.report.rest.repository.TransferReplyUnitRepository;
import fr.gouv.vitam.batch.report.rest.repository.UnitComputedInheritedRulesInvalidationRepository;
import fr.gouv.vitam.batch.report.rest.repository.UpdateUnitReportRepository;
import fr.gouv.vitam.batch.report.rest.resource.BatchReportResource;
import fr.gouv.vitam.batch.report.rest.server.BatchReportConfiguration;
import fr.gouv.vitam.batch.report.rest.service.BatchReportServiceImpl;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import fr.gouv.vitam.common.database.server.mongodb.SimpleMongoDBAccess;
import fr.gouv.vitam.common.model.processing.WorkFlowExecutionContext;
import fr.gouv.vitam.common.server.HeaderIdContainerFilter;
import fr.gouv.vitam.common.server.application.configuration.DbConfiguration;
import fr.gouv.vitam.common.serverv2.ConfigurationApplication;
import fr.gouv.vitam.common.serverv2.application.CommonBusinessApplication;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.ws.rs.core.Context;
import org.bson.Document;

public class BusinessApplication
extends ConfigurationApplication {
    private final CommonBusinessApplication commonBusinessApplication;
    private Set<Object> singletons;

    public BusinessApplication(@Context ServletConfig servletConfig) {
        String configurationFile = servletConfig.getInitParameter("vitam.configurationFile");
        this.singletons = new HashSet<Object>();
        try (InputStream yamlIS = PropertiesUtils.getConfigAsStream((String)configurationFile);){
            BatchReportConfiguration configuration = (BatchReportConfiguration)((Object)PropertiesUtils.readYaml((InputStream)yamlIS, BatchReportConfiguration.class));
            MongoClient mongoClient = MongoDbAccess.createMongoClient((DbConfiguration)configuration);
            SimpleMongoDBAccess mongoDbAccess = new SimpleMongoDBAccess(mongoClient, configuration.getDbName());
            EliminationActionUnitRepository eliminationActionUnitRepository = new EliminationActionUnitRepository((MongoDbAccess)mongoDbAccess);
            PurgeUnitRepository purgeUnitRepository = new PurgeUnitRepository((MongoDbAccess)mongoDbAccess);
            PurgeObjectGroupRepository purgeObjectGroupRepository = new PurgeObjectGroupRepository((MongoDbAccess)mongoDbAccess);
            TransferReplyUnitRepository transferReplyUnitRepository = new TransferReplyUnitRepository((MongoDbAccess)mongoDbAccess);
            PreservationReportRepository preservationReportRepository = new PreservationReportRepository((MongoDbAccess)mongoDbAccess);
            AuditReportRepository auditReportRepository = new AuditReportRepository((MongoDbAccess)mongoDbAccess);
            UnitComputedInheritedRulesInvalidationRepository unitComputedInheritedRulesInvalidationRepository = new UnitComputedInheritedRulesInvalidationRepository(mongoDbAccess);
            WorkspaceClientFactory.changeMode((String)configuration.getWorkspaceUrl(), (WorkFlowExecutionContext)WorkFlowExecutionContext.VITAM);
            WorkspaceClientFactory workspaceClientFactory = WorkspaceClientFactory.getInstance((WorkFlowExecutionContext)WorkFlowExecutionContext.VITAM);
            UpdateUnitReportRepository updateUnitReportRepository = new UpdateUnitReportRepository((MongoDbAccess)mongoDbAccess);
            BulkUpdateUnitMetadataReportRepository bulkUpdateUnitMetadataReportRepository = new BulkUpdateUnitMetadataReportRepository((MongoDbAccess)mongoDbAccess);
            EvidenceAuditReportRepository evidenceAuditReportRepository = new EvidenceAuditReportRepository((MongoDbAccess)mongoDbAccess);
            TraceabilityReportRepository traceabilityReportRepository = new TraceabilityReportRepository((MongoDbAccess)mongoDbAccess);
            ExtractedMetadataRepository extractedMetadataRepository = new ExtractedMetadataRepository((MongoCollection<Document>)mongoDbAccess.getMongoDatabase().getCollection("ExtractedMetadata"));
            DeleteGotVersionsReportRepository deleteGotVersionsReportRepository = new DeleteGotVersionsReportRepository((MongoDbAccess)mongoDbAccess);
            BatchReportServiceImpl batchReportServiceImpl = new BatchReportServiceImpl(workspaceClientFactory, eliminationActionUnitRepository, purgeUnitRepository, purgeObjectGroupRepository, transferReplyUnitRepository, updateUnitReportRepository, bulkUpdateUnitMetadataReportRepository, preservationReportRepository, auditReportRepository, unitComputedInheritedRulesInvalidationRepository, evidenceAuditReportRepository, traceabilityReportRepository, extractedMetadataRepository, deleteGotVersionsReportRepository);
            this.commonBusinessApplication = new CommonBusinessApplication();
            this.singletons.addAll(this.commonBusinessApplication.getResources());
            this.singletons.add((Object)new BatchReportResource(batchReportServiceImpl));
            this.singletons.add(new HeaderIdContainerFilter());
            this.singletons.add(new JsonParseExceptionMapper());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

