/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.batch.report.rest.resource;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.batch.report.exception.BatchReportException;
import fr.gouv.vitam.batch.report.model.Report;
import fr.gouv.vitam.batch.report.model.ReportBody;
import fr.gouv.vitam.batch.report.model.ReportExportRequest;
import fr.gouv.vitam.batch.report.model.ReportRequestWrapper;
import fr.gouv.vitam.batch.report.model.ReportType;
import fr.gouv.vitam.batch.report.model.entry.AuditObjectGroupReportEntry;
import fr.gouv.vitam.batch.report.model.entry.BulkUpdateUnitMetadataReportEntry;
import fr.gouv.vitam.batch.report.model.entry.DeleteGotVersionsComputedDetails;
import fr.gouv.vitam.batch.report.model.entry.DeleteGotVersionsReportEntry;
import fr.gouv.vitam.batch.report.model.entry.EliminationActionUnitReportEntry;
import fr.gouv.vitam.batch.report.model.entry.EvidenceAuditReportEntry;
import fr.gouv.vitam.batch.report.model.entry.PreservationReportEntry;
import fr.gouv.vitam.batch.report.model.entry.PurgeObjectGroupReportEntry;
import fr.gouv.vitam.batch.report.model.entry.PurgeUnitReportEntry;
import fr.gouv.vitam.batch.report.model.entry.TraceabilityReportEntry;
import fr.gouv.vitam.batch.report.model.entry.TransferReplyUnitReportEntry;
import fr.gouv.vitam.batch.report.model.entry.UnitComputedInheritedRulesInvalidationReportEntry;
import fr.gouv.vitam.batch.report.model.entry.UpdateUnitMetadataReportEntry;
import fr.gouv.vitam.batch.report.rest.service.BatchReportServiceImpl;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ExtractedMetadata;
import fr.gouv.vitam.common.model.processing.WorkFlowExecutionContext;
import fr.gouv.vitam.common.security.IllegalPathException;
import fr.gouv.vitam.common.server.application.resources.ApplicationStatusResource;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/batchreport/v1")
@Tag(name="Batch-Report")
public class BatchReportResource
extends ApplicationStatusResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(BatchReportResource.class);
    private static final String EMPTY_PROCESSID_ERROR_MESSAGE = "processId should be filed";
    private static final TypeReference<ReportBody<AuditObjectGroupReportEntry>> reportAuditType = new TypeReference<ReportBody<AuditObjectGroupReportEntry>>(){};
    private static final TypeReference<ReportBody<EliminationActionUnitReportEntry>> reportEliminationActionUnitType = new TypeReference<ReportBody<EliminationActionUnitReportEntry>>(){};
    private static final TypeReference<ReportBody<PurgeUnitReportEntry>> reportPurgeUnitType = new TypeReference<ReportBody<PurgeUnitReportEntry>>(){};
    private static final TypeReference<ReportBody<PurgeObjectGroupReportEntry>> reportPurgeObjectGroupType = new TypeReference<ReportBody<PurgeObjectGroupReportEntry>>(){};
    private static final TypeReference<ReportBody<TransferReplyUnitReportEntry>> reportTransferReplyUnitType = new TypeReference<ReportBody<TransferReplyUnitReportEntry>>(){};
    private static final TypeReference<ReportBody<PreservationReportEntry>> reportPreservationType = new TypeReference<ReportBody<PreservationReportEntry>>(){};
    private static final TypeReference<ReportBody<UpdateUnitMetadataReportEntry>> reportMassUpdateType = new TypeReference<ReportBody<UpdateUnitMetadataReportEntry>>(){};
    private static final TypeReference<ReportBody<BulkUpdateUnitMetadataReportEntry>> reportBulkUpdateMetadataType = new TypeReference<ReportBody<BulkUpdateUnitMetadataReportEntry>>(){};
    private static final TypeReference<ReportBody<EvidenceAuditReportEntry>> reportEvidenceAuditType = new TypeReference<ReportBody<EvidenceAuditReportEntry>>(){};
    private static final TypeReference<ReportBody<UnitComputedInheritedRulesInvalidationReportEntry>> unitComputedInheritedRuleInvalidationType = new TypeReference<ReportBody<UnitComputedInheritedRulesInvalidationReportEntry>>(){};
    private static final TypeReference<ReportBody<DeleteGotVersionsReportEntry>> reportDeleteGotVersionsType = new TypeReference<ReportBody<DeleteGotVersionsReportEntry>>(){};
    private final BatchReportServiceImpl batchReportServiceImpl;

    public BatchReportResource(BatchReportServiceImpl batchReportServiceImpl) {
        this.batchReportServiceImpl = batchReportServiceImpl;
    }

    @Path(value="/append")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response appendReport(JsonNode body, @HeaderParam(value="X-Tenant-Id") int tenantId) {
        try {
            String type = body.get("reportType").asText();
            ReportType reportType = ReportType.valueOf((String)type);
            switch (reportType) {
                case ELIMINATION_ACTION_UNIT: {
                    ReportBody eliminationUnitReportBody = (ReportBody)JsonHandler.getFromJsonNode((JsonNode)body, reportEliminationActionUnitType);
                    this.batchReportServiceImpl.appendEliminationActionUnitReport(eliminationUnitReportBody.getProcessId(), eliminationUnitReportBody.getEntries(), tenantId);
                    break;
                }
                case PURGE_UNIT: {
                    ReportBody purgeUnitReportBody = (ReportBody)JsonHandler.getFromJsonNode((JsonNode)body, reportPurgeUnitType);
                    this.batchReportServiceImpl.appendPurgeUnitReport(purgeUnitReportBody.getProcessId(), purgeUnitReportBody.getEntries(), tenantId);
                    break;
                }
                case PURGE_OBJECTGROUP: {
                    ReportBody purgeObjectGroupReportBody = (ReportBody)JsonHandler.getFromJsonNode((JsonNode)body, reportPurgeObjectGroupType);
                    this.batchReportServiceImpl.appendPurgeObjectGroupReport(purgeObjectGroupReportBody.getProcessId(), purgeObjectGroupReportBody.getEntries(), tenantId);
                    break;
                }
                case TRANSFER_REPLY_UNIT: {
                    ReportBody transferReplyUnitReportBody = (ReportBody)JsonHandler.getFromJsonNode((JsonNode)body, reportTransferReplyUnitType);
                    this.batchReportServiceImpl.appendTransferReplyUnitReport(transferReplyUnitReportBody.getProcessId(), transferReplyUnitReportBody.getEntries(), tenantId);
                    break;
                }
                case PRESERVATION: {
                    ReportBody preservationReportBody = (ReportBody)JsonHandler.getFromJsonNode((JsonNode)body, reportPreservationType);
                    this.batchReportServiceImpl.appendPreservationReport(preservationReportBody.getProcessId(), preservationReportBody.getEntries(), tenantId);
                    break;
                }
                case AUDIT: {
                    ReportBody auditReportBody = (ReportBody)JsonHandler.getFromJsonNode((JsonNode)body, reportAuditType);
                    this.batchReportServiceImpl.appendAuditReport(auditReportBody.getProcessId(), auditReportBody.getEntries(), tenantId);
                    break;
                }
                case UPDATE_UNIT: {
                    ReportBody unitReportBody = (ReportBody)JsonHandler.getFromJsonNode((JsonNode)body, reportMassUpdateType);
                    this.batchReportServiceImpl.appendUnitReport(unitReportBody.getEntries());
                    break;
                }
                case BULK_UPDATE_UNIT: {
                    ReportBody bulkUnitMetadataReportBody = (ReportBody)JsonHandler.getFromJsonNode((JsonNode)body, reportBulkUpdateMetadataType);
                    this.batchReportServiceImpl.appendBulkUpdateUnitMetadataReport(bulkUnitMetadataReportBody.getEntries());
                    break;
                }
                case EVIDENCE_AUDIT: {
                    ReportBody evidenceAuditReportBody = (ReportBody)JsonHandler.getFromJsonNode((JsonNode)body, reportEvidenceAuditType);
                    this.batchReportServiceImpl.appendEvidenceAuditReport(evidenceAuditReportBody.getProcessId(), evidenceAuditReportBody.getEntries(), tenantId);
                    break;
                }
                case TRACEABILITY: {
                    ReportBody traceabilityReportEntry = (ReportBody)JsonHandler.getFromJsonNode((JsonNode)body, ReportBody.class, TraceabilityReportEntry.class);
                    this.batchReportServiceImpl.appendTraceabilityReport(traceabilityReportEntry.getProcessId(), traceabilityReportEntry.getEntries(), tenantId);
                    break;
                }
                case UNIT_COMPUTED_INHERITED_RULES_INVALIDATION: {
                    ReportBody unitInvalidationReportEntry = (ReportBody)JsonHandler.getFromJsonNode((JsonNode)body, unitComputedInheritedRuleInvalidationType);
                    this.batchReportServiceImpl.appendUnitComputedInheritedRulesInvalidationReport(unitInvalidationReportEntry.getProcessId(), unitInvalidationReportEntry.getEntries(), tenantId);
                    break;
                }
                case DELETE_GOT_VERSIONS: {
                    ReportBody deleteGotVersionsReportEntryReportBody = (ReportBody)JsonHandler.getFromJsonNode((JsonNode)body, reportDeleteGotVersionsType);
                    this.batchReportServiceImpl.appendDeleteGotVersionsReport(deleteGotVersionsReportEntryReportBody.getEntries());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported report type " + String.valueOf(reportType));
                }
            }
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (BatchReportException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/storeToWorkspace")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response storeReportToWorkspace(ReportRequestWrapper<Report> reportRequestWrapper) {
        int tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        Report reportInfo = (Report)reportRequestWrapper.getRequest();
        ParametersChecker.checkParameter((String)EMPTY_PROCESSID_ERROR_MESSAGE, (String[])new String[]{reportInfo.getOperationSummary().getEvId()});
        ParametersChecker.checkParameter((String)"tenantId should be filed", (Object[])new Object[]{reportInfo.getOperationSummary().getTenant()});
        if (tenantId != reportInfo.getOperationSummary().getTenant()) {
            throw new IllegalArgumentException("Tenant id in request should match header. Header: " + tenantId + ", request: " + reportInfo.getOperationSummary().getTenant() + ".");
        }
        try {
            this.batchReportServiceImpl.storeFileToWorkspace(reportInfo);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (InvalidParseOperationException | IllegalPathException | IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (ContentAddressableStorageServerException | IOException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/purge_unit/objectgroup_export/{processId}")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response exportDistinctObjectGroup(@PathParam(value="processId") String processId, ReportRequestWrapper<ReportExportRequest> reportRequestWrapper) throws ContentAddressableStorageServerException, IOException {
        try {
            ParametersChecker.checkParameter((String)EMPTY_PROCESSID_ERROR_MESSAGE, (String[])new String[]{processId});
            int tenantId = VitamThreadUtils.getVitamSession().getTenantId();
            ReportExportRequest reportExportRequest = (ReportExportRequest)reportRequestWrapper.getRequest();
            this.batchReportServiceImpl.exportPurgeDistinctObjectGroupOfDeletedUnits(processId, reportExportRequest.getFilename(), tenantId);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (IllegalPathException | IllegalArgumentException e) {
            throw new BadRequestException(e);
        }
    }

    @Path(value="computedInheritedRulesInvalidation/{processId}")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response exportUnitsToInvalidate(@PathParam(value="processId") String processId, ReportRequestWrapper<ReportExportRequest> reportRequestWrapper) throws Exception {
        int tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        this.batchReportServiceImpl.exportUnitsToInvalidate(processId, tenantId, (ReportExportRequest)reportRequestWrapper.getRequest(), reportRequestWrapper.getExecutionContext());
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @Path(value="/purge/accession_register_export/{processId}")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response exportPurgeAccessionRegister(@PathParam(value="processId") String processId, ReportRequestWrapper<ReportExportRequest> reportRequestWrapper) throws ContentAddressableStorageServerException, IOException {
        try {
            ParametersChecker.checkParameter((String)EMPTY_PROCESSID_ERROR_MESSAGE, (String[])new String[]{processId});
            int tenantId = VitamThreadUtils.getVitamSession().getTenantId();
            this.batchReportServiceImpl.exportPurgeAccessionRegister(processId, ((ReportExportRequest)reportRequestWrapper.getRequest()).getFilename(), tenantId);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (InvalidParseOperationException | IllegalPathException | IllegalArgumentException e) {
            throw new BadRequestException(e);
        }
    }

    @Path(value="/cleanup/{reportType}/{processId}")
    @DELETE
    @Produces(value={"application/json"})
    public Response deleteReport(@PathParam(value="processId") String processId, @PathParam(value="reportType") ReportType reportType) {
        try {
            ParametersChecker.checkParameter((String)"ProcessId, reportType should be filed", (Object[])new Object[]{processId, reportType});
            int tenantId = VitamThreadUtils.getVitamSession().getTenantId();
            switch (reportType) {
                case ELIMINATION_ACTION_UNIT: {
                    this.batchReportServiceImpl.deleteEliminationUnitByProcessId(processId, tenantId);
                    break;
                }
                case PURGE_UNIT: {
                    this.batchReportServiceImpl.deletePurgeUnitByProcessId(processId, tenantId);
                    break;
                }
                case PURGE_OBJECTGROUP: {
                    this.batchReportServiceImpl.deletePurgeObjectGroupByIdAndTenant(processId, tenantId);
                    break;
                }
                case TRANSFER_REPLY_UNIT: {
                    this.batchReportServiceImpl.deleteTransferReplyUnitByProcessId(processId, tenantId);
                    break;
                }
                case PRESERVATION: {
                    this.batchReportServiceImpl.deletePreservationByIdAndTenant(processId, tenantId);
                    break;
                }
                case AUDIT: {
                    this.batchReportServiceImpl.deleteAuditByIdAndTenant(processId, tenantId);
                    break;
                }
                case UPDATE_UNIT: {
                    this.batchReportServiceImpl.deleteUpdateUnitByIdAndTenant(processId, tenantId);
                    break;
                }
                case BULK_UPDATE_UNIT: {
                    this.batchReportServiceImpl.deleteBulkUpdateUnitMetadataByIdAndTenant(processId, tenantId);
                    break;
                }
                case EVIDENCE_AUDIT: {
                    this.batchReportServiceImpl.deleteEvidenceAuditByIdAndTenant(processId, tenantId);
                    break;
                }
                case TRACEABILITY: {
                    this.batchReportServiceImpl.deleteTraceabilityByIdAndTenant(processId, tenantId);
                    break;
                }
                case UNIT_COMPUTED_INHERITED_RULES_INVALIDATION: {
                    this.batchReportServiceImpl.deleteUnitComputedInheritedRulesInvalidationReport(processId, tenantId);
                    break;
                }
                case DELETE_GOT_VERSIONS: {
                    this.batchReportServiceImpl.deleteGotVersionsByIdAndTenant(processId, tenantId);
                    break;
                }
                default: {
                    Response.Status status = Response.Status.BAD_REQUEST;
                    VitamError vitamError = new VitamError(status.name()).setHttpCode(status.getStatusCode()).setMessage("Report type not found").setDescription("Report type not found");
                    return Response.status((Response.Status)status).entity((Object)vitamError).build();
                }
            }
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException((Throwable)e);
        }
    }

    @Path(value="/storeExtractedMetadataForAu")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response storeExtractedMetadataForAu(List<ExtractedMetadata> extractedMetadatas) {
        this.batchReportServiceImpl.storeExtractedMetadataForAu(extractedMetadatas);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Path(value="/createExtractedMetadataDistributionFileForAu/{processId}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response createExtractedMetadataDistributionFileForAu(@PathParam(value="processId") String processId, @QueryParam(value="executionContext") WorkFlowExecutionContext executionContext) {
        try {
            this.batchReportServiceImpl.createExtractedMetadataDistributionFileForAu(processId, VitamThreadUtils.getVitamSession().getTenantId(), executionContext);
            return Response.ok().build();
        }
        catch (IllegalPathException | ContentAddressableStorageServerException | IOException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Path(value="/readComputedDetailsFromReport")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response readComputedDetailsFromReport(JsonNode body) {
        try {
            ReportBody reportBody = (ReportBody)JsonHandler.getFromJsonNode((JsonNode)body, ReportBody.class);
            if (reportBody == null) {
                throw new IllegalStateException("Incorrect body report!");
            }
            switch (reportBody.getReportType()) {
                case DELETE_GOT_VERSIONS: {
                    List<DeleteGotVersionsComputedDetails> results = this.batchReportServiceImpl.readDeletedGotVersionsComputedDetailsFromReport(reportBody.getProcessId(), VitamThreadUtils.getVitamSession().getTenantId());
                    return Response.ok().entity(results).build();
                }
            }
            throw new IllegalStateException("Unsupported report type " + String.valueOf(reportBody.getReportType()));
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

