/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.batch.report.rest.repository;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.DeleteResult;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;

public abstract class ReportCommonRepository {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ReportCommonRepository.class);

    protected void bulkAppendReport(List<Document> reports, MongoCollection<Document> collection) {
        if (reports.isEmpty()) {
            return;
        }
        ArrayList<UpdateOneModel> updates = new ArrayList<UpdateOneModel>();
        for (Document document : reports) {
            Document metadata = (Document)document.get((Object)"_metadata");
            updates.add(new UpdateOneModel(Filters.and((Bson[])new Bson[]{Filters.eq((String)"_metadata.id", (Object)metadata.get((Object)"id")), Filters.eq((String)"processId", (Object)document.get((Object)"processId")), Filters.eq((String)"_tenant", (Object)document.get((Object)"_tenant"))}), (Bson)new Document("$set", (Object)document).append("$setOnInsert", (Object)new Document("_id", (Object)GUIDFactory.newGUID().toString())), new UpdateOptions().upsert(true)));
        }
        collection.bulkWrite(updates);
    }

    protected void deleteReportByIdAndTenant(String processId, int tenantId, MongoCollection<Document> collection) {
        DeleteResult deleteResult = collection.deleteMany(Filters.and((Bson[])new Bson[]{Filters.eq((String)"processId", (Object)processId), Filters.eq((String)"_tenant", (Object)tenantId)}));
        LOGGER.info("Deleted document count: " + deleteResult.getDeletedCount() + " for process " + processId);
    }

    static Document pojoToDocument(Object object) {
        try {
            String json = JsonHandler.writeAsString((Object)object);
            return Document.parse((String)json);
        }
        catch (InvalidParseOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

