/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.batch.report.rest.repository;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import fr.gouv.vitam.batch.report.model.PurgeObjectGroupModel;
import fr.gouv.vitam.batch.report.rest.repository.ReportCommonRepository;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;

public class PurgeObjectGroupRepository
extends ReportCommonRepository {
    public static final String PURGE_OBJECT_GROUP = "PurgeObjectGroup";
    public static final String OPI_GOT = "opi_got";
    private final MongoCollection<Document> objectGroupReportCollection;

    @VisibleForTesting
    public PurgeObjectGroupRepository(MongoDbAccess mongoDbAccess, String collectionName) {
        this.objectGroupReportCollection = mongoDbAccess.getMongoDatabase().getCollection(collectionName);
    }

    public PurgeObjectGroupRepository(MongoDbAccess mongoDbAccess) {
        this(mongoDbAccess, PURGE_OBJECT_GROUP);
    }

    public void bulkAppendReport(List<PurgeObjectGroupModel> reports) {
        HashSet<PurgeObjectGroupModel> reportsWithoutDuplicate = new HashSet<PurgeObjectGroupModel>(reports);
        List<Document> purgeObjectGroupDocument = reportsWithoutDuplicate.stream().map(ReportCommonRepository::pojoToDocument).collect(Collectors.toList());
        super.bulkAppendReport(purgeObjectGroupDocument, this.objectGroupReportCollection);
    }

    public MongoCursor<Document> findCollectionByProcessIdTenant(String processId, int tenantId) {
        return this.objectGroupReportCollection.aggregate(Arrays.asList(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{Filters.eq((String)"processId", (Object)processId), Filters.eq((String)"_tenant", (Object)tenantId)})), Aggregates.project((Bson)Projections.fields((Bson[])new Bson[]{new Document("_id", (Object)0), new Document("id", (Object)"$_metadata.id"), new Document("distribGroup", null), new Document("params.id", (Object)"$_metadata.id"), new Document("params.type", (Object)new Document("$literal", (Object)"ObjectGroup")), new Document("params.status", (Object)"$_metadata.status"), new Document("params.opi", (Object)"$_metadata.opi"), new Document("params.originatingAgency", (Object)"$_metadata.originatingAgency"), new Document("params.deletedParentUnitIds", (Object)"$_metadata.deletedParentUnitIds"), new Document("params.archivalAgencyIdentifier", (Object)"$_metadata.archivalAgencyIdentifier"), new Document("params.objectVersions", (Object)"$_metadata.objectVersions"), new Document("params.objectIds", (Object)"$_metadata.objectIds")})))).allowDiskUse(Boolean.valueOf(true)).iterator();
    }

    public void deleteReportByIdAndTenant(String processId, int tenantId) {
        super.deleteReportByIdAndTenant(processId, tenantId, this.objectGroupReportCollection);
    }

    public MongoCursor<Document> computeOwnAccessionRegisterDetails(String processId, int tenantId) {
        return this.objectGroupReportCollection.aggregate(Arrays.asList(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{Filters.eq((String)"processId", (Object)processId), Filters.eq((String)"_tenant", (Object)tenantId), Filters.eq((String)"_metadata.status", (Object)"DELETED")})), Aggregates.project((Bson)Projections.fields((Bson[])new Bson[]{new Document("_id", (Object)0), new Document("id", (Object)"$_metadata.id"), new Document("opi", (Object)"$_metadata.opi"), new Document("originatingAgency", (Object)"$_metadata.originatingAgency"), new Document("objectVersions", (Object)"$_metadata.objectVersions")})), Aggregates.unwind((String)"$objectVersions"), Aggregates.group((Object)new Document("opi", (Object)"$objectVersions.opi").append(OPI_GOT, (Object)"$opi"), (BsonField[])new BsonField[]{Accumulators.first((String)"originatingAgency", (Object)"$originatingAgency"), Accumulators.sum((String)"totalSize", (Object)"$objectVersions.size"), Accumulators.sum((String)"totalObjects", (Object)1), Accumulators.addToSet((String)"listGOT", (Object)"$id")}), Aggregates.project((Bson)Projections.fields((Bson[])new Bson[]{new Document("_id", (Object)0), new Document("opi", (Object)"$_id.opi"), new Document(OPI_GOT, (Object)"$_id.opi_got"), new Document("originatingAgency", (Object)1), new Document("totalSize", (Object)1), new Document("totalObjects", (Object)1), new Document("totalObjectGroups", (Object)new Document("$cond", (Object)Lists.newArrayList((Object[])new Serializable[]{new Document("$eq", (Object)Lists.newArrayList((Object[])new String[]{"$_id.opi", "$_id.opi_got"})), new Document("$size", (Object)"$listGOT"), Integer.valueOf(0)})))})), Aggregates.group((Object)"$opi", (BsonField[])new BsonField[]{Accumulators.first((String)"originatingAgency", (Object)"$originatingAgency"), Accumulators.sum((String)"totalSize", (Object)"$totalSize"), Accumulators.sum((String)"totalObjects", (Object)"$totalObjects"), Accumulators.sum((String)"totalObjectGroups", (Object)"$totalObjectGroups")}), Aggregates.project((Bson)Projections.fields((Bson[])new Bson[]{new Document("_id", (Object)0), new Document("opi", (Object)"$_id"), new Document("originatingAgency", (Object)1), new Document("totalSize", (Object)1), new Document("totalObjects", (Object)1), new Document("totalObjectGroups", (Object)1)})), Aggregates.sort((Bson)Sorts.descending((String[])new String[]{"opi"})))).allowDiskUse(Boolean.valueOf(true)).iterator();
    }
}

