/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.batch.report.rest.repository;

import com.google.common.annotations.VisibleForTesting;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import fr.gouv.vitam.batch.report.model.ReportResults;
import fr.gouv.vitam.batch.report.model.entry.DeleteGotVersionsReportEntry;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.StatusCode;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;

public class DeleteGotVersionsReportRepository {
    private final VitamLogger LOGGER = VitamLoggerFactory.getInstance(DeleteGotVersionsReportRepository.class);
    public static final String DELETE_GOT_VERSIONS_REPORT = "DeleteGotVersionsReport";
    public static final String ID = "_id";
    private final MongoCollection<Document> collection;

    @VisibleForTesting
    public DeleteGotVersionsReportRepository(MongoDbAccess mongoDbAccess, String collectionName) {
        this.collection = mongoDbAccess.getMongoDatabase().getCollection(collectionName);
    }

    public DeleteGotVersionsReportRepository(MongoDbAccess mongoDbAccess) {
        this(mongoDbAccess, DELETE_GOT_VERSIONS_REPORT);
    }

    public void bulkAppendReport(List<DeleteGotVersionsReportEntry> reports) {
        List deleteGotVersionsModel = reports.stream().distinct().map(DeleteGotVersionsReportRepository::modelToWriteDocument).collect(Collectors.toList());
        this.collection.bulkWrite(deleteGotVersionsModel);
    }

    private static WriteModel<Document> modelToWriteDocument(DeleteGotVersionsReportEntry model) {
        return new UpdateOneModel(Filters.and((Bson[])new Bson[]{Filters.eq((String)"processId", (Object)model.getProcessId()), Filters.eq((String)"id", (Object)model.getDetailId())}), (Bson)new Document("$set", (Object)Document.parse((String)JsonHandler.unprettyPrint((Object)model))).append("$setOnInsert", (Object)new Document(ID, (Object)GUIDFactory.newGUID().toString())), new UpdateOptions().upsert(true));
    }

    public MongoCursor<Document> findCollectionByProcessIdTenant(String processId, int tenantId) {
        return this.collection.aggregate(Arrays.asList(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{Filters.eq((String)"processId", (Object)processId), Filters.eq((String)"_tenant", (Object)tenantId)})))).allowDiskUse(Boolean.valueOf(true)).iterator();
    }

    public MongoCursor<Document> computeDeleteGotVersionsEntriesByProcessIdTenant(String processId, int tenantId) {
        return this.collection.aggregate(Arrays.asList(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{Filters.eq((String)"processId", (Object)processId), Filters.eq((String)"_tenant", (Object)tenantId)})), Aggregates.project((Bson)Projections.fields((Bson[])new Bson[]{new Document(ID, (Object)0), new Document("objectGroupGlobal", (Object)1)})), Aggregates.unwind((String)"$objectGroupGlobal"), Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{Filters.eq((String)"objectGroupGlobal.status", (Object)StatusCode.OK.name())})), Aggregates.project((Bson)Projections.fields((Bson[])new Bson[]{new Document(ID, (Object)0), new Document("deletedVersions", (Object)"$objectGroupGlobal.deletedVersions")})), Aggregates.unwind((String)"$deletedVersions"), Aggregates.project((Bson)Projections.fields((Bson[])new Bson[]{new Document(ID, (Object)0), new Document("opc", (Object)"$deletedVersions.opc"), new Document("Size", (Object)"$deletedVersions.Size")})), Aggregates.group((Object)"$opc", (BsonField[])new BsonField[]{Accumulators.sum((String)"totalSize", (Object)"$Size"), Accumulators.sum((String)"totalObjects", (Object)1)}))).allowDiskUse(Boolean.valueOf(true)).iterator();
    }

    public void deleteReportByIdAndTenant(String processId, int tenantId) {
        DeleteResult deleteResult = this.collection.deleteMany(Filters.and((Bson[])new Bson[]{Filters.eq((String)"processId", (Object)processId), Filters.eq((String)"_tenant", (Object)tenantId)}));
        this.LOGGER.info("Deleted document count: " + deleteResult.getDeletedCount() + " for process " + processId);
    }

    public ReportResults computeVitamResults(String processId, Integer tenantId) {
        ReportResults reportResult = new ReportResults();
        MongoCursor iterator = this.collection.aggregate(Arrays.asList(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{Filters.eq((String)"processId", (Object)processId), Filters.eq((String)"_tenant", (Object)tenantId)})), Aggregates.project((Bson)Projections.fields((Bson[])new Bson[]{new Document(ID, (Object)0), new Document("objectGroupGlobal", (Object)1)})), Aggregates.unwind((String)"$objectGroupGlobal"), Aggregates.project((Bson)Projections.fields((Bson[])new Bson[]{new Document(ID, (Object)0), new Document("status", (Object)"$objectGroupGlobal.status"), new Document("deletedVersions", (Object)"$objectGroupGlobal.deletedVersions")})))).allowDiskUse(Boolean.valueOf(true)).iterator();
        iterator.forEachRemaining(result -> {
            String status = result.getString((Object)"status");
            if (status.equals(StatusCode.OK.name())) {
                reportResult.incrementStatus(status, Integer.valueOf(((List)result.get((Object)"deletedVersions", List.class)).size()));
            } else {
                reportResult.incrementStatus(status, Integer.valueOf(1));
            }
        });
        return reportResult;
    }
}

