/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.batch.report.rest;

import fr.gouv.vitam.batch.report.rest.server.AdminBatchReportApplication;
import fr.gouv.vitam.batch.report.rest.server.BatchReportConfiguration;
import fr.gouv.vitam.batch.report.rest.server.BusinessApplication;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.ServerIdentity;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.VitamApplicationServerException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.server.application.resources.VitamServiceRegistry;
import fr.gouv.vitam.common.serverv2.VitamStarter;

public class BatchReportMain {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(BatchReportMain.class);
    private static final String CONF_FILE_NAME = "batch-report.conf";
    private static final String MODULE_NAME = ServerIdentity.getInstance().getRole();
    public static final String PARAMETER_JETTY_SERVER_PORT = "jetty.batch-report.port";
    private VitamStarter vitamStarter;

    public BatchReportMain(String configurationFile) {
        ParametersChecker.checkParameter((String)String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME), (String[])new String[]{configurationFile});
        this.vitamStarter = new VitamStarter(BatchReportConfiguration.class, configurationFile, BusinessApplication.class, AdminBatchReportApplication.class);
    }

    public static void main(String[] args) {
        try {
            if (args == null || args.length == 0) {
                LOGGER.error(String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME));
                throw new IllegalArgumentException(String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME));
            }
            BatchReportMain storageMain = new BatchReportMain(args[0]);
            VitamServiceRegistry serviceRegistry = new VitamServiceRegistry();
            serviceRegistry.checkDependencies(VitamConfiguration.getRetryNumber().intValue(), (long)VitamConfiguration.getRetryDelay().intValue());
            storageMain.startAndJoin();
        }
        catch (Exception e) {
            LOGGER.error(String.format("%s application server can not start. ", MODULE_NAME) + e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    public void start() throws VitamApplicationServerException {
        this.vitamStarter.start();
    }

    public void startAndJoin() throws VitamApplicationServerException {
        this.vitamStarter.run();
    }

    public void stop() throws VitamApplicationServerException {
        this.vitamStarter.stop();
    }
}

