/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.client;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.collect.common.dto.BulkAtomicUpdateResult;
import fr.gouv.vitam.collect.common.dto.CriteriaProjectDto;
import fr.gouv.vitam.collect.common.dto.ProjectDto;
import fr.gouv.vitam.collect.common.dto.TransactionDto;
import fr.gouv.vitam.collect.common.enums.TransactionStatus;
import fr.gouv.vitam.collect.internal.client.CollectInternalClient;
import fr.gouv.vitam.collect.internal.client.exceptions.CollectInternalClientInvalidRequestException;
import fr.gouv.vitam.collect.internal.client.exceptions.CollectInternalClientNotFoundException;
import fr.gouv.vitam.common.CommonMediaType;
import fr.gouv.vitam.common.client.DefaultClient;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.VitamRequestBuilder;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.elimination.DeletionRequestBody;
import fr.gouv.vitam.common.model.elimination.EliminationRequestBody;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

public class CollectInternalClientRest
extends DefaultClient
implements CollectInternalClient {
    private static final String TRANSACTION_PATH = "/transactions";
    private static final String PROJECT_PATH = "/projects";
    private static final String UNITS_PATH = "/units";
    private static final String UNITS_METADATA_CSV_PATH = "/units/metadata/csv";
    private static final String UNITS_METADATA_JSONL_PATH = "/units/metadata/jsonl";
    private static final String OBJECTS_PATH = "/objects";
    private static final String BINARY_PATH = "/binary";
    private static final String UNITS_WITH_INHERITED_RULES = "/unitsWithInheritedRules";
    private static final String RECLASSIFICATION = "/reclassification";
    private static final String ELIMINATION_ACTION = "/elimination/action";
    private static final String DELETION_ACTION = "/deletion/action";
    private static final String BLANK_DSL = "select DSL is blank";
    public static final String UNITS_BULK = "/units/bulk";

    public CollectInternalClientRest(VitamClientFactoryInterface<?> factory) {
        super(factory);
    }

    @Override
    public RequestResponse<JsonNode> initProject(ProjectDto projectDto) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath(PROJECT_PATH).withHeader("Expect", (Object)"100-continue").withBody((Object)projectDto).withJsonContentType().withJsonAccept();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> updateProject(ProjectDto projectDto) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.put().withPath(PROJECT_PATH).withBody((Object)projectDto).withJsonContentType().withJsonAccept();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> getProjectById(String projectId) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/projects/" + projectId).withJsonAccept();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> getTransactionById(String transactionId) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/transactions/" + transactionId).withJsonAccept();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> getTransactionByProjectId(String projectId) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/projects/" + projectId + TRANSACTION_PATH).withJsonAccept();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> deleteProjectById(String projectId) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.delete().withPath("/projects/" + projectId).withJsonAccept();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> deleteTransactionById(String transactionId) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.delete().withPath("/transactions/" + transactionId).withJsonAccept();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> getProjects() throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath(PROJECT_PATH).withJsonAccept();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponseOK<JsonNode> getUnitById(String unitId) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/units/" + unitId).withJsonAccept();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse result = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            RequestResponseOK requestResponseOK = (RequestResponseOK)result;
            return requestResponseOK;
        }
    }

    @Override
    public RequestResponseOK<JsonNode> getUnitsByTransaction(String transactionId, JsonNode query) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/transactions/" + transactionId + UNITS_PATH).withJson().withBody((Object)query);
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse result = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            RequestResponseOK requestResponseOK = (RequestResponseOK)result;
            return requestResponseOK;
        }
    }

    @Override
    public RequestResponseOK<JsonNode> getObjectById(String gotId) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/objects/" + gotId).withJsonAccept();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse result = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            RequestResponseOK requestResponseOK = (RequestResponseOK)result;
            return requestResponseOK;
        }
    }

    @Override
    public RequestResponse<JsonNode> initTransaction(TransactionDto transactionDto, String projectId) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/projects/" + projectId + TRANSACTION_PATH).withBody((Object)transactionDto).withJson();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponseOK<JsonNode> uploadArchiveUnit(JsonNode unitJsonNode, String transactionId) throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.post().withPath("/transactions/" + transactionId + UNITS_PATH).withBody((Object)unitJsonNode).withJson());){
            this.check(response);
            RequestResponse result = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            RequestResponseOK requestResponseOK = (RequestResponseOK)result;
            return requestResponseOK;
        }
    }

    @Override
    public RequestResponseOK<JsonNode> addObjectGroup(String unitId, Integer version, JsonNode objectJsonNode, String usage) throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.post().withPath("/units/" + unitId + "/objects/" + usage + "/" + version).withBody((Object)objectJsonNode).withJson());){
            this.check(response);
            RequestResponse result = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            RequestResponseOK requestResponseOK = (RequestResponseOK)result;
            return requestResponseOK;
        }
    }

    @Override
    public RequestResponse<JsonNode> addBinary(String unitId, Integer version, InputStream inputStreamUploaded, String usage) throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.post().withPath("/units/" + unitId + "/objects/" + usage + "/" + version + BINARY_PATH).withBody((Object)inputStreamUploaded).withJsonAccept().withOctetContentType());){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public Response closeTransaction(String transactionId) throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.post().withPath("/transactions/" + transactionId + "/close").withJsonAccept());){
            this.check(response);
            Response response2 = response;
            return response2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream generateSip(String transactionId) throws VitamClientException {
        Response response = null;
        boolean doNotCloseResponse = false;
        try {
            response = this.make(VitamRequestBuilder.post().withPath("/transactions/" + transactionId + "/send").withOctetAccept());
            this.check(response);
            doNotCloseResponse = true;
            InputStream inputStream = (InputStream)response.readEntity(InputStream.class);
            return inputStream;
        }
        finally {
            if (response != null && !doNotCloseResponse) {
                response.close();
            }
        }
    }

    @Override
    public Response abortTransaction(String transactionId) throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.put().withPath("/transactions/" + transactionId + "/abort").withJsonAccept());){
            this.check(response);
            Response response2 = response;
            return response2;
        }
    }

    @Override
    public Response reopenTransaction(String transactionId) throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.put().withPath("/transactions/" + transactionId + "/reopen").withJsonAccept());){
            this.check(response);
            Response response2 = response;
            return response2;
        }
    }

    @Override
    public void uploadZipToTransaction(String transactionId, InputStream inputStreamUploaded, @Nullable String encoding, @Nullable String attachementId) throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.post().withPath("/transactions/" + transactionId + "/upload").withOptionalHeader("X-Encoding", (Object)encoding).withOptionalHeader("X-Attachement-Id", (Object)attachementId).withBody((Object)inputStreamUploaded).withContentType(CommonMediaType.ZIP_TYPE));){
            this.check(response);
        }
    }

    @Override
    public String uploadZipToProject(String projectId, InputStream inputStreamUploaded, @Nullable String encoding) throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.post().withPath("/projects/" + projectId + "/upload").withBody((Object)inputStreamUploaded).withOptionalHeader("X-Encoding", (Object)encoding).withContentType(CommonMediaType.ZIP_TYPE).withJsonAccept());){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, String.class);
            String string = (String)((RequestResponseOK)requestResponse).getFirstResult();
            return string;
        }
    }

    @Override
    public RequestResponseOK<JsonNode> getUnitsByProjectId(String projectId, JsonNode dslQuery) throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.get().withPath("/projects/" + projectId + UNITS_PATH).withBody((Object)dslQuery).withJson());){
            this.check(response);
            RequestResponse result = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            RequestResponseOK requestResponseOK = (RequestResponseOK)result;
            return requestResponseOK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response getObjectStreamByUnitId(String unitId, String usage, int version) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/units/" + unitId + "/objects/" + usage + "/" + version + BINARY_PATH).withOctetAccept();
        Response response = null;
        boolean doNotCloseResponse = false;
        try {
            response = this.make(request);
            this.check(response);
            doNotCloseResponse = true;
            Response response2 = response;
            return response2;
        }
        finally {
            if (response != null && !doNotCloseResponse) {
                response.close();
            }
        }
    }

    @Override
    public RequestResponseOK<JsonNode> searchProject(CriteriaProjectDto criteria) throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.get().withPath(PROJECT_PATH).withBody((Object)criteria).withJson());){
            this.check(response);
            RequestResponse result = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            RequestResponseOK requestResponseOK = (RequestResponseOK)result;
            return requestResponseOK;
        }
    }

    @Override
    public RequestResponseOK<JsonNode> updateUnitsWithCsvMetadata(String transactionId, InputStream metadataCsvInputStream) throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.put().withPath("/transactions/" + transactionId + UNITS_METADATA_CSV_PATH).withBody((Object)metadataCsvInputStream).withContentType(CommonMediaType.TEXT_CSV_MEDIATYPE).withJsonAccept());){
            this.check(response);
            RequestResponse result = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            RequestResponseOK requestResponseOK = (RequestResponseOK)result;
            return requestResponseOK;
        }
    }

    public RequestResponseOK<JsonNode> updateUnitsWithJsonlMetadata(String transactionId, InputStream metadataJsonlInputStream) throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.put().withPath("/transactions/" + transactionId + UNITS_METADATA_JSONL_PATH).withBody((Object)metadataJsonlInputStream).withOctetContentType().withJsonAccept());){
            this.check(response);
            RequestResponse result = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            RequestResponseOK requestResponseOK = (RequestResponseOK)result;
            return requestResponseOK;
        }
    }

    private void check(Response response) throws VitamClientException {
        if (Response.Status.Family.SUCCESSFUL.equals((Object)response.getStatusInfo().toEnum().getFamily())) {
            return;
        }
        String template = "Error with the response, status: '%d' and reason '%s'.";
        String defaultReasonPhrase = Response.Status.fromStatusCode((int)response.getStatus()).getReasonPhrase();
        Response.ResponseBuilder responseBuilder = this.responseBuilderFrom(response);
        String message = String.format("Error with the response, status: '%d' and reason '%s'.", response.getStatus(), defaultReasonPhrase);
        try (Response clonedResponse = responseBuilder.build();){
            if (clonedResponse.hasEntity()) {
                message = (String)clonedResponse.readEntity(String.class);
            }
        }
        try {
            clonedResponse = responseBuilder.build();
            try {
                VitamError vitamError = RequestResponse.parseVitamError((Response)clonedResponse);
                if (StringUtils.isNotBlank((CharSequence)vitamError.getDescription())) {
                    message = vitamError.getDescription();
                } else if (StringUtils.isNotBlank((CharSequence)vitamError.getMessage())) {
                    message = vitamError.getMessage();
                }
                if (response.getStatusInfo().getStatusCode() == Response.Status.BAD_REQUEST.getStatusCode()) {
                    throw new CollectInternalClientInvalidRequestException(message);
                }
                if (response.getStatusInfo().getStatusCode() == Response.Status.NOT_FOUND.getStatusCode()) {
                    throw new CollectInternalClientNotFoundException(message);
                }
                throw new VitamClientException(message);
            }
            catch (Throwable throwable) {
                if (clonedResponse != null) {
                    try {
                        clonedResponse.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (InvalidParseOperationException e) {
            throw new VitamClientException(message);
        }
    }

    private Response.ResponseBuilder responseBuilderFrom(Response response) {
        Response.ResponseBuilder responseBuilder = Response.status((int)response.getStatus());
        for (String headerName : response.getHeaders().keySet()) {
            responseBuilder.header(headerName, (Object)response.getHeaderString(headerName));
        }
        for (NewCookie cookie : response.getCookies().values()) {
            responseBuilder.cookie(new NewCookie[]{cookie});
        }
        if (response.hasEntity()) {
            responseBuilder.entity(response.readEntity(String.class));
        }
        return responseBuilder;
    }

    @Override
    public RequestResponse<JsonNode> updateTransaction(TransactionDto transactionDto) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.put().withPath(TRANSACTION_PATH).withBody((Object)transactionDto).withJsonContentType().withJsonAccept();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public Response changeTransactionStatus(String transactionId, TransactionStatus transactionStatus) throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.put().withPath("/transactions/" + transactionId + "/status/" + String.valueOf(transactionStatus)).withJsonAccept());){
            this.check(response);
            Response response2 = response;
            return response2;
        }
    }

    @Override
    public RequestResponse<JsonNode> selectUnitsWithInheritedRules(String transactionId, JsonNode selectQuery) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/transactions/" + transactionId + UNITS_WITH_INHERITED_RULES).withBody((Object)selectQuery, BLANK_DSL).withJson();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public Response attachVitamOperationId(String transactionId, String operationId) throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.put().withPath("/transactions/" + transactionId + "/operation-id/" + operationId).withJsonAccept());){
            this.check(response);
            Response response2 = response;
            return response2;
        }
    }

    @Override
    public RequestResponse<JsonNode> getTransactionsToAutomaticallyIngest() throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/transactions/withAutomaticIngest").withJsonAccept();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponseOK<BulkAtomicUpdateResult> bulkAtomicUpdateUnits(String transactionId, JsonNode updateQueriesJson) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/transactions/" + transactionId + UNITS_BULK).withBody((Object)updateQueriesJson).withJson();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponseOK requestResponseOK = (RequestResponseOK)RequestResponse.parseFromResponse((Response)response, BulkAtomicUpdateResult.class);
            return requestResponseOK;
        }
    }

    @Override
    public RequestResponse<JsonNode> reclassification(String transactionId, JsonNode reclassificationRequest) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/transactions/" + transactionId + RECLASSIFICATION).withBody((Object)reclassificationRequest, BLANK_DSL).withJson();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> startEliminationAction(String transactionId, EliminationRequestBody eliminationRequestBody) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/transactions/" + transactionId + ELIMINATION_ACTION).withBody((Object)eliminationRequestBody).withJson();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> startDeletion(String transactionId, DeletionRequestBody deletionRequestBody) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/transactions/" + transactionId + DELETION_ACTION).withBody((Object)deletionRequestBody).withJson();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }
}

