/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.rest;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.api.VitamRepositoryProvider;
import fr.gouv.vitam.common.database.offset.OffsetRepository;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.GraphComputeResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.metadata.api.model.ReconstructionRequestItem;
import fr.gouv.vitam.metadata.api.model.ReconstructionResponseItem;
import fr.gouv.vitam.metadata.core.config.ElasticsearchMetadataIndexManager;
import fr.gouv.vitam.metadata.core.config.MetaDataConfiguration;
import fr.gouv.vitam.metadata.core.database.collections.MetadataCollections;
import fr.gouv.vitam.metadata.core.graph.StoreGraphService;
import fr.gouv.vitam.metadata.core.metrics.MetadataReconstructionMetricsCache;
import fr.gouv.vitam.metadata.core.reconstruction.service.MetadataReconstructionService;
import fr.gouv.vitam.metadata.rest.MetadataManagementResource;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientFactory;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/v1")
@Tag(name="Metadata")
public class MetadataReconstructionResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MetadataManagementResource.class);
    public static final String OBJECTGROUP = "OBJECTGROUP";
    public static final String UNIT = "UNIT";
    private static final String UNIT_OBJECTGROUP = "UNIT_OBJECTGROUP";
    private static final String RECONSTRUCTION_URI = "/reconstruction";
    private static final String STORE_GRAPH_URI = "/storegraph";
    private static final String PURGE_GRAPH_ONLY_DOCUMENTS_URI = "/purgeGraphOnlyDocuments";
    private static final String STORE_GRAPH_PROGRESS_URI = "/storegraph/progress";
    private static final String RECONSTRUCTION_JSON_MANDATORY_PARAMETERS_MSG = "the Json input of reconstruction's parameters is mandatory.";
    private static final String RECONSTRUCTION_EXCEPTION_MSG = "ERROR: Exception has been thrown when reconstructing Vitam collections: ";
    private static final String STORE_GRAPH_EXCEPTION_MSG = "ERROR: Exception has been thrown when sotre graph: ";
    private static final String ERROR_MSG = "{\"ErrorMsg\":\"";
    private final MetadataReconstructionService reconstructionService;
    private final StoreGraphService storeGraphService;

    MetadataReconstructionResource(VitamRepositoryProvider vitamRepositoryProvider, OffsetRepository offsetRepository, MetaDataConfiguration configuration, ElasticsearchMetadataIndexManager indexManager) {
        this(new MetadataReconstructionService(vitamRepositoryProvider, offsetRepository, indexManager, new MetadataReconstructionMetricsCache((long)configuration.getReconstructionMetricsCacheDurationInMinutes(), TimeUnit.MINUTES), configuration), new StoreGraphService(vitamRepositoryProvider), configuration);
    }

    @VisibleForTesting
    MetadataReconstructionResource(MetadataReconstructionService reconstructionService, StoreGraphService storeGraphService, MetaDataConfiguration configuration) {
        this.reconstructionService = reconstructionService;
        this.storeGraphService = storeGraphService;
        ProcessingManagementClientFactory.changeConfigurationUrl((String)configuration.getUrlProcessing());
    }

    @Path(value="/reconstruction")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response reconstructCollection(List<ReconstructionRequestItem> reconstructionItems) {
        ParametersChecker.checkParameter((String)RECONSTRUCTION_JSON_MANDATORY_PARAMETERS_MSG, (Object[])new Object[]{reconstructionItems});
        ArrayList responses = new ArrayList();
        if (!reconstructionItems.isEmpty()) {
            LOGGER.debug(String.format("Starting reconstruction Vitam service with the json parameters : (%s)", reconstructionItems));
            reconstructionItems.forEach(item -> {
                LOGGER.debug(String.format("Starting reconstruction for the collection {%s} on the tenant (%s) with (%s) elements", item.getCollection(), item.getTenant(), item.getLimit()));
                try {
                    responses.add(this.reconstructionService.reconstruct(item));
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error(RECONSTRUCTION_EXCEPTION_MSG, (Throwable)e);
                    responses.add(new ReconstructionResponseItem(item, StatusCode.KO));
                }
            });
        }
        return Response.ok((Object)new RequestResponseOK().addAllResults(responses)).build();
    }

    @Path(value="/storegraph")
    @GET
    @Produces(value={"application/json"})
    public Response storeGraph() {
        try {
            VitamThreadUtils.getVitamSession().initIfAbsent(VitamConfiguration.getAdminTenant());
            VitamThreadUtils.getVitamSession().setTenantId(VitamConfiguration.getAdminTenant());
            Map map = this.storeGraphService.tryStoreGraph();
            return Response.ok().entity((Object)map).build();
        }
        catch (Exception e) {
            LOGGER.error(STORE_GRAPH_EXCEPTION_MSG, (Throwable)e);
            return Response.serverError().entity((Object)(ERROR_MSG + e.getMessage() + "\"}")).build();
        }
    }

    @Path(value="/storegraph/progress")
    @GET
    @Produces(value={"application/json"})
    public Response storeGraphInProgress() {
        VitamThreadUtils.getVitamSession().initIfAbsent(VitamConfiguration.getAdminTenant());
        boolean inProgress = this.storeGraphService.isInProgress();
        if (inProgress) {
            LOGGER.info("Store graph in progress ...");
            return Response.ok((Object)"{\"msg\": \"Store graph in progress ...\"}").build();
        }
        LOGGER.info("No active store graph");
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"{\"msg\": \"No active store graph\"}").build();
    }

    @Path(value="/purgeGraphOnlyDocuments/{collection:UNIT|OBJECTGROUP|UNIT_OBJECTGROUP}")
    @DELETE
    @Produces(value={"application/json"})
    public Response purgeReconstructedDocumentsWithGraphOnlyData(@PathParam(value="collection") GraphComputeResponse.GraphComputeAction action) {
        try {
            switch (action) {
                case UNIT: {
                    this.reconstructionService.purgeReconstructedDocumentsWithGraphOnlyData(MetadataCollections.UNIT);
                    break;
                }
                case OBJECTGROUP: {
                    this.reconstructionService.purgeReconstructedDocumentsWithGraphOnlyData(MetadataCollections.OBJECTGROUP);
                    break;
                }
                case UNIT_OBJECTGROUP: {
                    this.reconstructionService.purgeReconstructedDocumentsWithGraphOnlyData(MetadataCollections.UNIT);
                    this.reconstructionService.purgeReconstructedDocumentsWithGraphOnlyData(MetadataCollections.OBJECTGROUP);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not implemented action :" + String.valueOf(action));
                }
            }
            return Response.ok().build();
        }
        catch (Exception e) {
            LOGGER.error("Could not purge reconstructed documents with graph only data", (Throwable)e);
            return Response.serverError().entity((Object)(ERROR_MSG + e.getMessage() + "\"}")).build();
        }
    }
}

