/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.rest;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.ServerIdentity;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.VitamApplicationServerException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.server.application.resources.VitamServiceRegistry;
import fr.gouv.vitam.common.serverv2.VitamStarter;
import fr.gouv.vitam.metadata.core.config.MetaDataConfiguration;
import fr.gouv.vitam.metadata.rest.AdminMetadataApplication;
import fr.gouv.vitam.metadata.rest.BusinessApplication;

public class MetadataMain {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MetadataMain.class);
    public static final String PARAMETER_JETTY_SERVER_PORT = "jetty.metadata.port";
    private static final String CONF_FILE_NAME = "storage-engine.conf";
    private static final String MODULE_NAME = ServerIdentity.getInstance().getRole();
    private VitamStarter vitamStarter;

    public MetadataMain(String configurationFile) {
        ParametersChecker.checkParameter((String)String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME), (String[])new String[]{configurationFile});
        this.vitamStarter = new VitamStarter(MetaDataConfiguration.class, configurationFile, BusinessApplication.class, AdminMetadataApplication.class);
    }

    public static void main(String[] args) {
        try {
            if (args == null || args.length == 0) {
                LOGGER.error(String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME));
                throw new IllegalArgumentException(String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME));
            }
            MetadataMain storageMain = new MetadataMain(args[0]);
            VitamServiceRegistry serviceRegistry = new VitamServiceRegistry();
            serviceRegistry.checkDependencies(VitamConfiguration.getRetryNumber().intValue(), (long)VitamConfiguration.getRetryDelay().intValue());
            storageMain.startAndJoin();
        }
        catch (Exception e) {
            LOGGER.error(String.format("%s application server can not start. ", MODULE_NAME) + e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    public void start() throws VitamApplicationServerException {
        this.vitamStarter.start();
    }

    public void startAndJoin() throws VitamApplicationServerException {
        this.vitamStarter.run();
    }

    public void stop() throws VitamApplicationServerException {
        this.vitamStarter.stop();
    }
}

