/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.rest;

import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.api.VitamRepositoryFactory;
import fr.gouv.vitam.common.database.api.VitamRepositoryProvider;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.processing.WorkFlowExecutionContext;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.metadata.audit.core.MetadataAuditService;
import fr.gouv.vitam.metadata.core.config.ElasticsearchMetadataIndexManager;
import fr.gouv.vitam.metadata.core.config.MetaDataConfiguration;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/v1")
@Tag(name="Metadata")
public class MetadataAuditResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MetadataAuditResource.class);
    private final MetadataAuditService metadataAuditService;

    public MetadataAuditResource(MetaDataConfiguration metaDataConfiguration) {
        this.metadataAuditService = new MetadataAuditService(WorkspaceClientFactory.getInstance((WorkFlowExecutionContext)WorkFlowExecutionContext.VITAM), LogbookOperationsClientFactory.getInstance(), (VitamRepositoryProvider)VitamRepositoryFactory.get(), new ElasticsearchMetadataIndexManager(metaDataConfiguration, VitamConfiguration.getTenants()), metaDataConfiguration.getIsDataConsistencyAuditRunnable(), metaDataConfiguration.isEnableDataConsistencyRectificationMode(), metaDataConfiguration.getDataConsistencyAuditOplogMaxSize(), metaDataConfiguration.getMongodShardsConf(), metaDataConfiguration.isDbAuthentication());
        LOGGER.info("init MetaData Audit Resource server");
        ProcessingManagementClientFactory.changeConfigurationUrl((String)metaDataConfiguration.getUrlProcessing());
    }

    @GET
    @Path(value="/auditDataConsistency")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response runAuditDataConsistencyMongoEs() {
        LOGGER.debug("Audit data consistency : Running ...");
        try {
            VitamThreadUtils.getVitamSession().initIfAbsent(VitamConfiguration.getAdminTenant());
            return this.metadataAuditService.auditDataConsistencyMongoEs();
        }
        catch (LogbookClientBadRequestException | LogbookClientNotFoundException | LogbookClientServerException e) {
            LOGGER.error(e);
            return Response.serverError().build();
        }
    }
}

