'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var acorn = require('acorn');
var bson = require('bson');

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n["default"] = e;
  return Object.freeze(n);
}

var bson__namespace = /*#__PURE__*/_interopNamespace(bson);

function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}

function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  Object.defineProperty(Constructor, "prototype", {
    writable: false
  });
  return Constructor;
}

function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
}

function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) {
    o.__proto__ = p;
    return o;
  };
  return _setPrototypeOf(o, p);
}

function _isNativeReflectConstruct() {
  if (typeof Reflect === "undefined" || !Reflect.construct) return false;
  if (Reflect.construct.sham) return false;
  if (typeof Proxy === "function") return true;

  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {}));
    return true;
  } catch (e) {
    return false;
  }
}

function _construct(Parent, args, Class) {
  if (_isNativeReflectConstruct()) {
    _construct = Reflect.construct.bind();
  } else {
    _construct = function _construct(Parent, args, Class) {
      var a = [null];
      a.push.apply(a, args);
      var Constructor = Function.bind.apply(Parent, a);
      var instance = new Constructor();
      if (Class) _setPrototypeOf(instance, Class.prototype);
      return instance;
    };
  }

  return _construct.apply(null, arguments);
}

function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length) len = arr.length;

  for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];

  return arr2;
}

function _arrayWithoutHoles(arr) {
  if (Array.isArray(arr)) return _arrayLikeToArray(arr);
}

function _iterableToArray(iter) {
  if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
}

function _unsupportedIterableToArray(o, minLen) {
  if (!o) return;
  if (typeof o === "string") return _arrayLikeToArray(o, minLen);
  var n = Object.prototype.toString.call(o).slice(8, -1);
  if (n === "Object" && o.constructor) n = o.constructor.name;
  if (n === "Map" || n === "Set") return Array.from(o);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
}

function _nonIterableSpread() {
  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}

function _toConsumableArray(arr) {
  return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
}

function NumberLong(v) {
  if (typeof v === 'string') {
    return bson__namespace.Long.fromString(v);
  } else {
    return bson__namespace.Long.fromNumber(v);
  }
}

var SCOPE_CALL = {
  Date: function (_Date) {
    function Date() {
      return _Date.apply(this, arguments);
    }

    Date.toString = function () {
      return _Date.toString();
    };

    return Date;
  }(function () {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    // casting our arguments as an empty array because we don't know
    // the length of our arguments, and should allow users to pass what
    // they want as date arguments
    return Date.apply(void 0, _toConsumableArray(args));
  })
};
var SCOPE_NEW = {
  Date: function (_Date2) {
    function Date() {
      return _Date2.apply(this, arguments);
    }

    Date.toString = function () {
      return _Date2.toString();
    };

    return Date;
  }(function () {
    for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }

    // casting our arguments as an empty array because we don't know
    // the length of our arguments, and should allow users to pass what
    // they want as date arguments
    return _construct(Date, _toConsumableArray(args));
  })
};
var SCOPE_ANY = {
  RegExp: RegExp,
  Binary: function Binary(buffer, subType) {
    return new bson__namespace.Binary(buffer, subType);
  },
  BinData: function BinData(t, d) {
    return new bson__namespace.Binary(Buffer.from(d, 'base64'), t);
  },
  UUID: function UUID(u) {
    if (u === undefined) {
      return new bson__namespace.UUID().toBinary();
    }

    return new bson__namespace.Binary(Buffer.from(u.replace(/-/g, ''), 'hex'), 4);
  },
  Code: function Code(c, s) {
    return new bson__namespace.Code(c, s);
  },
  DBRef: function DBRef(namespace, oid, db, fields) {
    return new bson__namespace.DBRef(namespace, oid, db, fields);
  },
  Decimal128: function Decimal128(s) {
    return bson__namespace.Decimal128.fromString(s);
  },
  NumberDecimal: function NumberDecimal(s) {
    return bson__namespace.Decimal128.fromString(s);
  },
  Double: function Double(s) {
    return new bson__namespace.Double(s);
  },
  Int32: function Int32(i) {
    return new bson__namespace.Int32(i);
  },
  NumberInt: function NumberInt(s) {
    return parseInt(s, 10);
  },
  Long: function Long(low, high) {
    return new bson__namespace.Long(low, high);
  },
  NumberLong: NumberLong,
  Int64: NumberLong,
  Map: function (_Map) {
    function Map(_x) {
      return _Map.apply(this, arguments);
    }

    Map.toString = function () {
      return _Map.toString();
    };

    return Map;
  }(function (arr) {
    var _Map2;

    return new ((_Map2 = bson__namespace.Map) !== null && _Map2 !== void 0 ? _Map2 : Map)(arr);
  }),
  MaxKey: function MaxKey() {
    return new bson__namespace.MaxKey();
  },
  MinKey: function MinKey() {
    return new bson__namespace.MinKey();
  },
  ObjectID: function ObjectID(i) {
    return new bson__namespace.ObjectId(i);
  },
  ObjectId: function ObjectId(i) {
    return new bson__namespace.ObjectId(i);
  },
  Symbol: function Symbol(i) {
    return new bson__namespace.BSONSymbol(i);
  },
  Timestamp: function Timestamp(low, high) {
    if (typeof low === 'number' && typeof high === 'number' || high !== undefined) {
      // https://www.mongodb.com/docs/manual/reference/bson-types/#timestamps
      // reverse the order to match the legacy shell
      return new bson__namespace.Timestamp({
        t: low,
        i: high
      });
    }

    return new bson__namespace.Timestamp(low);
  },
  ISODate: function ISODate() {
    for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
      args[_key3] = arguments[_key3];
    }

    // casting our arguments as an empty array because we don't know
    // the length of our arguments, and should allow users to pass what
    // they want as date arguments
    return _construct(Date, _toConsumableArray(args));
  }
};
var GLOBALS = Object.freeze({
  Infinity: Infinity,
  NaN: NaN,
  undefined: undefined
});
var ALLOWED_CLASS_EXPRESSIONS = {
  Math: {
    class: Math,
    allowedMethods: {
      abs: true,
      acos: true,
      acosh: true,
      asin: true,
      asinh: true,
      atan: true,
      atan2: true,
      atanh: true,
      cbrt: true,
      ceil: true,
      clz32: true,
      cos: true,
      cosh: true,
      exp: true,
      expm1: true,
      floor: true,
      fround: true,
      hypot: true,
      imul: true,
      log: true,
      log10: true,
      log1p: true,
      log2: true,
      max: true,
      min: true,
      pow: true,
      round: true,
      sign: true,
      sin: true,
      sinh: true,
      sqrt: true,
      tan: true,
      tanh: true,
      trunc: true
    }
  },
  Date: {
    class: Date,
    allowedMethods: {
      getDate: true,
      getDay: true,
      getFullYear: true,
      getHours: true,
      getMilliseconds: true,
      getMinutes: true,
      getMonth: true,
      getSeconds: true,
      getTime: true,
      getTimezoneOffset: true,
      getUTCDate: true,
      getUTCDay: true,
      getUTCFullYear: true,
      getUTCHours: true,
      getUTCMilliseconds: true,
      getUTCMinutes: true,
      getUTCMonth: true,
      getUTCSeconds: true,
      getYear: true,
      now: true,
      setDate: true,
      setFullYear: true,
      setHours: true,
      setMilliseconds: true,
      setMinutes: true,
      setMonth: true,
      setSeconds: true,
      setTime: true,
      setUTCDate: true,
      setUTCFullYear: true,
      setUTCHours: true,
      setUTCMilliseconds: true,
      setUTCMinutes: true,
      setUTCMonth: true,
      setUTCSeconds: true,
      setYear: true,
      toISOString: true
    }
  },
  ISODate: {
    class: Date,
    allowedMethods: 'Date'
  }
};
var GLOBAL_FUNCTIONS = Object.freeze([].concat(_toConsumableArray(Object.keys(SCOPE_ANY)), _toConsumableArray(Object.keys(SCOPE_NEW)), _toConsumableArray(Object.keys(SCOPE_CALL))));
function getScopeFunction(key, withNew) {
  if (withNew && SCOPE_NEW[key]) {
    return SCOPE_NEW[key];
  } else if (!withNew && SCOPE_CALL[key]) {
    return SCOPE_CALL[key];
  } else if (SCOPE_ANY[key]) {
    return SCOPE_ANY[key];
  }

  throw new Error("Attempted to access scope property '".concat(key, "' that doesn't exist"));
}
function isMethodWhitelisted(member, property) {
  if (ALLOWED_CLASS_EXPRESSIONS[member]) {
    var allowedMethods = ALLOWED_CLASS_EXPRESSIONS[member].allowedMethods;

    if (typeof allowedMethods === 'string') {
      return ALLOWED_CLASS_EXPRESSIONS[allowedMethods].allowedMethods[property];
    }

    return allowedMethods[property];
  }

  return false;
}
function getClass(member) {
  if (ALLOWED_CLASS_EXPRESSIONS[member]) {
    return ALLOWED_CLASS_EXPRESSIONS[member].class;
  }

  throw new Error("Attempted to access member '".concat(member, "' that doesn't exist"));
}

var Checker = /*#__PURE__*/_createClass(function Checker(options) {
  var _this = this;

  _classCallCheck(this, Checker);

  this.options = options;

  _defineProperty(this, "checkSafeCall", function (node) {
    var allowMethods = _this.options.allowMethods;

    if (node.callee.type === 'Identifier') {
      return GLOBAL_FUNCTIONS.indexOf(node.callee.name) >= 0 && node.arguments.every(_this.checkSafeExpression);
    }

    if (allowMethods) {
      if (node.callee.type === 'MemberExpression') {
        var object = node.callee.object;
        var property = node.callee.property; // If we're only referring to identifiers, we don't need to check deeply.

        if (object.type === 'Identifier' && property.type === 'Identifier') {
          return isMethodWhitelisted(object.name, property.name) && node.arguments.every(_this.checkSafeExpression);
        } else if ((object.type === 'NewExpression' || object.type === 'CallExpression') && object.callee.type === 'Identifier') {
          var callee = object.callee;
          return isMethodWhitelisted(callee.name, property.name) && node.arguments.every(_this.checkSafeExpression);
        } else {
          return _this.checkSafeExpression(object) && node.arguments.every(_this.checkSafeExpression);
        }
      }
    }

    return false;
  });

  _defineProperty(this, "checkSafeExpression", function (node) {
    switch (node.type) {
      case 'Identifier':
        return GLOBALS.hasOwnProperty(node.name);

      case 'Literal':
        return true;

      case 'ArrayExpression':
        return node.elements.every(_this.checkSafeExpression);

      case 'UnaryExpression':
        // Note: this does allow using the `delete`, `typeof`, and `void` operators
        return _this.checkSafeExpression(node.argument);

      case 'BinaryExpression':
        // Note: this does allow using the `instanceof`, `in`, and bitwise operators
        return _this.checkSafeExpression(node.left) && _this.checkSafeExpression(node.right);

      case 'CallExpression':
      case 'NewExpression':
        // allows both `new Date(...)` and `Date(...)` function calls
        return _this.checkSafeCall(node);

      case 'ObjectExpression':
        return node.properties.every(function (property) {
          // don't allow computed values { [10 + 10]: ... }
          // don't allow method properties { start() {...} }
          if (property.computed || property.method) return false; // only allow literals { 10: ...} or identifiers { name: ... } as keys

          if (!['Literal', 'Identifier'].includes(property.key.type)) return false; // object values can be a function expression or any safe expression

          return ['FunctionExpression', 'ArrowFunctionExpression'].includes(property.value.type) || _this.checkSafeExpression(property.value);
        });

      default:
        return false;
    }
  });
}
/**
 * Only allow CallExpressions where the Identifier matches a whitelist of safe
 * globals, and where the arguments are themselves safe expressions
 */
);

var checkTree = function checkTree(node, options) {
  if (node.type === 'Program') {
    if (node.body.length === 1 && node.body[0].type === 'ExpressionStatement') {
      var checker = new Checker(options);
      return checker.checkSafeExpression(node.body[0].expression);
    }
  }

  return false;
};

var unaryExpression = function unaryExpression(node) {
  if (!node.prefix) throw new Error('Malformed UnaryExpression');

  switch (node.operator) {
    case '-':
      return -walk(node.argument);

    case '+':
      return +walk(node.argument);

    case '!':
      return !walk(node.argument);

    case '~':
      return ~walk(node.argument);

    default:
      throw new Error("Invalid UnaryExpression Provided: '".concat(node.operator, "'"));
  }
};

var binaryExpression = function binaryExpression(node) {
  var left = node.left,
      right = node.right;

  switch (node.operator) {
    case '==':
      return walk(left) == walk(right);

    case '!=':
      return walk(left) != walk(right);

    case '===':
      return walk(left) === walk(right);

    case '!==':
      return walk(left) !== walk(right);

    case '<':
      return walk(left) < walk(right);

    case '<=':
      return walk(left) <= walk(right);

    case '>':
      return walk(left) > walk(right);

    case '>=':
      return walk(left) >= walk(right);

    case '<<':
      return walk(left) << walk(right);

    case '>>':
      return walk(left) >> walk(right);

    case '>>>':
      return walk(left) >>> walk(right);

    case '+':
      return walk(left) + walk(right);

    case '-':
      return walk(left) - walk(right);

    case '*':
      return walk(left) * walk(right);

    case '/':
      return walk(left) / walk(right);

    case '%':
      return walk(left) % walk(right);

    case '**':
      return Math.pow(walk(left), walk(right));

    case '|':
      return walk(left) | walk(right);

    case '^':
      return walk(left) ^ walk(right);

    case '&':
      return walk(left) & walk(right);

    case 'in':
      return walk(left) in walk(right);

    case 'instanceof':
      return walk(left) instanceof walk(right);

    default:
      throw new Error("Invalid BinaryExpression Provided: '".concat(node.operator, "'"));
  }
};

var memberExpression = function memberExpression(node, withNew) {
  switch (node.callee.type) {
    case 'Identifier':
      {
        // Handing <Constructor>() and new <Constructor>() cases
        var callee = getScopeFunction(node.callee.name, withNew);
        var args = node.arguments.map(function (arg) {
          return walk(arg);
        });
        return callee.apply(callee, args);
      }

    case 'MemberExpression':
      {
        // If they're using a static method or a member
        var calleeThis = node.callee.object.type === 'Identifier' ? getClass(node.callee.object.name) : walk(node.callee.object);
        var calleeFn = node.callee.property.type === 'Identifier' && node.callee.property.name;
        if (!calleeFn) throw new Error('Expected CallExpression property to be an identifier');

        var _args = node.arguments.map(function (arg) {
          return walk(arg);
        });

        return calleeThis[calleeFn].apply(calleeThis, _args);
      }

    default:
      throw new Error('Should not evaluate invalid expressions');
  }
};

var functionExpression = function functionExpression(node) {
  var _node$loc;

  var source = ((_node$loc = node.loc) === null || _node$loc === void 0 ? void 0 : _node$loc.source) || '';
  var range = node.range || [];
  return source.slice(range[0], range[1]);
};

var walk = function walk(node) {
  switch (node.type) {
    case 'Identifier':
      if (GLOBALS.hasOwnProperty(node.name)) {
        return GLOBALS[node.name];
      }

      throw new Error("".concat(node.name, " is not a valid Identifier"));

    case 'Literal':
      return node.value;

    case 'UnaryExpression':
      return unaryExpression(node);

    case 'BinaryExpression':
      return binaryExpression(node);

    case 'ArrayExpression':
      return node.elements.map(function (node) {
        return walk(node);
      });

    case 'CallExpression':
      return memberExpression(node, false);

    case 'NewExpression':
      return memberExpression(node, true);

    case 'ObjectExpression':
      var obj = {};
      node.properties.forEach(function (property) {
        var key = property.key.type === 'Identifier' ? property.key.name : walk(property.key);
        obj[key] = walk(property.value);
      });
      return obj;

    case 'FunctionExpression':
    case 'ArrowFunctionExpression':
      return functionExpression(node);

    default:
      throw new Error();
  }
};

var executeAST = function executeAST(node) {
  if (node.type === 'Program') {
    if (node.body.length === 1 && node.body[0].type === 'ExpressionStatement') {
      return walk(node.body[0].expression);
    }
  }

  throw new Error('Invalid AST Found');
};

function ownKeys(object, enumerableOnly) {
  var keys = Object.keys(object);

  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function (sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }

  return keys;
}

function _objectSpread2(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = null != arguments[i] ? arguments[i] : {};
    i % 2 ? ownKeys(Object(source), !0).forEach(function (key) {
      _defineProperty(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }

  return target;
}

exports.ParseMode = void 0;

(function (ParseMode) {
  ParseMode["Strict"] = "strict";
  ParseMode["Extended"] = "extended";
  ParseMode["Loose"] = "loose";
})(exports.ParseMode || (exports.ParseMode = {}));

var StrictOptions = {
  allowMethods: false,
  // Allow function calls, ie Date.now(), Math.Max(), (new Date()).getFullYear()
  allowComments: false // Allow comments (// and /* */)

};
var ExtendedOptions = {
  allowMethods: true
};
var LooseOptions = {
  allowMethods: true,
  allowComments: true
};

function getModeOptions(mode) {
  switch (mode) {
    case exports.ParseMode.Strict:
      return StrictOptions;

    case exports.ParseMode.Extended:
      return ExtendedOptions;

    case exports.ParseMode.Loose:
      return LooseOptions;
  }
}

var DefaultOptions = _objectSpread2({
  mode: exports.ParseMode.Strict
}, StrictOptions);

function buildOptions(options) {
  return _objectSpread2(_objectSpread2(_objectSpread2({}, DefaultOptions), getModeOptions(options && options.mode || exports.ParseMode.Strict)), options);
}

function buildAST(input) {
  var hasComments = false;
  var ast = acorn.parse(input, {
    ecmaVersion: 6,
    onComment: function onComment() {
      return hasComments = true;
    },
    locations: true,
    ranges: true,
    sourceFile: input
  });
  return {
    ast: ast,
    hasComments: hasComments
  };
}
function parse(input, options) {
  var parsedOptions = buildOptions(options);

  var _buildAST = buildAST( // Wrapping input into brackets with newlines so that parser can correctly
  // process an expression and handle possible trailing comments
  "(\n".concat(input, "\n)")),
      hasComments = _buildAST.hasComments,
      ast = _buildAST.ast;

  var passedCommentsCheck = !hasComments || parsedOptions.allowComments;

  if (passedCommentsCheck && checkTree(ast, parsedOptions)) {
    return executeAST(ast);
  }

  return '';
}

exports["default"] = parse;
