/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.builder.request.single;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.RequestSingle;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class Update
extends RequestSingle {
    protected List<Action> actions = new ArrayList<Action>();

    public final Update resetActions() {
        if (this.actions != null) {
            this.actions.forEach(new Consumer<Action>(){

                @Override
                public void accept(Action t) {
                    t.clean();
                }
            });
            this.actions.clear();
        }
        return this;
    }

    @Override
    public final Update reset() {
        super.reset();
        this.resetActions();
        return this;
    }

    public final Update setMult(boolean mult) {
        if (this.filter == null) {
            this.filter = JsonHandler.createObjectNode();
        }
        this.filter.put(BuilderToken.MULTIFILTER.MULT.exactToken(), mult);
        return this;
    }

    public final Update setMult(JsonNode filterContent) {
        if (this.filter == null) {
            this.filter = JsonHandler.createObjectNode();
        }
        if (filterContent.has(BuilderToken.MULTIFILTER.MULT.exactToken())) {
            this.filter.setAll((ObjectNode)filterContent);
        }
        return this;
    }

    @Override
    public final Update setFilter(JsonNode filterContent) throws InvalidParseOperationException {
        super.setFilter(filterContent);
        return this.setMult(filterContent);
    }

    public final Update addActions(Action ... action) throws InvalidCreateOperationException {
        for (Action act : action) {
            if (!act.isReady()) {
                throw new InvalidCreateOperationException("Action is not ready to be added: " + String.valueOf(act.getCurrentAction()));
            }
            this.actions.add(act);
        }
        return this;
    }

    public final ObjectNode getFinalUpdateById() {
        ObjectNode node = this.getFinalUpdate();
        node.remove(BuilderToken.GLOBAL.QUERY.exactToken());
        node.remove(BuilderToken.GLOBAL.FILTER.exactToken());
        node.remove(BuilderToken.GLOBAL.PROJECTION.exactToken());
        return node;
    }

    public final ObjectNode getFinalUpdate() {
        ObjectNode node = this.getFinal();
        if (this.actions != null && !this.actions.isEmpty()) {
            ArrayNode array = JsonHandler.createArrayNode();
            for (Action action : this.actions) {
                array.add((JsonNode)action.getCurrentAction());
            }
            node.set(BuilderToken.GLOBAL.ACTION.exactToken(), (JsonNode)array);
        } else {
            node.putArray(BuilderToken.GLOBAL.ACTION.exactToken());
        }
        return node;
    }

    @Override
    public final List<Action> getActions() {
        return this.actions;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UPDATEACTION: ").append(super.toString()).append("\n\tActions: ");
        for (Action subaction : this.getActions()) {
            builder.append("\n").append(subaction);
        }
        return builder.toString();
    }
}

