/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.builder.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.configuration.GlobalDatas;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import java.time.LocalDateTime;
import java.util.Date;

public class RangeQuery
extends Query {
    private static final String IS_NOT_A_VALID_COMPARE_QUERY = " is not a valid Compare Query";
    private static final String CANNOT_BE_UPDATED_WITH_EMPTY_VARIABLE_NAME = " cannot be updated with empty variable name";
    private static final String QUERY2 = "Query ";

    protected RangeQuery() {
    }

    public RangeQuery(String variableName, BuilderToken.QUERY from, long valueFrom, BuilderToken.QUERY to, long valueTo) throws InvalidCreateOperationException {
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(QUERY2 + String.valueOf((Object)this.currentTokenQUERY) + CANNOT_BE_UPDATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        switch (from) {
            case GT: 
            case GTE: {
                break;
            }
            default: {
                throw new InvalidCreateOperationException(QUERY2 + String.valueOf((Object)from) + IS_NOT_A_VALID_COMPARE_QUERY);
            }
        }
        switch (to) {
            case LT: 
            case LTE: {
                break;
            }
            default: {
                throw new InvalidCreateOperationException(QUERY2 + String.valueOf((Object)to) + IS_NOT_A_VALID_COMPARE_QUERY);
            }
        }
        ObjectNode sub = ((ObjectNode)this.currentObject).putObject(BuilderToken.QUERY.RANGE.exactToken()).putObject(variableName.trim());
        sub.put(from.exactToken(), valueFrom);
        sub.put(to.exactToken(), valueTo);
        this.currentTokenQUERY = BuilderToken.QUERY.RANGE;
        this.setReady(true);
    }

    public RangeQuery(String variableName, BuilderToken.QUERY from, double valueFrom, BuilderToken.QUERY to, double valueTo) throws InvalidCreateOperationException {
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(QUERY2 + String.valueOf((Object)this.currentTokenQUERY) + CANNOT_BE_UPDATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        switch (from) {
            case GT: 
            case GTE: {
                break;
            }
            default: {
                throw new InvalidCreateOperationException(QUERY2 + String.valueOf((Object)from) + IS_NOT_A_VALID_COMPARE_QUERY);
            }
        }
        switch (to) {
            case LT: 
            case LTE: {
                break;
            }
            default: {
                throw new InvalidCreateOperationException(QUERY2 + String.valueOf((Object)to) + IS_NOT_A_VALID_COMPARE_QUERY);
            }
        }
        ObjectNode sub = ((ObjectNode)this.currentObject).putObject(BuilderToken.QUERY.RANGE.exactToken()).putObject(variableName.trim());
        sub.put(from.exactToken(), valueFrom);
        sub.put(to.exactToken(), valueTo);
        this.currentTokenQUERY = BuilderToken.QUERY.RANGE;
        this.setReady(true);
    }

    public RangeQuery(String variableName, BuilderToken.QUERY from, String valueFrom, BuilderToken.QUERY to, String valueTo) throws InvalidCreateOperationException {
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(QUERY2 + String.valueOf((Object)this.currentTokenQUERY) + CANNOT_BE_UPDATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
            GlobalDatas.sanityValueCheck(valueFrom);
            GlobalDatas.sanityValueCheck(valueTo);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        switch (from) {
            case GT: 
            case GTE: {
                break;
            }
            default: {
                throw new InvalidCreateOperationException(QUERY2 + String.valueOf((Object)from) + IS_NOT_A_VALID_COMPARE_QUERY);
            }
        }
        switch (to) {
            case LT: 
            case LTE: {
                break;
            }
            default: {
                throw new InvalidCreateOperationException(QUERY2 + String.valueOf((Object)to) + IS_NOT_A_VALID_COMPARE_QUERY);
            }
        }
        ObjectNode sub = ((ObjectNode)this.currentObject).putObject(BuilderToken.QUERY.RANGE.exactToken()).putObject(variableName.trim());
        sub.put(from.exactToken(), valueFrom);
        sub.put(to.exactToken(), valueTo);
        this.currentTokenQUERY = BuilderToken.QUERY.RANGE;
        this.setReady(true);
    }

    public RangeQuery(String variableName, BuilderToken.QUERY from, Date valueFrom, BuilderToken.QUERY to, Date valueTo) throws InvalidCreateOperationException {
        if (variableName == null || variableName.trim().isEmpty()) {
            throw new InvalidCreateOperationException(QUERY2 + String.valueOf((Object)this.currentTokenQUERY) + CANNOT_BE_UPDATED_WITH_EMPTY_VARIABLE_NAME);
        }
        try {
            GlobalDatas.sanityParameterCheck(variableName);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        switch (from) {
            case GT: 
            case GTE: {
                break;
            }
            default: {
                throw new InvalidCreateOperationException(QUERY2 + String.valueOf((Object)from) + IS_NOT_A_VALID_COMPARE_QUERY);
            }
        }
        switch (to) {
            case LT: 
            case LTE: {
                break;
            }
            default: {
                throw new InvalidCreateOperationException(QUERY2 + String.valueOf((Object)to) + IS_NOT_A_VALID_COMPARE_QUERY);
            }
        }
        ObjectNode sub = ((ObjectNode)this.currentObject).putObject(BuilderToken.QUERY.RANGE.exactToken()).putObject(variableName.trim());
        sub.set(from.exactToken(), (JsonNode)new TextNode(LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)LocalDateUtil.fromDate((Date)valueFrom))));
        sub.set(to.exactToken(), (JsonNode)new TextNode(LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)LocalDateUtil.fromDate((Date)valueTo))));
        this.currentTokenQUERY = BuilderToken.QUERY.RANGE;
        this.setReady(true);
    }
}

