/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.builder.query;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.CompareQuery;
import fr.gouv.vitam.common.database.builder.query.ExistsQuery;
import fr.gouv.vitam.common.database.builder.query.InQuery;
import fr.gouv.vitam.common.database.builder.query.MatchQuery;
import fr.gouv.vitam.common.database.builder.query.MltQuery;
import fr.gouv.vitam.common.database.builder.query.NestedQuery;
import fr.gouv.vitam.common.database.builder.query.PathQuery;
import fr.gouv.vitam.common.database.builder.query.RangeQuery;
import fr.gouv.vitam.common.database.builder.query.SearchQuery;
import fr.gouv.vitam.common.database.builder.query.TermQuery;
import fr.gouv.vitam.common.database.builder.query.WildcardQuery;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import java.util.Date;
import java.util.Map;

public class QueryHelper {
    protected QueryHelper() {
    }

    public static final PathQuery path(String ... pathes) throws InvalidCreateOperationException {
        return new PathQuery(pathes);
    }

    public static final BooleanQuery and() throws InvalidCreateOperationException {
        return new BooleanQuery(BuilderToken.QUERY.AND);
    }

    public static final BooleanQuery or() throws InvalidCreateOperationException {
        return new BooleanQuery(BuilderToken.QUERY.OR);
    }

    public static final BooleanQuery not() throws InvalidCreateOperationException {
        return new BooleanQuery(BuilderToken.QUERY.NOT);
    }

    public static final CompareQuery eq(String variableName, boolean value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.EQ, variableName, value);
    }

    public static final CompareQuery eq(String variableName, long value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.EQ, variableName, value);
    }

    public static final CompareQuery eq(String variableName, double value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.EQ, variableName, value);
    }

    public static final CompareQuery eq(String variableName, String value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.EQ, variableName, value);
    }

    public static final CompareQuery eq(String variableName, Date value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.EQ, variableName, value);
    }

    public static final CompareQuery ne(String variableName, boolean value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.NE, variableName, value);
    }

    public static final CompareQuery ne(String variableName, long value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.NE, variableName, value);
    }

    public static final CompareQuery ne(String variableName, double value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.NE, variableName, value);
    }

    public static final CompareQuery ne(String variableName, String value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.NE, variableName, value);
    }

    public static final CompareQuery ne(String variableName, Date value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.NE, variableName, value);
    }

    public static final CompareQuery lt(String variableName, boolean value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.LT, variableName, value);
    }

    public static final CompareQuery lt(String variableName, long value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.LT, variableName, value);
    }

    public static final CompareQuery lt(String variableName, double value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.LT, variableName, value);
    }

    public static final CompareQuery lt(String variableName, String value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.LT, variableName, value);
    }

    public static final CompareQuery lt(String variableName, Date value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.LT, variableName, value);
    }

    public static final CompareQuery lte(String variableName, boolean value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.LTE, variableName, value);
    }

    public static final CompareQuery lte(String variableName, long value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.LTE, variableName, value);
    }

    public static final CompareQuery lte(String variableName, double value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.LTE, variableName, value);
    }

    public static final CompareQuery lte(String variableName, String value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.LTE, variableName, value);
    }

    public static final CompareQuery lte(String variableName, Date value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.LTE, variableName, value);
    }

    public static final CompareQuery gt(String variableName, boolean value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.GT, variableName, value);
    }

    public static final CompareQuery gt(String variableName, long value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.GT, variableName, value);
    }

    public static final CompareQuery gt(String variableName, double value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.GT, variableName, value);
    }

    public static final CompareQuery gt(String variableName, String value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.GT, variableName, value);
    }

    public static final CompareQuery gt(String variableName, Date value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.GT, variableName, value);
    }

    public static final CompareQuery gte(String variableName, boolean value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.GTE, variableName, value);
    }

    public static final CompareQuery gte(String variableName, long value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.GTE, variableName, value);
    }

    public static final CompareQuery gte(String variableName, double value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.GTE, variableName, value);
    }

    public static final CompareQuery gte(String variableName, String value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.GTE, variableName, value);
    }

    public static final CompareQuery gte(String variableName, Date value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.GTE, variableName, value);
    }

    public static final CompareQuery size(String variableName, long value) throws InvalidCreateOperationException {
        return new CompareQuery(BuilderToken.QUERY.SIZE, variableName, value);
    }

    public static final ExistsQuery exists(String variableName) throws InvalidCreateOperationException {
        return new ExistsQuery(BuilderToken.QUERY.EXISTS, variableName);
    }

    @Deprecated
    public static final ExistsQuery missing(String variableName) throws InvalidCreateOperationException {
        return new ExistsQuery(BuilderToken.QUERY.MISSING, variableName);
    }

    public static final ExistsQuery isNull(String variableName) throws InvalidCreateOperationException {
        return new ExistsQuery(BuilderToken.QUERY.ISNULL, variableName);
    }

    public static final InQuery in(String variableName, boolean ... value) throws InvalidCreateOperationException {
        return new InQuery(BuilderToken.QUERY.IN, variableName, value);
    }

    public static final InQuery in(String variableName, long ... value) throws InvalidCreateOperationException {
        return new InQuery(BuilderToken.QUERY.IN, variableName, value);
    }

    public static final InQuery in(String variableName, double ... value) throws InvalidCreateOperationException {
        return new InQuery(BuilderToken.QUERY.IN, variableName, value);
    }

    public static final InQuery in(String variableName, String ... value) throws InvalidCreateOperationException {
        return new InQuery(BuilderToken.QUERY.IN, variableName, value);
    }

    public static final InQuery in(String variableName, Date ... value) throws InvalidCreateOperationException {
        return new InQuery(BuilderToken.QUERY.IN, variableName, value);
    }

    public static final InQuery nin(String variableName, boolean ... value) throws InvalidCreateOperationException {
        return new InQuery(BuilderToken.QUERY.NIN, variableName, value);
    }

    public static final InQuery nin(String variableName, long ... value) throws InvalidCreateOperationException {
        return new InQuery(BuilderToken.QUERY.NIN, variableName, value);
    }

    public static final InQuery nin(String variableName, double ... value) throws InvalidCreateOperationException {
        return new InQuery(BuilderToken.QUERY.NIN, variableName, value);
    }

    public static final InQuery nin(String variableName, String ... value) throws InvalidCreateOperationException {
        return new InQuery(BuilderToken.QUERY.NIN, variableName, value);
    }

    public static final InQuery nin(String variableName, Date ... value) throws InvalidCreateOperationException {
        return new InQuery(BuilderToken.QUERY.NIN, variableName, value);
    }

    public static final MatchQuery match(String variableName, String value) throws InvalidCreateOperationException {
        return new MatchQuery(BuilderToken.QUERY.MATCH, variableName, value);
    }

    public static final MatchQuery matchAll(String variableName, String value) throws InvalidCreateOperationException {
        return new MatchQuery(BuilderToken.QUERY.MATCH_ALL, variableName, value);
    }

    public static final MatchQuery matchPhrase(String variableName, String value) throws InvalidCreateOperationException {
        return new MatchQuery(BuilderToken.QUERY.MATCH_PHRASE, variableName, value);
    }

    public static final MatchQuery matchPhrasePrefix(String variableName, String value) throws InvalidCreateOperationException {
        return new MatchQuery(BuilderToken.QUERY.MATCH_PHRASE_PREFIX, variableName, value);
    }

    public static final SearchQuery regex(String variableName, String value) throws InvalidCreateOperationException {
        return new SearchQuery(BuilderToken.QUERY.REGEX, variableName, value);
    }

    public static final SearchQuery search(String variableName, String value) throws InvalidCreateOperationException {
        return new SearchQuery(BuilderToken.QUERY.SEARCH, variableName, value);
    }

    public static final NestedQuery nestedSearch(String variableName, JsonNode value) throws InvalidCreateOperationException {
        return new NestedQuery(BuilderToken.QUERY.SUBOBJECT, variableName, value);
    }

    public static final TermQuery term(String variableName, String value) throws InvalidCreateOperationException {
        return new TermQuery(variableName, value);
    }

    public static final TermQuery term(String variableName, long value) throws InvalidCreateOperationException {
        return new TermQuery(variableName, value);
    }

    public static final TermQuery term(String variableName, double value) throws InvalidCreateOperationException {
        return new TermQuery(variableName, value);
    }

    public static final TermQuery term(String variableName, boolean value) throws InvalidCreateOperationException {
        return new TermQuery(variableName, value);
    }

    public static final TermQuery term(String variableName, Date value) throws InvalidCreateOperationException {
        return new TermQuery(variableName, value);
    }

    public static final TermQuery term(Map<String, Object> variableNameValue) throws InvalidCreateOperationException {
        return new TermQuery(variableNameValue);
    }

    public static final WildcardQuery wildcard(String variableName, String value) throws InvalidCreateOperationException {
        return new WildcardQuery(variableName, value);
    }

    public static final MltQuery flt(String value, String ... variableName) throws InvalidCreateOperationException {
        return new MltQuery(BuilderToken.QUERY.FLT, value, variableName);
    }

    public static final MltQuery mlt(String value, String ... variableName) throws InvalidCreateOperationException {
        return new MltQuery(BuilderToken.QUERY.MLT, value, variableName);
    }

    public static final RangeQuery range(String variableName, long min, boolean includeMin, long max, boolean includeMax) throws InvalidCreateOperationException {
        BuilderToken.QUERY rmin = includeMin ? BuilderToken.QUERY.GTE : BuilderToken.QUERY.GT;
        BuilderToken.QUERY rmax = includeMax ? BuilderToken.QUERY.LTE : BuilderToken.QUERY.LT;
        return new RangeQuery(variableName, rmin, min, rmax, max);
    }

    public static final RangeQuery range(String variableName, double min, boolean includeMin, double max, boolean includeMax) throws InvalidCreateOperationException {
        BuilderToken.QUERY rmin = includeMin ? BuilderToken.QUERY.GTE : BuilderToken.QUERY.GT;
        BuilderToken.QUERY rmax = includeMax ? BuilderToken.QUERY.LTE : BuilderToken.QUERY.LT;
        return new RangeQuery(variableName, rmin, min, rmax, max);
    }

    public static final RangeQuery range(String variableName, String min, boolean includeMin, String max, boolean includeMax) throws InvalidCreateOperationException {
        BuilderToken.QUERY rmin = includeMin ? BuilderToken.QUERY.GTE : BuilderToken.QUERY.GT;
        BuilderToken.QUERY rmax = includeMax ? BuilderToken.QUERY.LTE : BuilderToken.QUERY.LT;
        return new RangeQuery(variableName, rmin, min, rmax, max);
    }

    public static final RangeQuery range(String variableName, Date min, boolean includeMin, Date max, boolean includeMax) throws InvalidCreateOperationException {
        BuilderToken.QUERY rmin = includeMin ? BuilderToken.QUERY.GTE : BuilderToken.QUERY.GT;
        BuilderToken.QUERY rmax = includeMax ? BuilderToken.QUERY.LTE : BuilderToken.QUERY.LT;
        return new RangeQuery(variableName, rmin, min, rmax, max);
    }
}

