/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.builder.facet;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.facet.Facet;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import java.util.Map;

public class FiltersFacet
extends Facet {
    public FiltersFacet(String name, Map<String, Query> filters) throws InvalidCreateOperationException {
        super(name);
        this.setName(name);
        this.currentTokenFACET = BuilderToken.FACET.FILTERS;
        if (name == null || name.isEmpty()) {
            throw new InvalidCreateOperationException("name value is requested");
        }
        if (filters == null || filters.size() <= 0) {
            throw new InvalidCreateOperationException("filters must be > 0 ");
        }
        ObjectNode facetNode = JsonHandler.createObjectNode();
        ArrayNode filtersNode = JsonHandler.createArrayNode();
        filters.forEach((key, query) -> {
            ObjectNode filterNode = JsonHandler.createObjectNode();
            filterNode.put(BuilderToken.FACETARGS.NAME.exactToken(), key);
            filterNode.set(BuilderToken.FACETARGS.QUERY.exactToken(), (JsonNode)query.getCurrentQuery());
            filtersNode.add((JsonNode)filterNode);
        });
        facetNode.set(BuilderToken.FACETARGS.QUERY_FILTERS.exactToken(), (JsonNode)filtersNode);
        this.currentFacet = facetNode;
    }
}

