/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.builder.facet;

import fr.gouv.vitam.common.database.builder.facet.DateRangeFacet;
import fr.gouv.vitam.common.database.builder.facet.Facet;
import fr.gouv.vitam.common.database.builder.facet.FiltersFacet;
import fr.gouv.vitam.common.database.builder.facet.RangeFacetValue;
import fr.gouv.vitam.common.database.builder.facet.TermsFacet;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.facet.model.FacetOrder;
import java.util.List;
import java.util.Map;

public class FacetHelper {
    protected FacetHelper() {
    }

    public static final Facet terms(String name, String field, String nestdPath, Integer size, FacetOrder order) throws InvalidCreateOperationException {
        return new TermsFacet(name, field, nestdPath, size, order);
    }

    public static final Facet terms(String name, String field, Integer size, FacetOrder order) throws InvalidCreateOperationException {
        return new TermsFacet(name, field, size, order);
    }

    public static final Facet dateRange(String name, String field, String nestedPath, String dateFormat, List<RangeFacetValue> ranges) throws InvalidCreateOperationException {
        return new DateRangeFacet(name, field, nestedPath, dateFormat, ranges);
    }

    public static final Facet dateRange(String name, String field, String dateFormat, List<RangeFacetValue> ranges) throws InvalidCreateOperationException {
        return new DateRangeFacet(name, field, dateFormat, ranges);
    }

    public static final Facet filters(String name, Map<String, Query> filters) throws InvalidCreateOperationException {
        return new FiltersFacet(name, filters);
    }
}

