/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.scheduler.server.job.auditobject;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.StatusCode;
import java.util.Arrays;
import java.util.Objects;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum AuditProcessState {
    RUNNING(ProcessState.RUNNING){

        @Override
        public boolean hasLastWorkflowCompleted() {
            return false;
        }

        @Override
        public boolean hasCurrentWorkflowFinishedSuccessfully(StatusCode statusCode, Integer tenantId) {
            LOGGER.error("Integrity audit on tenant {} job is ongoing", (Object)tenantId);
            return false;
        }

        @Override
        public boolean isWaitingForResponse(StatusCode statusCode) {
            return true;
        }
    }
    ,
    PAUSE(ProcessState.PAUSE){

        @Override
        public boolean hasLastWorkflowCompleted() {
            return false;
        }

        @Override
        public boolean hasCurrentWorkflowFinishedSuccessfully(StatusCode statusCode, Integer tenantId) {
            LOGGER.error("Integrity audit on tenant {} job is paused", (Object)tenantId);
            return false;
        }

        @Override
        public boolean isWaitingForResponse(StatusCode statusCode) {
            return Objects.equals(statusCode, StatusCode.UNKNOWN);
        }
    }
    ,
    COMPLETED(ProcessState.COMPLETED){

        @Override
        public boolean hasLastWorkflowCompleted() {
            return true;
        }

        @Override
        public boolean hasCurrentWorkflowFinishedSuccessfully(StatusCode statusCode, Integer tenantId) {
            if (Objects.equals(statusCode, StatusCode.KO)) {
                LOGGER.error("Integrity audit on tenant {} finished with status KO", (Object)tenantId);
                return false;
            }
            LOGGER.info("Integrity audit successfully finished on tenant {}", (Object)tenantId);
            return true;
        }

        @Override
        public boolean isWaitingForResponse(StatusCode statusCode) {
            return false;
        }
    };

    private static final VitamLogger LOGGER;
    private final ProcessState state;

    private AuditProcessState(ProcessState state) {
        this.state = state;
    }

    public static AuditProcessState wrap(ProcessState state) {
        return Arrays.stream(AuditProcessState.values()).filter(auditProcessState -> Objects.equals(state, auditProcessState.state)).findAny().orElseThrow(IllegalStateException::new);
    }

    public abstract boolean hasCurrentWorkflowFinishedSuccessfully(StatusCode var1, Integer var2);

    public abstract boolean hasLastWorkflowCompleted();

    public abstract boolean isWaitingForResponse(StatusCode var1);

    static {
        LOGGER = VitamLoggerFactory.getInstance(AuditProcessState.class);
    }
}

