/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.scheduler.server.job.auditobject;

import com.google.common.base.Stopwatch;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.InternalServerException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.exception.WorkflowNotFoundException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClient;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientFactory;
import fr.gouv.vitam.scheduler.server.job.auditobject.AuditProcessState;
import java.util.concurrent.TimeUnit;

public class AuditPoller {
    public static final boolean UNSUCCESSFUL_TERMINATION = Boolean.FALSE;
    public static final boolean SUCCESSFUL_TERMINATION = Boolean.TRUE;
    public static final int AUDIT_EXECUTION_TIMEOUT = 30;
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AuditPoller.class);
    private static final int SLEEPING_TIME_MULTIPLIER = 2;
    private static final int POLL_LIMIT = 60000;
    private final ProcessingManagementClientFactory processingManagementClientFactory;
    private final Integer tenantId;
    private final String operationId;

    public AuditPoller(ProcessingManagementClientFactory processingManagementClientFactory, Integer tenantId, String operationId) {
        this.processingManagementClientFactory = processingManagementClientFactory;
        this.tenantId = tenantId;
        this.operationId = operationId;
    }

    public boolean waitForTermination() {
        boolean bl;
        block10: {
            ProcessingManagementClient processingManagementClient = this.processingManagementClientFactory.getClient();
            try {
                AuditProcessState auditProcessState;
                StatusCode globalStatus;
                Stopwatch stopwatch = Stopwatch.createStarted();
                int timeSleep = 1000;
                while (true) {
                    ItemStatus operationProcessStatus = processingManagementClient.getOperationProcessStatus(this.operationId);
                    ProcessState globalState = operationProcessStatus.getGlobalState();
                    globalStatus = operationProcessStatus.getGlobalStatus();
                    auditProcessState = AuditProcessState.wrap(globalState);
                    if (this.hasCompletedOrTimeout(auditProcessState, globalStatus, stopwatch)) break;
                    TimeUnit.MILLISECONDS.sleep(timeSleep);
                    timeSleep = Math.min(timeSleep * 2, 60000);
                }
                bl = auditProcessState.hasCurrentWorkflowFinishedSuccessfully(globalStatus, this.tenantId);
                if (processingManagementClient == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (processingManagementClient != null) {
                        try {
                            processingManagementClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BadRequestException | InternalServerException | VitamClientException | InterruptedException e) {
                    LOGGER.error("An error has occurred while waiting for audit termination", e);
                    return UNSUCCESSFUL_TERMINATION;
                }
                catch (WorkflowNotFoundException e) {
                    LOGGER.error("Could not find workflow: job has finished a long time ago", (Throwable)e);
                    return SUCCESSFUL_TERMINATION;
                }
            }
            processingManagementClient.close();
        }
        return bl;
    }

    private boolean hasCompletedOrTimeout(AuditProcessState auditProcessState, StatusCode globalStatus, Stopwatch stopwatch) {
        return !auditProcessState.isWaitingForResponse(globalStatus) || stopwatch.elapsed(TimeUnit.MINUTES) >= 30L;
    }
}

