/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.scheduler.server.job;

import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.common.ReconstructionRequestItem;
import fr.gouv.vitam.functional.administration.common.exception.AdminManagementClientServerException;
import java.util.ArrayList;
import java.util.List;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class ReconstructionAccessionRegisterJob
implements Job {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ReconstructionAccessionRegisterJob.class);
    private final AdminManagementClientFactory adminManagementClientFactory;

    public ReconstructionAccessionRegisterJob() {
        this(AdminManagementClientFactory.getInstance());
    }

    ReconstructionAccessionRegisterJob(AdminManagementClientFactory adminManagementClientFactory) {
        this.adminManagementClientFactory = adminManagementClientFactory;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        Integer adminTenant = VitamConfiguration.getAdminTenant();
        VitamThreadUtils.getVitamSession().setTenantId(adminTenant);
        VitamThreadUtils.getVitamSession().setRequestId(GUIDFactory.newOperationLogbookGUID((int)adminTenant));
        try (AdminManagementClient client = this.adminManagementClientFactory.getClient();){
            List<ReconstructionRequestItem> reconstructionItems = this.getReconstructionItems();
            LOGGER.info("Reconstruction accession register in progress...");
            client.reconstructAccessionRegister(reconstructionItems);
            LOGGER.info("Reconstruction accession register is finished");
        }
        catch (AdminManagementClientServerException e) {
            throw new JobExecutionException(" Error when reconstruction Admin  :  " + adminTenant, (Throwable)e);
        }
    }

    private List<ReconstructionRequestItem> getReconstructionItems() {
        ArrayList<ReconstructionRequestItem> reconstructionRequestItems = new ArrayList<ReconstructionRequestItem>();
        VitamConfiguration.getTenants().forEach(tenant -> {
            reconstructionRequestItems.add(new ReconstructionRequestItem("AccessionRegisterDetail", tenant));
            reconstructionRequestItems.add(new ReconstructionRequestItem("AccessionRegisterSymbolic", tenant));
        });
        return reconstructionRequestItems;
    }
}

