/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.scheduler.server;

import com.fasterxml.jackson.jaxrs.base.JsonParseExceptionMapper;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.server.application.resources.ApplicationStatusResource;
import fr.gouv.vitam.common.serverv2.ConfigurationApplication;
import fr.gouv.vitam.common.serverv2.application.CommonBusinessApplication;
import fr.gouv.vitam.scheduler.server.SchedulerConfiguration;
import fr.gouv.vitam.scheduler.server.SchedulerResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.ws.rs.core.Context;

public class BusinessApplication
extends ConfigurationApplication {
    private final Set<Object> singletons;

    public BusinessApplication(@Context ServletConfig servletConfig) {
        String configurationFile = servletConfig.getInitParameter("vitam.configurationFile");
        this.singletons = new HashSet<Object>();
        try (InputStream yamlIS = PropertiesUtils.getConfigAsStream((String)configurationFile);){
            SchedulerConfiguration configuration = (SchedulerConfiguration)((Object)PropertiesUtils.readYaml((InputStream)yamlIS, SchedulerConfiguration.class));
            CommonBusinessApplication commonBusinessApplication = new CommonBusinessApplication();
            this.singletons.addAll(commonBusinessApplication.getResources());
            this.singletons.add((Object)new SchedulerResource());
            this.singletons.add(new JsonParseExceptionMapper());
            this.singletons.add(new ApplicationStatusResource());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

