/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.scheduler.server;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.scheduler.server.SchedulerListener;
import fr.gouv.vitam.scheduler.server.util.VitamJobsDataProcessorPlugin;
import java.util.Set;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.matchers.GroupMatcher;

@Path(value="/scheduler/v1")
public class AdminSchedulerResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AdminSchedulerResource.class);
    private final VitamJobsDataProcessorPlugin jobsDataProcessorPlugin;

    public AdminSchedulerResource(VitamJobsDataProcessorPlugin jobsDataProcessorPlugin) {
        this.jobsDataProcessorPlugin = jobsDataProcessorPlugin;
    }

    @POST
    @Path(value="/jobs")
    @Produces(value={"application/json"})
    public Response importJobs() throws SchedulerException {
        LOGGER.warn("##### STARTING JOB CONFIGURATION #####");
        Scheduler scheduler = SchedulerListener.getInstance().getScheduler();
        Set jobKeys = scheduler.getJobKeys(GroupMatcher.anyGroup());
        if (!jobKeys.isEmpty()) {
            LOGGER.warn("PAUSING existing jobs...");
            scheduler.pauseAll();
        }
        for (JobKey jobKey : jobKeys) {
            LOGGER.warn("DELETING existing job " + String.valueOf(jobKey));
            scheduler.deleteJob(jobKey);
        }
        LOGGER.warn("RELOADING job configuration...");
        this.jobsDataProcessorPlugin.initialize();
        LOGGER.warn("##### JOB CONFIGURATION DONE SUCCESSFULLY #####");
        return Response.accepted().build();
    }

    @PUT
    @Path(value="/pause/{group}")
    @Produces(value={"application/json"})
    public Response pauseScheduling(@PathParam(value="group") String group) throws SchedulerException {
        Scheduler scheduler = SchedulerListener.getInstance().getScheduler();
        if (group.equals("ALL")) {
            Set jobKeys = scheduler.getJobKeys(GroupMatcher.anyGroup());
            if (!jobKeys.isEmpty()) {
                scheduler.pauseAll();
            }
        } else {
            Set jobKeys = scheduler.getJobKeys(GroupMatcher.groupEquals((String)group));
            if (!jobKeys.isEmpty()) {
                scheduler.pauseJobs(GroupMatcher.groupEquals((String)group));
                scheduler.pauseTriggers(GroupMatcher.groupEquals((String)group));
            }
        }
        return Response.accepted().build();
    }

    @PUT
    @Path(value="/resume/{group}")
    @Produces(value={"application/json"})
    public Response resumeScheduling(@PathParam(value="group") String group) throws SchedulerException {
        Scheduler scheduler = SchedulerListener.getInstance().getScheduler();
        if (group.equals("ALL")) {
            scheduler.resumeAll();
        } else {
            scheduler.resumeJobs(GroupMatcher.groupEquals((String)group));
            scheduler.resumeTriggers(GroupMatcher.groupEquals((String)group));
        }
        return Response.accepted().build();
    }
}

