/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.worker.tasks;

import com.mongodb.client.model.Filters;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.server.query.QueryCriteria;
import fr.gouv.vitam.common.database.server.query.QueryCriteriaOperator;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.security.IllegalPathException;
import fr.gouv.vitam.common.thread.VitamThreadPoolExecutor;
import fr.gouv.vitam.storage.engine.common.model.QueueState;
import fr.gouv.vitam.storage.engine.common.model.ReadOrder;
import fr.gouv.vitam.storage.engine.common.model.TapeCatalog;
import fr.gouv.vitam.storage.engine.common.model.TapeLocationType;
import fr.gouv.vitam.storage.engine.common.model.TapeState;
import fr.gouv.vitam.storage.offers.tape.cas.AccessRequestManager;
import fr.gouv.vitam.storage.offers.tape.cas.ArchiveCacheStorage;
import fr.gouv.vitam.storage.offers.tape.exception.AccessRequestReferentialException;
import fr.gouv.vitam.storage.offers.tape.exception.QueueException;
import fr.gouv.vitam.storage.offers.tape.exception.ReadWriteErrorCode;
import fr.gouv.vitam.storage.offers.tape.exception.ReadWriteException;
import fr.gouv.vitam.storage.offers.tape.exception.TapeCatalogException;
import fr.gouv.vitam.storage.offers.tape.metrics.ReadWriteOrderMetrics;
import fr.gouv.vitam.storage.offers.tape.spec.TapeCatalogService;
import fr.gouv.vitam.storage.offers.tape.spec.TapeLibraryService;
import fr.gouv.vitam.storage.offers.tape.worker.tasks.CatalogResponse;
import fr.gouv.vitam.storage.offers.tape.worker.tasks.ReadWriteResult;
import io.prometheus.client.Histogram;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bson.conversions.Bson;

public class ReadTask
implements Future<ReadWriteResult> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ReadTask.class);
    public static final String TAPE_MSG = " [Tape] : ";
    public static final String TEMP_EXT = ".TMP";
    private final TapeLibraryService tapeLibraryService;
    private final TapeCatalogService tapeCatalogService;
    private final AccessRequestManager accessRequestManager;
    private final ReadOrder readOrder;
    private final String MSG_PREFIX;
    private final ArchiveCacheStorage archiveCacheStorage;
    private TapeCatalog workerCurrentTape;
    protected AtomicBoolean done = new AtomicBoolean(false);

    public ReadTask(ReadOrder readOrder, TapeCatalog workerCurrentTape, TapeLibraryService tapeLibraryService, TapeCatalogService tapeCatalogService, AccessRequestManager accessRequestManager, ArchiveCacheStorage archiveCacheStorage) {
        ParametersChecker.checkParameter((String)"WriteOrder param is required.", (Object[])new Object[]{readOrder});
        ParametersChecker.checkParameter((String)"TapeLibraryService param is required.", (Object[])new Object[]{tapeLibraryService});
        ParametersChecker.checkParameter((String)"TapeCatalogService param is required.", (Object[])new Object[]{tapeCatalogService});
        ParametersChecker.checkParameter((String)"AccessRequestManager param is required.", (Object[])new Object[]{accessRequestManager});
        ParametersChecker.checkParameter((String)"archiveCacheStorage param is required.", (Object[])new Object[]{archiveCacheStorage});
        this.readOrder = readOrder;
        this.workerCurrentTape = workerCurrentTape;
        this.tapeLibraryService = tapeLibraryService;
        this.tapeCatalogService = tapeCatalogService;
        this.accessRequestManager = accessRequestManager;
        this.archiveCacheStorage = archiveCacheStorage;
        this.MSG_PREFIX = String.format("[Library] : %s, [Drive] : %s, ", tapeLibraryService.getLibraryIdentifier(), tapeLibraryService.getDriveIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadWriteResult get() {
        this.reportWaitTime();
        Histogram.Timer executionTimer = ((Histogram.Child)ReadWriteOrderMetrics.READ_ORDER_EXECUTION_DURATION.labels(new String[]{this.readOrder.getBucket()})).startTimer();
        try {
            if (null != this.workerCurrentTape && !this.workerCurrentTape.getCode().equals(this.readOrder.getTapeCode())) {
                this.unloadTape();
            }
            if (this.workerCurrentTape == null) {
                CatalogResponse catalogResponse = this.getTapeFromCatalog();
                if (!catalogResponse.isOK()) {
                    ReadWriteResult readWriteResult = new ReadWriteResult(catalogResponse.getStatus(), catalogResponse.getStatus() == StatusCode.FATAL ? QueueState.ERROR : QueueState.READY, this.workerCurrentTape);
                    return readWriteResult;
                }
                this.workerCurrentTape = catalogResponse.getCurrentTape();
                this.loadTape();
                this.tapeLibraryService.checkNonEmptyTapeLabel(this.workerCurrentTape);
            }
            this.readFromTape();
        }
        catch (QueueException | TapeCatalogException e) {
            LOGGER.error("Read task failed", (Throwable)e);
            ReadWriteResult readWriteResult = new ReadWriteResult(StatusCode.KO, QueueState.READY, this.workerCurrentTape);
            return readWriteResult;
        }
        catch (ReadWriteException e) {
            LOGGER.error("Read task failed", (Throwable)e);
            switch (e.getReadWriteErrorCode()) {
                case TAPE_LOCATION_CONFLICT_ON_UNLOAD: 
                case NO_EMPTY_SLOT_FOUND: 
                case KO_REWIND_BEFORE_UNLOAD_TAPE: 
                case KO_ON_UNLOAD_THEN_STATUS: 
                case KO_ON_UNLOAD_TAPE: {
                    ReadWriteResult readWriteResult = new ReadWriteResult(StatusCode.FATAL, QueueState.READY, this.workerCurrentTape);
                    return readWriteResult;
                }
                case KO_TAPE_IS_BUSY: {
                    ReadWriteResult readWriteResult = new ReadWriteResult(StatusCode.KO, QueueState.READY, this.workerCurrentTape);
                    return readWriteResult;
                }
                case KO_ON_LOAD_THEN_STATUS: 
                case KO_ON_LOAD_TAPE: {
                    this.workerCurrentTape = null;
                }
            }
            ReadWriteResult readWriteResult = new ReadWriteResult(StatusCode.FATAL, QueueState.ERROR, this.workerCurrentTape);
            return readWriteResult;
        }
        finally {
            this.done.set(true);
            executionTimer.observeDuration();
        }
        return new ReadWriteResult(StatusCode.OK, QueueState.COMPLETED, this.workerCurrentTape);
    }

    @Override
    public ReadWriteResult get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return CompletableFuture.supplyAsync(() -> this.get(), (Executor)VitamThreadPoolExecutor.getDefaultExecutor()).get(timeout, unit);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.done.get();
    }

    private void readFromTape() throws ReadWriteException {
        try {
            if (!this.archiveCacheStorage.containsArchive(this.readOrder.getFileBucketId(), this.readOrder.getFileName())) {
                this.copyFileFromTapeToCache();
            }
            this.updateAccessRequestStatus();
        }
        catch (IllegalPathException | IOException | IllegalStateException e) {
            LOGGER.error(this.MSG_PREFIX + TAPE_MSG + this.workerCurrentTape.getCode() + " Action : Read, Order: " + JsonHandler.unprettyPrint((Object)this.readOrder) + ", Entity: " + String.valueOf(e));
            throw new ReadWriteException(this.MSG_PREFIX + TAPE_MSG + this.workerCurrentTape.getCode() + " Action : Read, Order: " + JsonHandler.unprettyPrint((Object)this.readOrder) + " : Error when writing TAR on file system ", e, ReadWriteErrorCode.KO_ON_WRITE_TO_FS);
        }
    }

    private void copyFileFromTapeToCache() throws IOException, IllegalPathException, ReadWriteException {
        Path tmpArchiveFile = Paths.get(this.tapeLibraryService.getTmpOutputDirectory(), new String[0]).resolve(this.readOrder.getFileName() + TEMP_EXT).toAbsolutePath();
        Files.deleteIfExists(tmpArchiveFile);
        this.archiveCacheStorage.reserveArchiveStorageSpace(this.readOrder.getFileBucketId(), this.readOrder.getFileName(), this.readOrder.getSize());
        try {
            this.tapeLibraryService.read(this.workerCurrentTape, this.readOrder.getFilePosition(), this.readOrder.getFileName() + TEMP_EXT);
            this.archiveCacheStorage.moveArchiveToCache(tmpArchiveFile, this.readOrder.getFileBucketId(), this.readOrder.getFileName());
        }
        catch (Exception e) {
            Files.deleteIfExists(tmpArchiveFile);
            this.archiveCacheStorage.cancelReservedArchive(this.readOrder.getFileBucketId(), this.readOrder.getFileName());
            throw e;
        }
    }

    private CatalogResponse getTapeFromCatalog() throws ReadWriteException, QueueException, TapeCatalogException {
        Bson query = Filters.and((Bson[])new Bson[]{Filters.eq((String)"library", (Object)this.tapeLibraryService.getLibraryIdentifier()), Filters.eq((String)"code", (Object)this.readOrder.getTapeCode()), Filters.ne((String)"tape_state", (Object)TapeState.CONFLICT.name())});
        Optional<TapeCatalog> found = this.tapeCatalogService.receive(query);
        if (found.isEmpty()) {
            List<TapeCatalog> tapes = this.tapeCatalogService.find(List.of(new QueryCriteria("library", (Object)this.tapeLibraryService.getLibraryIdentifier(), QueryCriteriaOperator.EQ), new QueryCriteria("code", (Object)this.readOrder.getTapeCode(), QueryCriteriaOperator.EQ)));
            if (tapes.size() == 0) {
                LOGGER.error(this.MSG_PREFIX + " [Tape] :  Action : LoadTapeFromCatalog, Order: " + JsonHandler.unprettyPrint((Object)this.readOrder) + ", Error: no tape found in the catalog with expected library and/or bucket", (Object)ReadWriteErrorCode.TAPE_NOT_FOUND_IN_CATALOG);
                throw new ReadWriteException(this.MSG_PREFIX + " [Tape] :  Action : Read, Order: " + JsonHandler.unprettyPrint((Object)this.readOrder) + " : Unknown tape in catalog ", ReadWriteErrorCode.TAPE_NOT_FOUND_IN_CATALOG);
            }
            if (tapes.get(0).getTapeState().equals((Object)TapeState.CONFLICT)) {
                LOGGER.error(this.MSG_PREFIX + " [Tape] :  Action : LoadTapeFromCatalog, Order: " + JsonHandler.unprettyPrint((Object)this.readOrder) + ", Warn: tape is in conflict state", (Object)ReadWriteErrorCode.KO_TAPE_CONFLICT_STATE);
                throw new ReadWriteException(this.MSG_PREFIX + " [Tape] :  Action : Read, Order: " + JsonHandler.unprettyPrint((Object)this.readOrder) + " : tape is in conflict state ", ReadWriteErrorCode.KO_TAPE_CONFLICT_STATE);
            }
            LOGGER.error(this.MSG_PREFIX + " [Tape] :  Action : LoadTapeFromCatalog, Order: " + JsonHandler.unprettyPrint((Object)this.readOrder) + ", Warn: tape is busy", (Object)ReadWriteErrorCode.KO_TAPE_IS_BUSY);
            throw new ReadWriteException(this.MSG_PREFIX + " [Tape] :  Action : Read, Order: " + JsonHandler.unprettyPrint((Object)this.readOrder) + " : tape is busy ", ReadWriteErrorCode.KO_TAPE_IS_BUSY);
        }
        if (found.get().getCurrentLocation().getLocationType().equals((Object)TapeLocationType.OUTSIDE)) {
            LOGGER.error(this.MSG_PREFIX + TAPE_MSG + found.get().getCode() + " Action : LoadTapeFromCatalog, Order: " + JsonHandler.unprettyPrint((Object)this.readOrder) + ", Error: tape is outside", (Object)ReadWriteErrorCode.KO_TAPE_IS_OUTSIDE);
            throw new ReadWriteException(this.MSG_PREFIX + TAPE_MSG + found.get().getCode() + " Action : Read, Order: " + JsonHandler.unprettyPrint((Object)this.readOrder) + " : tape is busy ", ReadWriteErrorCode.KO_TAPE_IS_OUTSIDE);
        }
        return new CatalogResponse(StatusCode.OK, found.get());
    }

    private void loadTape() throws ReadWriteException, TapeCatalogException {
        this.tapeLibraryService.loadTape(this.workerCurrentTape);
        this.updateCurrentTapeLocation();
    }

    private void unloadTape() throws TapeCatalogException, ReadWriteException, QueueException {
        this.tapeLibraryService.unloadTape(this.workerCurrentTape);
        this.updateCurrentTapeLocation();
        this.tapeCatalogService.markReady(this.workerCurrentTape.getId());
        this.workerCurrentTape = null;
    }

    private void updateCurrentTapeLocation() throws TapeCatalogException {
        HashMap<String, Object> updates = new HashMap<String, Object>();
        updates.put("previous_location", this.workerCurrentTape.getPreviousLocation());
        updates.put("current_location", this.workerCurrentTape.getCurrentLocation());
        this.tapeCatalogService.update(this.workerCurrentTape.getId(), updates);
    }

    private void updateAccessRequestStatus() {
        try {
            this.accessRequestManager.updateAccessRequestWhenArchiveReady(this.readOrder.getFileName());
        }
        catch (AccessRequestReferentialException e) {
            LOGGER.warn(this.MSG_PREFIX + TAPE_MSG + this.workerCurrentTape.getCode() + " Failed to update access requests in DB for archiveId" + this.readOrder.getFileName(), (Throwable)e);
        }
    }

    private void reportWaitTime() {
        long waitTimeInSeconds = Duration.between(LocalDateUtil.now(), LocalDateUtil.parseMongoFormattedDate((String)this.readOrder.getCreated())).get(ChronoUnit.SECONDS);
        ((Histogram.Child)ReadWriteOrderMetrics.READ_ORDER_WAIT_TIME_BEFORE_EXECUTION.labels(new String[]{this.readOrder.getBucket()})).observe((double)waitTimeInSeconds);
    }
}

