/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.process;

import fr.gouv.vitam.common.logging.SysErrLogger;
import fr.gouv.vitam.common.stream.StreamUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class Output {
    static final int EXIT_CODE_WAIT_FOR_TIMEOUT = -1;
    private final List<String> command;
    private final Exception exception;
    private final String stdout;
    private final String stderr;
    private final int exitCode;

    public Output(Exception exception, Process process, ProcessBuilder processBuilder, File stdout, File stderr) {
        this.exception = exception;
        this.command = processBuilder.command();
        this.exitCode = -1;
        if (null != process) {
            this.stdout = Output.stdToString(process, stdout, false);
            this.stderr = Output.stdToString(process, stderr, true);
        } else {
            this.stdout = "";
            this.stderr = "";
        }
    }

    public Output(Process process, int exitCode, ProcessBuilder processBuilder, File stdout, File stderr) {
        this.command = processBuilder.command();
        this.exception = null;
        this.exitCode = exitCode;
        this.stdout = Output.stdToString(process, stdout, false);
        this.stderr = Output.stdToString(process, stderr, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String stdToString(Process process, File stdFile, boolean isErrorStream) {
        String string;
        String msgToReturn = "";
        InputStream std = null;
        try {
            std = stdFile != null ? Files.newInputStream(stdFile.toPath(), new OpenOption[0]) : (isErrorStream ? process.getErrorStream() : process.getInputStream());
            string = IOUtils.toString((InputStream)std, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            String string2;
            try {
                SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e);
                string2 = msgToReturn + "|" + e.getMessage();
            }
            catch (Throwable throwable) {
                StreamUtils.closeSilently(std);
                throw throwable;
            }
            StreamUtils.closeSilently((InputStream)std);
            return string2;
        }
        StreamUtils.closeSilently((InputStream)std);
        return string;
    }

    public Exception getException() {
        return this.exception;
    }

    public String getStdout() {
        return this.stdout;
    }

    public String getStderr() {
        return this.stderr;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public List<String> getCommand() {
        return this.command;
    }
}

