/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.pool;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.storage.offers.tape.spec.TapeDriveService;
import fr.gouv.vitam.storage.offers.tape.spec.TapeLibraryPool;
import fr.gouv.vitam.storage.offers.tape.spec.TapeRobotService;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class TapeLibraryPoolImpl
implements TapeLibraryPool {
    private final String libraryIdentifier;
    private final BlockingQueue<TapeRobotService> tapeRobotServicePool;
    private final ConcurrentHashMap<Integer, TapeDriveService> tapeDriveServicePool;

    public TapeLibraryPoolImpl(String libraryIdentifier, BlockingQueue<TapeRobotService> tapeRobotServicePool, ConcurrentHashMap<Integer, TapeDriveService> tapeDriveServicePool) {
        this.libraryIdentifier = libraryIdentifier;
        this.tapeRobotServicePool = tapeRobotServicePool;
        this.tapeDriveServicePool = tapeDriveServicePool;
    }

    @Override
    public TapeRobotService checkoutRobotService() throws InterruptedException {
        return this.tapeRobotServicePool.take();
    }

    @Override
    public TapeRobotService checkoutRobotService(long timeout, TimeUnit unit) throws InterruptedException {
        return this.tapeRobotServicePool.poll(timeout, unit);
    }

    @Override
    public TapeDriveService checkoutDriveService(Integer driveIndex) {
        ParametersChecker.checkParameter((String)"driveIndex is required", (Object[])new Object[]{driveIndex});
        return this.tapeDriveServicePool.remove(driveIndex);
    }

    @Override
    public void pushRobotService(TapeRobotService tapeRobotService) throws InterruptedException {
        ParametersChecker.checkParameter((String)"TapeRobotService is required", (Object[])new Object[]{tapeRobotService});
        this.tapeRobotServicePool.put(tapeRobotService);
    }

    @Override
    public void pushDriveService(TapeDriveService tapeDriveService) {
        ParametersChecker.checkParameter((String)"TapeDriveService is required", (Object[])new Object[]{tapeDriveService});
        this.tapeDriveServicePool.put(tapeDriveService.getTapeDriveConf().getIndex(), tapeDriveService);
    }

    @Override
    public Set<Map.Entry<Integer, TapeDriveService>> drives() {
        return this.tapeDriveServicePool.entrySet();
    }

    @Override
    public String getLibraryIdentifier() {
        return this.libraryIdentifier;
    }
}

