/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.inmemoryqueue;

import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.VitamThreadPoolExecutor;
import fr.gouv.vitam.storage.offers.tape.inmemoryqueue.QueueProcessingException;
import java.util.concurrent.LinkedBlockingDeque;

public abstract class QueueProcessor<T> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(QueueProcessor.class);
    private static final int RETRY_DELAY_IN_MILLISECONDS = 60000;
    private final String workerName;
    private final LinkedBlockingDeque<T> queue = new LinkedBlockingDeque();

    protected QueueProcessor(String workerName) {
        this.workerName = workerName;
    }

    public void startListener() {
        VitamThreadPoolExecutor.getDefaultExecutor().execute(this::workerTask);
    }

    public void addToQueue(T message) {
        this.queue.add(message);
    }

    public void addFirst(T message) {
        this.queue.addFirst(message);
    }

    private void workerTask() {
        String initialThreadName = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName(this.workerName);
            this.processMessages();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error("Interrupted thread. Shutdown...", (Throwable)e);
        }
        finally {
            Thread.currentThread().setName(initialThreadName);
        }
    }

    private void processMessages() throws InterruptedException {
        T message = this.queue.take();
        while (true) {
            try {
                while (true) {
                    this.processMessage(message);
                    message = this.queue.take();
                }
            }
            catch (RuntimeException ex) {
                throw new IllegalStateException("Unexpected exception occurred during message processing " + JsonHandler.unprettyPrint(message) + ". Shutting down...", ex);
            }
            catch (QueueProcessingException ex) {
                switch (ex.getRetryPolicy()) {
                    case FATAL_SHUTDOWN: {
                        throw new IllegalStateException("Fatal exception occurred during message processing " + JsonHandler.unprettyPrint(message) + ". Shutting down...", ex);
                    }
                    case DROP_MESSAGE: {
                        LOGGER.error("Non recoverable exception occurred during message processing " + JsonHandler.unprettyPrint(message), (Throwable)ex);
                        message = this.queue.take();
                        break;
                    }
                    case RETRY: {
                        LOGGER.error("Exception occurred during message processing " + JsonHandler.unprettyPrint(message) + ". Will retry right away", (Throwable)ex);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected retry policy " + String.valueOf((Object)ex.getRetryPolicy()), ex);
                    }
                }
                Thread.sleep(60000L);
                continue;
            }
            break;
        }
    }

    protected abstract void processMessage(T var1) throws QueueProcessingException, InterruptedException;
}

