/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.impl.robot;

import com.google.common.collect.Lists;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.storage.tapelibrary.TapeRobotConf;
import fr.gouv.vitam.storage.offers.tape.dto.TapeLibrarySpec;
import fr.gouv.vitam.storage.offers.tape.exception.TapeCommandException;
import fr.gouv.vitam.storage.offers.tape.parser.TapeLibraryStatusParser;
import fr.gouv.vitam.storage.offers.tape.process.Output;
import fr.gouv.vitam.storage.offers.tape.process.ProcessExecutor;
import fr.gouv.vitam.storage.offers.tape.spec.TapeLoadUnloadService;
import java.util.ArrayList;

public class MtxTapeLibraryService
implements TapeLoadUnloadService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MtxTapeLibraryService.class);
    public static final String F = "-f";
    public static final String UNLOAD = "unload";
    public static final String LOAD = "load";
    public static final String STATUS = "status";
    private final TapeRobotConf tapeRobotConf;
    private final ProcessExecutor processExecutor;

    public MtxTapeLibraryService(TapeRobotConf tapeRobotConf, ProcessExecutor processExecutor) {
        ParametersChecker.checkParameter((String)"All params are required", (Object[])new Object[]{tapeRobotConf, processExecutor});
        this.tapeRobotConf = tapeRobotConf;
        this.processExecutor = processExecutor;
    }

    @Override
    public TapeLibrarySpec status() throws TapeCommandException {
        ArrayList args = Lists.newArrayList((Object[])new String[]{F, this.tapeRobotConf.getDevice(), STATUS});
        LOGGER.debug("Execute script : {},timeout: {}, args : {}", new Object[]{this.tapeRobotConf.getMtxPath(), this.tapeRobotConf.getTimeoutInMilliseconds(), args});
        Output output = this.processExecutor.execute(this.tapeRobotConf.getMtxPath(), true, this.tapeRobotConf.getTimeoutInMilliseconds(), args);
        return this.parseTapeLibraryState(output);
    }

    @Override
    public void loadTape(int slotNumber, int driveIndex) throws TapeCommandException {
        Output output = this.executeCommand(slotNumber, driveIndex, LOAD);
        if (output.getExitCode() != 0) {
            throw new TapeCommandException("Could not load tape from slot " + slotNumber + " into drive " + driveIndex, output);
        }
    }

    @Override
    public void unloadTape(int slotNumber, int driveIndex) throws TapeCommandException {
        Output output = this.executeCommand(slotNumber, driveIndex, UNLOAD);
        if (output.getExitCode() != 0) {
            throw new TapeCommandException("Could not unload tape from drive " + driveIndex + " into slot " + slotNumber, output);
        }
    }

    private TapeLibrarySpec parseTapeLibraryState(Output output) throws TapeCommandException {
        if (output.getExitCode() != 0) {
            throw new TapeCommandException("Could not retrieve tape library status", output);
        }
        TapeLibraryStatusParser tapeLibraryStatusParser = new TapeLibraryStatusParser();
        return tapeLibraryStatusParser.parse(output.getStdout());
    }

    private Output executeCommand(int tapeIndex, int driveIndex, String command) {
        ArrayList args = Lists.newArrayList((Object[])new String[]{F, this.tapeRobotConf.getDevice(), command, Integer.toString(tapeIndex), Integer.toString(driveIndex)});
        LOGGER.debug("Execute script : {},timeout: {}, args : {}", new Object[]{this.tapeRobotConf.getMtxPath(), this.tapeRobotConf.getTimeoutInMilliseconds(), args});
        return this.processExecutor.execute(this.tapeRobotConf.getMtxPath(), this.tapeRobotConf.getTimeoutInMilliseconds(), args);
    }
}

