/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.impl.readwrite;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.storage.tapelibrary.TapeDriveConf;
import fr.gouv.vitam.storage.offers.tape.exception.TapeCommandException;
import fr.gouv.vitam.storage.offers.tape.process.Output;
import fr.gouv.vitam.storage.offers.tape.process.ProcessExecutor;
import fr.gouv.vitam.storage.offers.tape.spec.TapeReadWriteService;
import java.nio.file.Paths;
import java.util.ArrayList;

public class DdTapeLibraryService
implements TapeReadWriteService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(DdTapeLibraryService.class);
    private static final String IF = "if=";
    private static final String OF = "of=";
    private final TapeDriveConf tapeDriveConf;
    private final ProcessExecutor processExecutor;
    private final String inputDirectory;
    private final String tmpOutputStorageFolder;

    public DdTapeLibraryService(TapeDriveConf tapeDriveConf, String inputDirectory, String tmpOutputStorageFolder) {
        this(tapeDriveConf, ProcessExecutor.getInstance(), inputDirectory, tmpOutputStorageFolder);
    }

    @VisibleForTesting
    DdTapeLibraryService(TapeDriveConf tapeDriveConf, ProcessExecutor processExecutor, String inputDirectory, String tmpOutputStorageFolder) {
        ParametersChecker.checkParameter((String)"All params are required", (Object[])new Object[]{tapeDriveConf, processExecutor, inputDirectory, tmpOutputStorageFolder});
        this.tapeDriveConf = tapeDriveConf;
        this.processExecutor = processExecutor;
        this.inputDirectory = inputDirectory;
        this.tmpOutputStorageFolder = tmpOutputStorageFolder;
    }

    @Override
    public void writeToTape(String inputPath) throws TapeCommandException {
        ParametersChecker.checkParameter((String)"Arguments inputPath is required", (String[])new String[]{inputPath});
        ArrayList args = Lists.newArrayList((Object[])new String[]{IF + String.valueOf(Paths.get(this.inputDirectory, new String[0]).resolve(inputPath).toAbsolutePath()), OF + this.tapeDriveConf.getDevice()});
        LOGGER.debug("Execute script : {},timeout: {}, args : {}", new Object[]{this.tapeDriveConf.getDdPath(), this.tapeDriveConf.getTimeoutInMilliseconds(), args});
        Output output = this.processExecutor.execute(this.tapeDriveConf.getDdPath(), this.tapeDriveConf.getTimeoutInMilliseconds(), args);
        if (output.getExitCode() != 0) {
            throw new TapeCommandException("Could not write file content " + inputPath + " to drive " + this.tapeDriveConf.getDevice(), output);
        }
    }

    @Override
    public void readFromTape(String outputPath) throws TapeCommandException {
        ParametersChecker.checkParameter((String)"Arguments outputPath is required", (String[])new String[]{outputPath});
        ArrayList args = Lists.newArrayList((Object[])new String[]{IF + this.tapeDriveConf.getDevice(), OF + String.valueOf(Paths.get(this.tmpOutputStorageFolder, new String[0]).resolve(outputPath).toAbsolutePath())});
        LOGGER.debug("Execute script : {},timeout: {}, args : {}", new Object[]{this.tapeDriveConf.getDdPath(), this.tapeDriveConf.getTimeoutInMilliseconds(), args});
        Output output = this.processExecutor.execute(this.tapeDriveConf.getDdPath(), this.tapeDriveConf.getTimeoutInMilliseconds(), args);
        if (output.getExitCode() != 0) {
            throw new TapeCommandException("Could not read form drive " + this.tapeDriveConf.getDevice() + " to file " + outputPath, output);
        }
    }

    @Override
    public String getTmpOutputStorageFolder() {
        return this.tmpOutputStorageFolder;
    }
}

