/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.impl.queue;

import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.DeleteResult;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.server.mongodb.BsonHelper;
import fr.gouv.vitam.common.database.server.query.QueryCriteria;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.storage.engine.common.model.QueueMessageEntity;
import fr.gouv.vitam.storage.engine.common.model.QueueMessageType;
import fr.gouv.vitam.storage.engine.common.model.QueueState;
import fr.gouv.vitam.storage.offers.tape.exception.QueueException;
import fr.gouv.vitam.storage.offers.tape.spec.QueueRepository;
import fr.gouv.vitam.storage.offers.tape.utils.QueryCriteriaUtils;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.bson.Document;
import org.bson.conversions.Bson;

public class QueueRepositoryImpl
implements QueueRepository {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(QueueRepositoryImpl.class);
    protected final MongoCollection<Document> collection;

    public QueueRepositoryImpl(MongoCollection<Document> collection) {
        ParametersChecker.checkParameter((String)"Collection param is required", (Object[])new Object[]{collection});
        this.collection = collection;
    }

    @Override
    public void add(QueueMessageEntity queue) throws QueueException {
        try {
            Document doc = Document.parse((String)JsonHandler.unprettyPrint((Object)queue));
            this.collection.insertOne((Object)doc);
        }
        catch (Exception e) {
            throw new QueueException(e);
        }
    }

    @Override
    public void addIfAbsent(List<QueryCriteria> criteria, QueueMessageEntity queueMessageEntity) throws QueueException {
        try {
            List<Bson> filters = QueryCriteriaUtils.criteriaToMongoFilters(criteria);
            if (this.collection.find(Filters.and(filters)).iterator().hasNext()) {
                LOGGER.warn("Message already in queue " + JsonHandler.unprettyPrint((Object)queueMessageEntity));
            } else {
                Document doc = Document.parse((String)JsonHandler.unprettyPrint((Object)queueMessageEntity));
                this.collection.insertOne((Object)doc);
            }
        }
        catch (Exception e) {
            throw new QueueException(e);
        }
    }

    @Override
    public void tryCancelIfNotStarted(List<QueryCriteria> criteria) throws QueueException {
        try {
            List<Bson> filters = QueryCriteriaUtils.criteriaToMongoFilters(criteria);
            filters.add(Filters.ne((String)"queue_state", (Object)QueueState.RUNNING.getState()));
            DeleteResult deleteResult = this.collection.deleteOne(Filters.and(filters));
            if (deleteResult.getDeletedCount() != 1L) {
                LOGGER.warn("Message could not be cancelled. Already running?");
            }
        }
        catch (Exception e) {
            throw new QueueException(e);
        }
    }

    @Override
    public long remove(String queueId) throws QueueException {
        try {
            return this.collection.deleteOne(Filters.eq((String)"_id", (Object)queueId)).getDeletedCount();
        }
        catch (Exception e) {
            throw new QueueException(e);
        }
    }

    @Override
    public long complete(String queueId) throws QueueException {
        try {
            return this.collection.updateOne(Filters.eq((String)"_id", (Object)queueId), Updates.set((String)"queue_state", (Object)QueueState.COMPLETED.getState())).getModifiedCount();
        }
        catch (Exception e) {
            throw new QueueException(e);
        }
    }

    @Override
    public long markError(String queueMessageId) throws QueueException {
        try {
            return this.collection.updateOne(Filters.eq((String)"_id", (Object)queueMessageId), Updates.set((String)"queue_state", (Object)QueueState.ERROR.getState())).getModifiedCount();
        }
        catch (Exception e) {
            throw new QueueException(e);
        }
    }

    @Override
    public long markReady(String queueMessageId) throws QueueException {
        try {
            return this.collection.updateOne(Filters.eq((String)"_id", (Object)queueMessageId), Updates.set((String)"queue_state", (Object)QueueState.READY.getState())).getModifiedCount();
        }
        catch (Exception e) {
            throw new QueueException(e);
        }
    }

    @Override
    public long initializeOnBootstrap() {
        try {
            return this.collection.updateMany(Filters.eq((String)"queue_state", (Object)QueueState.RUNNING.getState()), Updates.set((String)"queue_state", (Object)QueueState.READY.getState())).getModifiedCount();
        }
        catch (Exception e) {
            throw new VitamRuntimeException((Throwable)e);
        }
    }

    @Override
    public <T> Optional<T> receive(QueueMessageType messageType) throws QueueException {
        return this.receive(messageType, true);
    }

    @Override
    public <T> Optional<T> receive(QueueMessageType messageType, boolean usePriority) throws QueueException {
        return this.receive(null, messageType, usePriority);
    }

    @Override
    public <T> Optional<T> receive(Bson inQuery, QueueMessageType messageType) throws QueueException {
        return this.receive(inQuery, messageType, true);
    }

    @Override
    public <T> Optional<T> receive(Bson inQuery, QueueMessageType messageType, boolean usePriority) throws QueueException {
        Bson query = inQuery != null ? Filters.and((Bson[])new Bson[]{Filters.eq((String)"queue_state", (Object)QueueState.READY.getState()), Filters.eq((String)"queue_message_type", (Object)messageType.name()), inQuery}) : Filters.and((Bson[])new Bson[]{Filters.eq((String)"queue_state", (Object)QueueState.READY.getState()), Filters.eq((String)"queue_message_type", (Object)messageType.name())});
        FindOneAndUpdateOptions option = new FindOneAndUpdateOptions();
        option.returnDocument(ReturnDocument.AFTER);
        if (usePriority) {
            option.sort(Sorts.ascending((String[])new String[]{"queue_priority", "queue_creation_date"}));
        } else {
            option.sort(Sorts.ascending((String[])new String[]{"queue_creation_date"}));
        }
        option.upsert(false);
        Bson update = Updates.combine((Bson[])new Bson[]{Updates.set((String)"queue_state", (Object)QueueState.RUNNING.getState()), Updates.set((String)"queue_last-update", (Object)Calendar.getInstance().getTimeInMillis())});
        Document sequence = (Document)this.collection.findOneAndUpdate(query, update, option);
        if (null == sequence) {
            return Optional.empty();
        }
        try {
            return Optional.of(BsonHelper.fromDocumentToObject((Document)sequence, (Class)messageType.getClazz()));
        }
        catch (InvalidParseOperationException e) {
            throw new QueueException(e);
        }
    }

    public Map<Pair<QueueState, QueueMessageType>, Integer> countByStateAndType() throws QueueException {
        try {
            AggregateIterable aggregate = this.collection.aggregate(List.of(Aggregates.group((Object)new Document().append("state", (Object)"$queue_state").append("type", (Object)"$queue_message_type"), (BsonField[])new BsonField[]{Accumulators.sum((String)"count", (Object)1)})));
            HashMap<Pair<QueueState, QueueMessageType>, Integer> results = new HashMap<Pair<QueueState, QueueMessageType>, Integer>();
            try (MongoCursor iterator = aggregate.iterator();){
                while (iterator.hasNext()) {
                    Document doc = (Document)iterator.next();
                    Document _id = (Document)doc.get((Object)"_id");
                    String stateStr = _id.getString((Object)"state");
                    QueueState queueState = QueueState.valueOf((String)stateStr);
                    String typeStr = _id.getString((Object)"type");
                    QueueMessageType type = QueueMessageType.valueOf((String)typeStr);
                    int count = doc.getInteger((Object)"count");
                    results.put((Pair<QueueState, QueueMessageType>)new ImmutablePair((Object)queueState, (Object)type), count);
                }
            }
            return results;
        }
        catch (Exception e) {
            throw new QueueException(e);
        }
    }
}

