/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.impl.catalog;

import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.client.result.UpdateResult;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.server.mongodb.BsonHelper;
import fr.gouv.vitam.common.database.server.query.QueryCriteria;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.storage.engine.common.model.TapeCatalog;
import fr.gouv.vitam.storage.engine.common.model.TapeState;
import fr.gouv.vitam.storage.offers.tape.exception.TapeCatalogException;
import fr.gouv.vitam.storage.offers.tape.impl.queue.QueueRepositoryImpl;
import fr.gouv.vitam.storage.offers.tape.utils.QueryCriteriaUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;

public class TapeCatalogRepository
extends QueueRepositoryImpl {
    private static final String ALL_PARAMS_REQUIRED = "All params are required";
    String $_SET = "$set";
    String $_INC = "$inc";

    public TapeCatalogRepository(MongoCollection<Document> collection) {
        super(collection);
    }

    public String createTape(TapeCatalog tapeCatalog) throws TapeCatalogException {
        try {
            ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (Object[])new Object[]{tapeCatalog});
            tapeCatalog.setVersion(0);
            String json = JsonHandler.unprettyPrint((Object)tapeCatalog);
            this.collection.insertOne((Object)Document.parse((String)json));
            return tapeCatalog.getId();
        }
        catch (Exception e) {
            throw new TapeCatalogException(e);
        }
    }

    public boolean replaceTape(TapeCatalog tapeCatalog) throws TapeCatalogException {
        try {
            ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (Object[])new Object[]{tapeCatalog});
            tapeCatalog.setVersion(tapeCatalog.getVersion() + 1);
            String json = JsonHandler.unprettyPrint((Object)tapeCatalog);
            UpdateResult result = this.collection.replaceOne(Filters.eq((String)"_id", (Object)tapeCatalog.getId()), (Object)Document.parse((String)json));
            return result.getMatchedCount() == 1L;
        }
        catch (Exception e) {
            throw new TapeCatalogException(e);
        }
    }

    public boolean updateTape(String tapeId, Map<String, Object> fields) throws TapeCatalogException {
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (Object[])new Object[]{tapeId, fields});
        if (fields.isEmpty()) {
            throw new TapeCatalogException(ALL_PARAMS_REQUIRED);
        }
        try {
            Document update = new Document();
            fields.forEach((key, value) -> update.append(key, value));
            Document data = new Document(this.$_SET, (Object)this.toBson(update)).append(this.$_INC, (Object)new Document("_v", (Object)1));
            UpdateResult result = this.collection.updateOne(Filters.eq((String)"_id", (Object)tapeId), (Bson)data);
            return result.getMatchedCount() == 1L;
        }
        catch (Exception e) {
            throw new TapeCatalogException(e);
        }
    }

    public List<TapeCatalog> findTapes(List<QueryCriteria> criteria) throws TapeCatalogException {
        if (criteria == null || criteria.isEmpty()) {
            throw new TapeCatalogException(ALL_PARAMS_REQUIRED);
        }
        List<Bson> filters = QueryCriteriaUtils.criteriaToMongoFilters(criteria);
        ArrayList<TapeCatalog> result = new ArrayList<TapeCatalog>();
        List documents = (List)this.collection.find(Filters.and(filters)).into(new ArrayList());
        for (Document doc : documents) {
            try {
                result.add((TapeCatalog)BsonHelper.fromDocumentToObject((Document)doc, TapeCatalog.class));
            }
            catch (InvalidParseOperationException e) {
                throw new TapeCatalogException(e);
            }
        }
        return result;
    }

    public Map<TapeState, Integer> countByState() throws TapeCatalogException {
        try {
            AggregateIterable aggregate = this.collection.aggregate(List.of(Aggregates.group((Object)"$tape_state", (BsonField[])new BsonField[]{Accumulators.sum((String)"count", (Object)1)})));
            HashMap<TapeState, Integer> results = new HashMap<TapeState, Integer>();
            try (MongoCursor iterator = aggregate.iterator();){
                while (iterator.hasNext()) {
                    Document doc = (Document)iterator.next();
                    String stateStr = doc.getString((Object)"_id");
                    TapeState tapeState = TapeState.valueOf((String)stateStr);
                    int count = doc.getInteger((Object)"count");
                    results.put(tapeState, count);
                }
            }
            return results;
        }
        catch (Exception e) {
            throw new TapeCatalogException(e);
        }
    }

    public TapeCatalog findTapeById(String tapeId) throws TapeCatalogException {
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (String[])new String[]{tapeId});
        FindIterable models = this.collection.find(Filters.eq((String)"_id", (Object)tapeId));
        Document first = (Document)models.first();
        if (first == null) {
            return null;
        }
        try {
            return (TapeCatalog)BsonHelper.fromDocumentToObject((Document)first, TapeCatalog.class);
        }
        catch (InvalidParseOperationException e) {
            throw new TapeCatalogException(e);
        }
    }

    private Document toBson(Object object) {
        return Document.parse((String)JsonHandler.unprettyPrint((Object)object));
    }
}

