/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.impl;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.storage.tapelibrary.TapeDriveConf;
import fr.gouv.vitam.storage.offers.tape.impl.drive.MtTapeLibraryService;
import fr.gouv.vitam.storage.offers.tape.impl.readwrite.DdTapeLibraryService;
import fr.gouv.vitam.storage.offers.tape.spec.TapeDriveCommandService;
import fr.gouv.vitam.storage.offers.tape.spec.TapeDriveService;
import fr.gouv.vitam.storage.offers.tape.spec.TapeReadWriteService;

public class TapeDriveManager
implements TapeDriveService {
    private final TapeDriveConf tapeDriveConf;
    private final TapeReadWriteService ddReadWriteService;
    private final TapeDriveCommandService tapeDriveCommandService;

    public TapeDriveManager(TapeDriveConf tapeDriveConf, String inputDirectory, String tmpTarOutputStorageFolder) {
        ParametersChecker.checkParameter((String)"TapeDriveConf param is required", (Object[])new Object[]{tapeDriveConf});
        ParametersChecker.checkParameter((String)"inputDirectory param is required", (String[])new String[]{inputDirectory});
        ParametersChecker.checkParameter((String)"tmpTarOutputStorageFolder param is required", (String[])new String[]{tmpTarOutputStorageFolder});
        this.tapeDriveConf = tapeDriveConf;
        this.ddReadWriteService = new DdTapeLibraryService(tapeDriveConf, inputDirectory, tmpTarOutputStorageFolder);
        this.tapeDriveCommandService = new MtTapeLibraryService(tapeDriveConf);
    }

    @VisibleForTesting
    public TapeDriveManager(TapeDriveConf tapeDriveConf, TapeReadWriteService ddReadWriteService, TapeDriveCommandService tapeDriveCommandService) {
        ParametersChecker.checkParameter((String)"All params are required", (Object[])new Object[]{tapeDriveConf, ddReadWriteService, tapeDriveCommandService});
        this.tapeDriveConf = tapeDriveConf;
        this.ddReadWriteService = ddReadWriteService;
        this.tapeDriveCommandService = tapeDriveCommandService;
    }

    @Override
    public TapeReadWriteService getReadWriteService() {
        return this.ddReadWriteService;
    }

    @Override
    public TapeDriveCommandService getDriveCommandService() {
        return this.tapeDriveCommandService;
    }

    @Override
    public TapeDriveConf getTapeDriveConf() {
        return this.tapeDriveConf;
    }
}

