/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.cas;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.storage.engine.common.model.TapeLibraryInputFileObjectStorageLocation;
import fr.gouv.vitam.storage.engine.common.model.TapeLibraryTarObjectStorageLocation;
import fr.gouv.vitam.storage.engine.common.model.TapeObjectReferentialEntity;
import fr.gouv.vitam.storage.engine.common.model.TarEntryDescription;
import fr.gouv.vitam.storage.offers.tape.cas.ObjectReferentialRepository;
import fr.gouv.vitam.storage.offers.tape.exception.ObjectReferentialException;
import fr.gouv.vitam.storage.offers.tape.utils.LocalFileUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class TarFileDigestVerifier {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(TarFileDigestVerifier.class);
    private final ObjectReferentialRepository objectReferentialRepository;
    private final int bulkSize;
    private MultiValuedMap<String, EntryToCheck> entriesToCheckByContainerName = new ArrayListValuedHashMap();

    public TarFileDigestVerifier(ObjectReferentialRepository objectReferentialRepository, int bulkSize) {
        this.objectReferentialRepository = objectReferentialRepository;
        this.bulkSize = bulkSize;
    }

    public void addDigestToCheck(String tarEntryName, String digestValue) throws ObjectReferentialException {
        String containerName = LocalFileUtils.getContainerNameFromTarEntryName(tarEntryName);
        String storageId = LocalFileUtils.getStorageIdFromTarEntryName(tarEntryName);
        int entryIndex = LocalFileUtils.getEntryIndexFromTarEntryName(tarEntryName);
        String objectName = LocalFileUtils.storageIdToObjectName(storageId);
        EntryToCheck entryToCheck = new EntryToCheck(tarEntryName, containerName, objectName, storageId, entryIndex, digestValue);
        Collection entriesToCheck = this.entriesToCheckByContainerName.get((Object)containerName);
        entriesToCheck.add(entryToCheck);
        if (entriesToCheck.size() >= this.bulkSize) {
            this.processBulk(containerName, entriesToCheck);
            entriesToCheck.clear();
        }
    }

    public void finalizeChecks() throws ObjectReferentialException {
        for (String containerName : this.entriesToCheckByContainerName.keySet()) {
            Collection entriesToCheck = this.entriesToCheckByContainerName.get((Object)containerName);
            if (entriesToCheck.isEmpty()) continue;
            this.processBulk(containerName, entriesToCheck);
        }
    }

    private void processBulk(String containerName, Collection<EntryToCheck> entriesToCheck) throws ObjectReferentialException {
        Set<String> objectNames = entriesToCheck.stream().map(entryToCheck -> entryToCheck.objectName).collect(Collectors.toSet());
        List<TapeObjectReferentialEntity> objectReferentialEntities = this.objectReferentialRepository.bulkFind(containerName, objectNames);
        Map<String, TapeObjectReferentialEntity> objectReferentialEntityByObjectNameMap = objectReferentialEntities.stream().collect(Collectors.toMap(entity -> entity.getId().getObjectName(), entity -> entity));
        for (EntryToCheck entryToCheck2 : entriesToCheck) {
            TapeObjectReferentialEntity objectReferentialEntity = objectReferentialEntityByObjectNameMap.get(entryToCheck2.objectName);
            if (objectReferentialEntity == null || !entryToCheck2.storageId.equals(objectReferentialEntity.getStorageId())) {
                LOGGER.debug("Ignoring deleted or updated object entry " + entryToCheck2.tarEntryName);
                continue;
            }
            if (objectReferentialEntity.getLocation() instanceof TapeLibraryTarObjectStorageLocation) {
                TapeLibraryTarObjectStorageLocation inTarLocation = (TapeLibraryTarObjectStorageLocation)objectReferentialEntity.getLocation();
                if (inTarLocation.getTarEntries().size() <= entryToCheck2.entryIndex) {
                    throw new IllegalStateException("Invalid entry index for entry" + entryToCheck2.tarEntryName);
                }
                String expectedEntryDigest = ((TarEntryDescription)inTarLocation.getTarEntries().get(entryToCheck2.entryIndex)).getDigestValue();
                if (entryToCheck2.digestValue.equals(expectedEntryDigest)) {
                    LOGGER.debug("Object with entry name {} digest checked successfully {}", (Object)entryToCheck2.tarEntryName, (Object)expectedEntryDigest);
                    continue;
                }
                throw new IllegalStateException(String.format("Object with entry name %s/%s digest mismatch. Found=%s, expected=%s", entryToCheck2.containerName, entryToCheck2.storageId, entryToCheck2.digestValue, expectedEntryDigest));
            }
            if (objectReferentialEntity.getLocation() instanceof TapeLibraryInputFileObjectStorageLocation) {
                LOGGER.debug("Ignoring non indexed object entry " + entryToCheck2.tarEntryName);
                continue;
            }
            throw new IllegalStateException("Invalid location type " + String.valueOf(objectReferentialEntity.getLocation()));
        }
    }

    private static class EntryToCheck {
        private final String tarEntryName;
        private final String containerName;
        private final String objectName;
        private final String storageId;
        private final int entryIndex;
        private final String digestValue;

        private EntryToCheck(String tarEntryName, String containerName, String objectName, String storageId, int entryIndex, String digestValue) {
            this.tarEntryName = tarEntryName;
            this.containerName = containerName;
            this.objectName = objectName;
            this.storageId = storageId;
            this.entryIndex = entryIndex;
            this.digestValue = digestValue;
        }
    }
}

