/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.cas;

import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.stream.ExtendedFileOutputStream;
import fr.gouv.vitam.storage.engine.common.model.TarEntryDescription;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.IOUtils;

public class TarAppender
implements AutoCloseable {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(TarAppender.class);
    private final String tarId;
    private final long maxTarSize;
    private final OutputStream outputStream;
    private final TarArchiveOutputStream tarArchiveOutputStream;
    private final Digest digest;
    private int entryCount;
    private long bytesWritten = 0L;

    public TarAppender(Path outputTarFilePath, String tarId, long maxTarSize) throws IOException {
        this((OutputStream)new ExtendedFileOutputStream(outputTarFilePath, true), tarId, maxTarSize);
    }

    public TarAppender(OutputStream outputStream, String tarId, long maxTarSize) {
        this.outputStream = outputStream;
        this.tarId = tarId;
        this.maxTarSize = maxTarSize;
        this.digest = new Digest(VitamConfiguration.getDefaultDigestType());
        OutputStream digestOutputStream = this.digest.getDigestOutputStream(outputStream);
        this.tarArchiveOutputStream = new TarArchiveOutputStream(digestOutputStream);
        this.tarArchiveOutputStream.setLongFileMode(2);
    }

    public boolean canAppend(long size) {
        long contentWithPaddingSize;
        if (size > 0x1FFFFFFFFL) {
            throw new IllegalStateException("Invalid entry size. MAX=8589934591");
        }
        long currentPos = this.tarArchiveOutputStream.getBytesWritten();
        return currentPos + 512L + (contentWithPaddingSize = size + 512L - 1L + 512L) + 1024L < this.maxTarSize;
    }

    public TarEntryDescription append(String entryName, InputStream inputStream, long size) throws IOException {
        if (!this.canAppend(size)) {
            throw new IllegalStateException("Could not append to tar file");
        }
        try {
            long startPos = this.tarArchiveOutputStream.getBytesWritten();
            TarArchiveEntry tarEntry = new TarArchiveEntry(entryName);
            tarEntry.setSize(size);
            this.tarArchiveOutputStream.putArchiveEntry(tarEntry);
            Digest digest = new Digest(VitamConfiguration.getDefaultDigestType());
            InputStream digestInputStream = digest.getDigestInputStream(inputStream);
            IOUtils.copy((InputStream)digestInputStream, (OutputStream)this.tarArchiveOutputStream);
            this.tarArchiveOutputStream.closeArchiveEntry();
            long endPos = this.tarArchiveOutputStream.getBytesWritten();
            String entryDigestValue = digest.digestHex();
            LOGGER.info("Written {} [{} bytes] into tar file {} [{}-{}] with digest {}", new Object[]{entryName, size, this.tarId, startPos, endPos, entryDigestValue});
            ++this.entryCount;
            this.bytesWritten = this.tarArchiveOutputStream.getBytesWritten();
            return new TarEntryDescription(this.tarId, entryName, startPos, size, entryDigestValue);
        }
        catch (IOException ex) {
            IOUtils.closeQuietly((OutputStream)this.outputStream);
            throw ex;
        }
    }

    public void flush() throws IOException {
        this.tarArchiveOutputStream.flush();
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            this.tarArchiveOutputStream.flush();
            this.outputStream.flush();
            this.tarArchiveOutputStream.close();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)this.outputStream);
        }
        this.bytesWritten = this.tarArchiveOutputStream.getBytesWritten();
    }

    public String getTarId() {
        return this.tarId;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public String getDigestValue() {
        return this.digest.digestHex();
    }
}

