/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.cas;

import com.google.common.util.concurrent.Uninterruptibles;
import com.mongodb.MongoException;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.MetadatasObject;
import fr.gouv.vitam.common.model.storage.AccessRequestStatus;
import fr.gouv.vitam.common.model.storage.ObjectEntry;
import fr.gouv.vitam.common.security.IllegalPathException;
import fr.gouv.vitam.common.storage.ContainerInformation;
import fr.gouv.vitam.common.storage.cas.container.api.ContentAddressableStorage;
import fr.gouv.vitam.common.storage.cas.container.api.MetadatasStorageObject;
import fr.gouv.vitam.common.storage.cas.container.api.ObjectContent;
import fr.gouv.vitam.common.storage.cas.container.api.ObjectListingListener;
import fr.gouv.vitam.common.storage.constants.ErrorMessage;
import fr.gouv.vitam.common.stream.ExactDigestValidatorInputStream;
import fr.gouv.vitam.common.stream.ExactSizeInputStream;
import fr.gouv.vitam.common.stream.LazySequenceInputStream;
import fr.gouv.vitam.storage.engine.common.model.TapeArchiveReferentialEntity;
import fr.gouv.vitam.storage.engine.common.model.TapeLibraryInputFileObjectStorageLocation;
import fr.gouv.vitam.storage.engine.common.model.TapeLibraryObjectReferentialId;
import fr.gouv.vitam.storage.engine.common.model.TapeLibraryObjectStorageLocation;
import fr.gouv.vitam.storage.engine.common.model.TapeLibraryTarObjectStorageLocation;
import fr.gouv.vitam.storage.engine.common.model.TapeObjectReferentialEntity;
import fr.gouv.vitam.storage.engine.common.model.TarEntryDescription;
import fr.gouv.vitam.storage.engine.common.utils.ContainerUtils;
import fr.gouv.vitam.storage.offers.tape.cas.AccessRequestManager;
import fr.gouv.vitam.storage.offers.tape.cas.ArchiveCacheEntry;
import fr.gouv.vitam.storage.offers.tape.cas.ArchiveCacheEvictionController;
import fr.gouv.vitam.storage.offers.tape.cas.ArchiveCacheStorage;
import fr.gouv.vitam.storage.offers.tape.cas.ArchiveReferentialRepository;
import fr.gouv.vitam.storage.offers.tape.cas.BasicFileStorage;
import fr.gouv.vitam.storage.offers.tape.cas.BucketTopologyHelper;
import fr.gouv.vitam.storage.offers.tape.cas.FileBucketTarCreatorManager;
import fr.gouv.vitam.storage.offers.tape.cas.InputFileToProcessMessage;
import fr.gouv.vitam.storage.offers.tape.cas.LockHandle;
import fr.gouv.vitam.storage.offers.tape.cas.ObjectReferentialRepository;
import fr.gouv.vitam.storage.offers.tape.cas.TarHelper;
import fr.gouv.vitam.storage.offers.tape.exception.ArchiveReferentialException;
import fr.gouv.vitam.storage.offers.tape.exception.ObjectReferentialException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageUnavailableDataFromAsyncOfferException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.SetUtils;

public class TapeLibraryContentAddressableStorage
implements ContentAddressableStorage {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(TapeLibraryContentAddressableStorage.class);
    private static final int NB_GET_OBJECT_RETRIES_ON_CONCURRENT_UPDATE = 5;
    private static final int RETRY_GET_OBJECT_SLEEP_MIN_DELAY = 10;
    private static final int RETRY_GET_OBJECT_SLEEP_MAX_DELAY = 3000;
    private final BasicFileStorage basicFileStorage;
    private final ObjectReferentialRepository objectReferentialRepository;
    private final FileBucketTarCreatorManager fileBucketTarCreatorManager;
    private final ArchiveReferentialRepository archiveReferentialRepository;
    private final AccessRequestManager accessRequestManager;
    private final ArchiveCacheStorage archiveCacheStorage;
    private final ArchiveCacheEvictionController archiveCacheEvictionController;
    private final BucketTopologyHelper bucketTopologyHelper;

    public TapeLibraryContentAddressableStorage(BasicFileStorage basicFileStorage, ObjectReferentialRepository objectReferentialRepository, ArchiveReferentialRepository archiveReferentialRepository, AccessRequestManager accessRequestManager, FileBucketTarCreatorManager fileBucketTarCreatorManager, ArchiveCacheStorage archiveCacheStorage, ArchiveCacheEvictionController archiveCacheEvictionController, BucketTopologyHelper bucketTopologyHelper) {
        this.basicFileStorage = basicFileStorage;
        this.objectReferentialRepository = objectReferentialRepository;
        this.archiveReferentialRepository = archiveReferentialRepository;
        this.accessRequestManager = accessRequestManager;
        this.fileBucketTarCreatorManager = fileBucketTarCreatorManager;
        this.archiveCacheStorage = archiveCacheStorage;
        this.archiveCacheEvictionController = archiveCacheEvictionController;
        this.bucketTopologyHelper = bucketTopologyHelper;
    }

    public void createContainer(String containerName) {
    }

    public boolean isExistingContainer(String containerName) {
        return true;
    }

    public void writeObject(String containerName, String objectName, InputStream inputStream, DigestType digestType, long size) throws ContentAddressableStorageException {
        String storageId;
        LOGGER.debug(String.format("Upload object %s in container %s", objectName, containerName));
        Digest digest = new Digest(digestType);
        InputStream digestInputStream = digest.getDigestInputStream(inputStream);
        try {
            storageId = this.basicFileStorage.writeFile(containerName, objectName, digestInputStream, size);
        }
        catch (IOException e) {
            throw new ContentAddressableStorageException("Could not persist file to disk " + containerName + "/" + objectName, (Throwable)e);
        }
        String digestValue = digest.digestHex();
        try {
            String now = LocalDateUtil.nowFormatted();
            this.objectReferentialRepository.insertOrUpdate(new TapeObjectReferentialEntity(new TapeLibraryObjectReferentialId(containerName, objectName), size, digestType.getName(), digestValue, storageId, (TapeLibraryObjectStorageLocation)new TapeLibraryInputFileObjectStorageLocation(), now, now));
        }
        catch (ObjectReferentialException ex) {
            throw new ContentAddressableStorageServerException(String.format("Could not index the object %s in container %s in database", objectName, containerName), (Throwable)ex);
        }
        finally {
            this.fileBucketTarCreatorManager.addToQueue(new InputFileToProcessMessage(containerName, objectName, storageId, size, digestValue, digestType.getName()));
        }
    }

    public void checkObjectDigestAndStoreDigest(String containerName, String objectName, String objectDigest, DigestType digestType, long size) {
    }

    public ObjectContent getObject(String containerName, String objectName) throws ContentAddressableStorageException {
        LOGGER.debug(String.format("Download object %s from container %s", objectName, containerName));
        for (int nbTry = 0; nbTry < 5; ++nbTry) {
            Optional<ObjectContent> objectContent = this.tryReadObject(containerName, objectName);
            if (objectContent.isPresent()) {
                return objectContent.get();
            }
            LOGGER.warn("Could not read object " + containerName + "/" + objectName + " due to concurrent update");
            int sleepDelay = ThreadLocalRandom.current().nextInt(10, 3000);
            Uninterruptibles.sleepUninterruptibly((long)sleepDelay, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        throw new ContentAddressableStorageServerException("Could not read object " + containerName + "/" + objectName);
    }

    private Optional<ObjectContent> tryReadObject(String containerName, String objectName) throws ContentAddressableStorageServerException, ContentAddressableStorageNotFoundException, ContentAddressableStorageUnavailableDataFromAsyncOfferException {
        TapeObjectReferentialEntity objectReferentialEntity = this.getTapeObjectReferentialEntity(containerName, objectName);
        TapeLibraryObjectStorageLocation location = objectReferentialEntity.getLocation();
        if (location instanceof TapeLibraryInputFileObjectStorageLocation) {
            Optional<InputStream> inputStream = this.tryReadObjectFromInputFile(containerName, objectReferentialEntity);
            if (inputStream.isPresent()) {
                return Optional.of(this.toObjectContent(inputStream.get(), objectReferentialEntity));
            }
            return Optional.empty();
        }
        if (location instanceof TapeLibraryTarObjectStorageLocation) {
            InputStream inputStream = this.readFromTarFiles(containerName, objectName, ((TapeLibraryTarObjectStorageLocation)objectReferentialEntity.getLocation()).getTarEntries());
            return Optional.of(this.toObjectContent(inputStream, objectReferentialEntity));
        }
        throw new IllegalStateException("Unknown object storage location: " + String.valueOf(location.getClass()));
    }

    private TapeObjectReferentialEntity getTapeObjectReferentialEntity(String containerName, String objectName) throws ContentAddressableStorageServerException, ContentAddressableStorageNotFoundException {
        Optional<TapeObjectReferentialEntity> objectReferentialEntity;
        try {
            objectReferentialEntity = this.objectReferentialRepository.find(containerName, objectName);
        }
        catch (ObjectReferentialException e) {
            throw new ContentAddressableStorageServerException((Throwable)e);
        }
        if (objectReferentialEntity.isEmpty()) {
            throw new ContentAddressableStorageNotFoundException(String.valueOf(ErrorMessage.OBJECT_NOT_FOUND) + containerName + "/" + objectName);
        }
        return objectReferentialEntity.get();
    }

    private Optional<InputStream> tryReadObjectFromInputFile(String containerName, TapeObjectReferentialEntity tapeObjectReferentialEntity) throws ContentAddressableStorageServerException {
        try {
            InputStream inputStream = this.basicFileStorage.readFile(containerName, tapeObjectReferentialEntity.getStorageId());
            return Optional.of(inputStream);
        }
        catch (FileNotFoundException | NoSuchFileException ex) {
            LOGGER.warn("Could not open inputFile '" + containerName + "/" + tapeObjectReferentialEntity.getStorageId() + "'. Concurrent delete or move to TAR archive?", (Throwable)ex);
            return Optional.empty();
        }
        catch (IOException ex) {
            throw new ContentAddressableStorageServerException("An error occurred during reading inputFile '" + containerName + "/" + tapeObjectReferentialEntity.getStorageId() + "'", (Throwable)ex);
        }
    }

    private InputStream readFromTarFiles(String containerName, String objectName, List<TarEntryDescription> tarEntries) throws ContentAddressableStorageServerException, ContentAddressableStorageUnavailableDataFromAsyncOfferException {
        if (tarEntries == null || tarEntries.isEmpty()) {
            throw new IllegalStateException("empty TAR description for object : " + containerName + "/" + objectName);
        }
        String fileBucketId = this.bucketTopologyHelper.getFileBucketFromContainerName(containerName);
        Set<String> tarIds = this.getTarIds(tarEntries);
        Map<String, TapeArchiveReferentialEntity> tapeArchiveReferentialEntityMap = this.getTapeArchiveEntities(tarIds);
        if (tarEntries.size() == 1) {
            TarEntryDescription tarEntry = tarEntries.get(0);
            return this.loadTarFileInputStream(containerName, objectName, tarEntry);
        }
        return this.loadLargeObjectInputStream(containerName, objectName, tarEntries, fileBucketId, tarIds, tapeArchiveReferentialEntityMap);
    }

    private Set<String> getTarIds(List<TarEntryDescription> tarEntryDescriptions) {
        return tarEntryDescriptions.stream().map(TarEntryDescription::getTarFileId).collect(Collectors.toSet());
    }

    private Map<String, TapeArchiveReferentialEntity> getTapeArchiveEntities(Set<String> tarFileIds) throws ContentAddressableStorageServerException {
        List<TapeArchiveReferentialEntity> tapeArchiveReferentialEntityList;
        try {
            tapeArchiveReferentialEntityList = this.archiveReferentialRepository.bulkFind(tarFileIds);
        }
        catch (ArchiveReferentialException e) {
            throw new ContentAddressableStorageServerException("Could not load archive info from DB", (Throwable)e);
        }
        Map<String, TapeArchiveReferentialEntity> tapeArchiveReferentialEntityMap = tapeArchiveReferentialEntityList.stream().collect(Collectors.toMap(TapeArchiveReferentialEntity::getArchiveId, tapeArchiveReferentialEntity -> tapeArchiveReferentialEntity));
        if (tapeArchiveReferentialEntityMap.size() != tarFileIds.size()) {
            SetUtils.SetView missingTarIds = SetUtils.difference(tarFileIds, tapeArchiveReferentialEntityMap.keySet());
            throw new IllegalStateException("Could not locate TAR(s) archives " + String.valueOf(missingTarIds));
        }
        return tapeArchiveReferentialEntityMap;
    }

    private LockHandle lockTarEntryEviction(String fileBucketId, Set<String> tarIds) {
        return this.archiveCacheEvictionController.createLock(tarIds.stream().map(tarId -> new ArchiveCacheEntry(fileBucketId, (String)tarId)).collect(Collectors.toSet()));
    }

    private LazySequenceInputStream loadLargeObjectInputStream(String containerName, String objectName, List<TarEntryDescription> tarEntries, String fileBucketId, Set<String> tarIds, Map<String, TapeArchiveReferentialEntity> tapeArchiveReferentialEntityMap) throws ContentAddressableStorageUnavailableDataFromAsyncOfferException {
        final LockHandle evictionLock = this.lockTarEntryEviction(fileBucketId, tarIds);
        try {
            this.checkTarExistence(fileBucketId, tapeArchiveReferentialEntityMap.values());
            Iterator lazyInputStreamIterator = tarEntries.stream().map(tarEntry -> {
                try {
                    return this.loadTarFileInputStream(containerName, objectName, (TarEntryDescription)tarEntry);
                }
                catch (ContentAddressableStorageServerException | ContentAddressableStorageUnavailableDataFromAsyncOfferException e) {
                    throw new RuntimeException("Could not load entry " + fileBucketId + "/" + tarEntry.getTarFileId() + " @" + tarEntry.getEntryName(), e);
                }
            }).iterator();
            return new LazySequenceInputStream(lazyInputStreamIterator){

                public void close() throws IOException {
                    evictionLock.release();
                    super.close();
                }
            };
        }
        catch (Exception e) {
            evictionLock.release();
            throw e;
        }
    }

    private void checkTarExistence(String fileBucketId, Collection<TapeArchiveReferentialEntity> tapeArchiveReferentialEntities) throws ContentAddressableStorageUnavailableDataFromAsyncOfferException {
        for (TapeArchiveReferentialEntity tapeArchiveReferentialEntity : tapeArchiveReferentialEntities) {
            this.checkTarExistence(fileBucketId, tapeArchiveReferentialEntity.getArchiveId());
        }
    }

    private void checkTarExistence(String fileBucketId, String archiveId) throws ContentAddressableStorageUnavailableDataFromAsyncOfferException {
        if (this.fileBucketTarCreatorManager.containsTar(fileBucketId, archiveId)) {
            LOGGER.debug("{}/{} found." + fileBucketId);
            return;
        }
        if (this.archiveCacheStorage.containsArchive(fileBucketId, archiveId)) {
            LOGGER.debug("{}/{} found." + fileBucketId);
            return;
        }
        throw new ContentAddressableStorageUnavailableDataFromAsyncOfferException("Could not find archive " + fileBucketId + "/" + archiveId);
    }

    private InputStream loadTarFileInputStream(String containerName, String objectName, TarEntryDescription tarEntry) throws ContentAddressableStorageUnavailableDataFromAsyncOfferException, ContentAddressableStorageServerException {
        try {
            FileInputStream fileInputStream = this.locateAndOpenTarFileInputStream(containerName, objectName, tarEntry);
            return TarHelper.readEntryAtPos(fileInputStream, tarEntry);
        }
        catch (IOException e) {
            throw new ContentAddressableStorageServerException("Could not load tar file", (Throwable)e);
        }
    }

    private FileInputStream locateAndOpenTarFileInputStream(String containerName, String objectName, TarEntryDescription tarEntry) throws ContentAddressableStorageUnavailableDataFromAsyncOfferException {
        String fileBucketId = this.bucketTopologyHelper.getFileBucketFromContainerName(containerName);
        Optional<FileInputStream> fileInputStream = this.fileBucketTarCreatorManager.tryReadTar(fileBucketId, tarEntry.getTarFileId());
        if (fileInputStream.isPresent()) {
            return fileInputStream.get();
        }
        try {
            Optional<FileInputStream> cachedFileInputStream = this.archiveCacheStorage.tryReadArchive(fileBucketId, tarEntry.getTarFileId());
            if (cachedFileInputStream.isEmpty()) {
                throw new ContentAddressableStorageUnavailableDataFromAsyncOfferException("Could not locate archive " + tarEntry.getTarFileId() + " for object " + containerName + "/" + objectName);
            }
            return cachedFileInputStream.get();
        }
        catch (IllegalPathException e) {
            throw new IllegalStateException("Illegal fileBucketId/tarId : " + fileBucketId + "/" + tarEntry.getTarFileId(), e);
        }
    }

    private ObjectContent toObjectContent(InputStream inputStream, TapeObjectReferentialEntity tapeObjectReferentialEntity) throws ContentAddressableStorageServerException {
        try {
            return new ObjectContent((InputStream)new ExactDigestValidatorInputStream((InputStream)new ExactSizeInputStream(inputStream, tapeObjectReferentialEntity.getSize()), VitamConfiguration.getDefaultDigestType(), tapeObjectReferentialEntity.getDigest()), tapeObjectReferentialEntity.getSize());
        }
        catch (IOException e) {
            throw new ContentAddressableStorageServerException((Throwable)e);
        }
    }

    public String createAccessRequest(String containerName, List<String> objectsNames) throws ContentAddressableStorageException {
        return this.accessRequestManager.createAccessRequest(containerName, objectsNames);
    }

    public Map<String, AccessRequestStatus> checkAccessRequestStatuses(List<String> accessRequestIds, boolean adminCrossTenantAccessRequestAllowed) throws ContentAddressableStorageException {
        return this.accessRequestManager.checkAccessRequestStatuses(accessRequestIds, adminCrossTenantAccessRequestAllowed);
    }

    public void removeAccessRequest(String accessRequestId, boolean adminCrossTenantAccessRequestAllowed) throws ContentAddressableStorageException {
        this.accessRequestManager.removeAccessRequest(accessRequestId, adminCrossTenantAccessRequestAllowed);
    }

    public boolean checkObjectAvailability(String containerName, List<String> objectNames) throws ContentAddressableStorageException {
        return this.accessRequestManager.checkObjectAvailability(containerName, objectNames);
    }

    public void deleteObject(String containerName, String objectName) throws ContentAddressableStorageServerException, ContentAddressableStorageNotFoundException {
        LOGGER.debug(String.format("Delete object %s from container %s", objectName, containerName));
        try {
            boolean objectDeleted = this.objectReferentialRepository.delete(new TapeLibraryObjectReferentialId(containerName, objectName));
            if (!objectDeleted) {
                throw new ContentAddressableStorageNotFoundException(String.valueOf(ErrorMessage.OBJECT_NOT_FOUND) + objectName);
            }
        }
        catch (ObjectReferentialException e) {
            throw new ContentAddressableStorageServerException("Error on deleting object " + containerName + "/" + objectName);
        }
    }

    public boolean isExistingObject(String containerName, String objectName) throws ContentAddressableStorageServerException {
        LOGGER.debug(String.format("Check existence of object %s in container %s", objectName, containerName));
        try {
            Optional<TapeObjectReferentialEntity> objectReferentialEntity = this.objectReferentialRepository.find(containerName, objectName);
            return objectReferentialEntity.isPresent();
        }
        catch (ObjectReferentialException ex) {
            throw new ContentAddressableStorageServerException(String.format("Could not check existence of object %s in container %s", objectName, containerName), (Throwable)ex);
        }
    }

    public String getObjectDigest(String containerName, String objectName, DigestType algo, boolean noCache) throws ContentAddressableStorageException {
        LOGGER.debug(String.format("Get digest of object %s in container %s", objectName, containerName));
        try {
            Optional<TapeObjectReferentialEntity> objectReferentialEntity = this.objectReferentialRepository.find(containerName, objectName);
            if (objectReferentialEntity.isEmpty()) {
                throw new ContentAddressableStorageNotFoundException(String.format("No such object %s in container %s", objectName, containerName));
            }
            if (!algo.getName().equals(objectReferentialEntity.get().getDigestType())) {
                throw new ContentAddressableStorageNotFoundException(String.format("Digest algorithm mismatch for object %s in container %s. Expected %s, found %s", objectName, containerName, algo.getName(), objectReferentialEntity.get().getDigestType()));
            }
            return objectReferentialEntity.get().getDigest();
        }
        catch (ObjectReferentialException ex) {
            throw new ContentAddressableStorageServerException(String.format("Could not get digest of object %s in container %s", objectName, containerName), (Throwable)ex);
        }
    }

    public ContainerInformation getContainerInformation(String containerName) {
        LOGGER.debug(String.format("Get information of container %s", containerName));
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_NAME_IS_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName});
        ContainerInformation containerInformation = new ContainerInformation();
        containerInformation.setUsableSpace(-1L);
        return containerInformation;
    }

    public MetadatasObject getObjectMetadata(String containerName, String objectName, boolean noCache) throws ContentAddressableStorageException {
        LOGGER.debug(String.format("Get metadata of object %s in container %s", objectName, containerName));
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_OBJECT_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, objectName});
        try {
            Optional<TapeObjectReferentialEntity> objectReferentialEntity = this.objectReferentialRepository.find(containerName, objectName);
            if (objectReferentialEntity.isEmpty()) {
                throw new ContentAddressableStorageNotFoundException(String.format("No such object %s in container %s", objectName, containerName));
            }
            MetadatasStorageObject result = new MetadatasStorageObject();
            result.setType(ContainerUtils.parseDataCategoryFromContainerName((String)containerName).getFolder());
            result.setObjectName(objectName);
            result.setDigest(objectReferentialEntity.get().getDigest());
            result.setFileSize(objectReferentialEntity.get().getSize());
            result.setLastModifiedDate(objectReferentialEntity.get().getLastObjectModifiedDate());
            return result;
        }
        catch (ObjectReferentialException ex) {
            throw new ContentAddressableStorageServerException(String.format("Could not get metadata of object %s in container %s", objectName, containerName), (Throwable)ex);
        }
    }

    public void listContainer(String containerName, ObjectListingListener objectListingListener) throws ContentAddressableStorageServerException, IOException {
        LOGGER.info("Listing of objects of container {}", (Object)containerName);
        try (CloseableIterator<ObjectEntry> entryIterator = this.objectReferentialRepository.listContainerObjectEntries(containerName);){
            while (entryIterator.hasNext()) {
                objectListingListener.handleObjectEntry((ObjectEntry)entryIterator.next());
            }
        }
        catch (MongoException | ObjectReferentialException e) {
            throw new ContentAddressableStorageServerException("Could not list objects of container " + containerName, e);
        }
        LOGGER.info("Done listing objects of container {}", (Object)containerName);
    }

    public void close() {
    }
}

