/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.cas;

import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;

public class IncompleteWriteOrderBootstrapRecovery {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(IncompleteWriteOrderBootstrapRecovery.class);
    private final String tmpTarOutputStorageFolder;

    public IncompleteWriteOrderBootstrapRecovery(String tmpTarOutputStorageFolder) {
        this.tmpTarOutputStorageFolder = tmpTarOutputStorageFolder;
    }

    public void initializeOnBootstrap() {
        try {
            Path tmpTarOutputStoragePath = Paths.get(this.tmpTarOutputStorageFolder, new String[0]);
            if (!tmpTarOutputStoragePath.toFile().exists()) {
                this.emptyDirectoryContent(tmpTarOutputStoragePath);
            }
        }
        catch (Exception e) {
            throw new VitamRuntimeException("Could not reschedule tar files to copy on tape", (Throwable)e);
        }
    }

    private void emptyDirectoryContent(Path path) throws IOException {
        try (Stream<Path> fileStream = Files.list(path);){
            fileStream.forEach(subPath -> {
                try {
                    LOGGER.warn("Deleting tmp file " + subPath.toFile().getAbsolutePath());
                    FileUtils.forceDelete((File)subPath.toFile());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }
}

