/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.cas;

import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.stream.ExtendedFileOutputStream;
import fr.gouv.vitam.storage.engine.common.model.QueueMessageType;
import fr.gouv.vitam.storage.engine.common.model.TapeArchiveReferentialEntity;
import fr.gouv.vitam.storage.engine.common.model.TapeLibraryArchiveStorageLocation;
import fr.gouv.vitam.storage.engine.common.model.TapeLibraryBuildingOnDiskArchiveStorageLocation;
import fr.gouv.vitam.storage.engine.common.model.TapeLibraryTarObjectStorageLocation;
import fr.gouv.vitam.storage.engine.common.model.TarEntryDescription;
import fr.gouv.vitam.storage.engine.common.model.WriteOrder;
import fr.gouv.vitam.storage.offers.tape.cas.ArchiveReferentialRepository;
import fr.gouv.vitam.storage.offers.tape.cas.BasicFileStorage;
import fr.gouv.vitam.storage.offers.tape.cas.InputFileToProcessMessage;
import fr.gouv.vitam.storage.offers.tape.cas.ObjectReferentialRepository;
import fr.gouv.vitam.storage.offers.tape.cas.TarAppender;
import fr.gouv.vitam.storage.offers.tape.cas.TarBufferingTimedOutMessage;
import fr.gouv.vitam.storage.offers.tape.cas.TarCreatorMessage;
import fr.gouv.vitam.storage.offers.tape.cas.WriteOrderCreator;
import fr.gouv.vitam.storage.offers.tape.exception.ArchiveReferentialException;
import fr.gouv.vitam.storage.offers.tape.exception.ObjectReferentialException;
import fr.gouv.vitam.storage.offers.tape.inmemoryqueue.QueueProcessingException;
import fr.gouv.vitam.storage.offers.tape.inmemoryqueue.QueueProcessor;
import fr.gouv.vitam.storage.offers.tape.metrics.InputFilesMetrics;
import fr.gouv.vitam.storage.offers.tape.utils.LocalFileUtils;
import io.prometheus.client.Gauge;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;

public class FileBucketTarCreator
extends QueueProcessor<TarCreatorMessage> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(FileBucketTarCreator.class);
    private final BasicFileStorage basicFileStorage;
    private final ObjectReferentialRepository objectReferentialRepository;
    private final ArchiveReferentialRepository archiveReferentialRepository;
    private final WriteOrderCreator writeOrderCreator;
    private final String bucketId;
    private final String fileBucketId;
    private final Path fileBucketStoragePath;
    private final int tarBufferingTimeout;
    private final TimeUnit tarBufferingTimeUnit;
    private final ScheduledExecutorService scheduledExecutorService;
    private TarAppender currentTarAppender = null;
    private ExtendedFileOutputStream currentTarOutputStream = null;
    private Path currentTempTarFilePath = null;
    private Path currentTarFilePath = null;
    private ScheduledFuture<?> tarBufferingTimoutChecker;
    private final long maxTarEntrySize;
    private final long maxTarFileSize;

    public FileBucketTarCreator(BasicFileStorage basicFileStorage, ObjectReferentialRepository objectReferentialRepository, ArchiveReferentialRepository archiveReferentialRepository, WriteOrderCreator writeOrderCreator, String bucketId, String fileBucketId, int tarBufferingTimeout, TimeUnit tarBufferingTimeUnit, String inputTarStorageFolder, long maxTarEntrySize, long maxTarFileSize) {
        super("FileBucketTarCreator-" + fileBucketId);
        this.maxTarEntrySize = maxTarEntrySize;
        this.basicFileStorage = basicFileStorage;
        this.objectReferentialRepository = objectReferentialRepository;
        this.archiveReferentialRepository = archiveReferentialRepository;
        this.writeOrderCreator = writeOrderCreator;
        this.bucketId = bucketId;
        this.fileBucketId = fileBucketId;
        this.tarBufferingTimeout = tarBufferingTimeout;
        this.tarBufferingTimeUnit = tarBufferingTimeUnit;
        this.maxTarFileSize = maxTarFileSize;
        this.fileBucketStoragePath = LocalFileUtils.fileBuckedInputFilePath(inputTarStorageFolder, fileBucketId);
        this.scheduledExecutorService = Executors.newScheduledThreadPool(1);
    }

    @Override
    protected void processMessage(TarCreatorMessage message) throws QueueProcessingException {
        if (message instanceof TarBufferingTimedOutMessage) {
            this.checkTarBufferingTimeout((TarBufferingTimedOutMessage)message);
        } else if (message instanceof InputFileToProcessMessage) {
            this.writeFile((InputFileToProcessMessage)message);
        } else {
            throw new IllegalStateException("Unknown message time type " + String.valueOf(message.getClass()));
        }
    }

    private void writeFile(InputFileToProcessMessage message) throws QueueProcessingException {
        Optional<Object> inputStream;
        block11: {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Processing message " + JsonHandler.unprettyPrint((Object)message));
            }
            inputStream = Optional.empty();
            inputStream = this.openInputFile(message);
            if (!inputStream.isEmpty()) break block11;
            LOGGER.info("File {} ({}/{}) not found. Deleted meanwhile?", new Object[]{message.getStorageId(), message.getContainerName(), message.getObjectName()});
            inputStream.ifPresent(IOUtils::closeQuietly);
            ((Gauge.Child)InputFilesMetrics.QUEUED_INPUT_FILES_COUNT.labels(new String[]{this.bucketId})).dec();
            ((Gauge.Child)InputFilesMetrics.QUEUED_INPUT_FILES_SIZE.labels(new String[]{this.bucketId})).dec((double)message.getSize());
            return;
        }
        try {
            long entrySize;
            if (this.currentTarAppender == null) {
                this.createTarFile();
            }
            Digest digest = new Digest(DigestType.fromValue((String)message.getDigestAlgorithm()));
            InputStream digestInputStream = digest.getDigestInputStream((InputStream)inputStream.get());
            long remainingSize = message.getSize();
            ArrayList<TarEntryDescription> tarEntryDescriptions = new ArrayList<TarEntryDescription>();
            int entryIndex = 0;
            do {
                if (!this.currentTarAppender.canAppend(entrySize = Math.min(remainingSize, this.maxTarEntrySize))) {
                    LOGGER.info("Finalizing full tar file {}", (Object)this.currentTempTarFilePath);
                    this.finalizeTarFile();
                    this.createTarFile();
                }
                String entryName = LocalFileUtils.createTarEntryName(message.getContainerName(), message.getStorageId(), entryIndex);
                BoundedInputStream entryInputStream = new BoundedInputStream(digestInputStream, entrySize);
                TarEntryDescription tarEntryDescription = this.currentTarAppender.append(entryName, (InputStream)entryInputStream, entrySize);
                tarEntryDescriptions.add(tarEntryDescription);
                ++entryIndex;
            } while ((remainingSize -= entrySize) > 0L);
            this.currentTarAppender.flush();
            this.currentTarOutputStream.fsync();
            if (!digest.digestHex().equals(message.getDigestValue())) {
                throw new QueueProcessingException(QueueProcessingException.RetryPolicy.FATAL_SHUTDOWN, "Invalid file digest. request=" + JsonHandler.unprettyPrint((Object)message) + ". Actual digest=" + digest.digestHex() + ".");
            }
            this.indexInObjectReferential(message, tarEntryDescriptions);
            IOUtils.closeQuietly((InputStream)((InputStream)inputStream.get()));
            this.basicFileStorage.deleteFile(message.getContainerName(), message.getStorageId());
        }
        catch (IOException | RuntimeException ex) {
            try {
                if (this.currentTarOutputStream != null) {
                    IOUtils.closeQuietly((OutputStream)this.currentTarOutputStream);
                }
                throw new QueueProcessingException(QueueProcessingException.RetryPolicy.FATAL_SHUTDOWN, "An error occurred while archiving file to tar", ex);
            }
            catch (Throwable throwable) {
                inputStream.ifPresent(IOUtils::closeQuietly);
                ((Gauge.Child)InputFilesMetrics.QUEUED_INPUT_FILES_COUNT.labels(new String[]{this.bucketId})).dec();
                ((Gauge.Child)InputFilesMetrics.QUEUED_INPUT_FILES_SIZE.labels(new String[]{this.bucketId})).dec((double)message.getSize());
                throw throwable;
            }
        }
        inputStream.ifPresent(IOUtils::closeQuietly);
        ((Gauge.Child)InputFilesMetrics.QUEUED_INPUT_FILES_COUNT.labels(new String[]{this.bucketId})).dec();
        ((Gauge.Child)InputFilesMetrics.QUEUED_INPUT_FILES_SIZE.labels(new String[]{this.bucketId})).dec((double)message.getSize());
    }

    private Optional<InputStream> openInputFile(InputFileToProcessMessage message) throws IOException {
        try {
            return Optional.of(this.basicFileStorage.readFile(message.getContainerName(), message.getStorageId()));
        }
        catch (FileNotFoundException ex) {
            LOGGER.debug((Throwable)ex);
            return Optional.empty();
        }
    }

    private void createTarFile() throws QueueProcessingException, IOException {
        LocalDateTime now = LocalDateUtil.now();
        String tarFileId = LocalFileUtils.createTarId(now);
        this.currentTarFilePath = this.fileBucketStoragePath.resolve(tarFileId);
        this.currentTempTarFilePath = this.fileBucketStoragePath.resolve(tarFileId + ".tmp");
        LOGGER.info("Creating file {}", (Object)this.currentTempTarFilePath);
        try {
            TapeArchiveReferentialEntity tarReferentialEntity = new TapeArchiveReferentialEntity(tarFileId, (TapeLibraryArchiveStorageLocation)new TapeLibraryBuildingOnDiskArchiveStorageLocation(), null, null, LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)now));
            this.archiveReferentialRepository.insert(tarReferentialEntity);
        }
        catch (ArchiveReferentialException ex) {
            throw new QueueProcessingException(QueueProcessingException.RetryPolicy.RETRY, "Could not create a new tar file", ex);
        }
        this.currentTarOutputStream = new ExtendedFileOutputStream(this.currentTempTarFilePath, true);
        this.currentTarAppender = new TarAppender((OutputStream)this.currentTarOutputStream, tarFileId, this.maxTarFileSize);
        this.tarBufferingTimoutChecker = this.scheduledExecutorService.schedule(() -> this.checkTarBufferingTimeout(tarFileId), (long)this.tarBufferingTimeout, this.tarBufferingTimeUnit);
    }

    private void finalizeTarFile() throws IOException {
        this.currentTarAppender.close();
        Files.move(this.currentTempTarFilePath, this.currentTarFilePath, StandardCopyOption.ATOMIC_MOVE);
        WriteOrder writeOrder = new WriteOrder(this.bucketId, this.fileBucketId, LocalFileUtils.archiveFileNameRelativeToInputArchiveStorageFolder(this.fileBucketId, this.currentTarAppender.getTarId()), this.currentTarAppender.getBytesWritten(), this.currentTarAppender.getDigestValue(), this.currentTarAppender.getTarId(), QueueMessageType.WriteOrder);
        this.writeOrderCreator.addToQueue(writeOrder);
        this.currentTarAppender = null;
        this.currentTarOutputStream = null;
        this.tarBufferingTimoutChecker.cancel(false);
    }

    private void indexInObjectReferential(InputFileToProcessMessage inputFileToProcessMessage, List<TarEntryDescription> tarEntryDescriptions) throws QueueProcessingException {
        try {
            this.objectReferentialRepository.updateStorageLocation(inputFileToProcessMessage.getContainerName(), inputFileToProcessMessage.getObjectName(), inputFileToProcessMessage.getStorageId(), new TapeLibraryTarObjectStorageLocation(tarEntryDescriptions));
        }
        catch (ObjectReferentialException ex) {
            throw new QueueProcessingException(QueueProcessingException.RetryPolicy.RETRY, "Could not index object referential " + inputFileToProcessMessage.getContainerName() + "/" + inputFileToProcessMessage.getObjectName() + " (" + inputFileToProcessMessage.getStorageId() + ") to tar files " + JsonHandler.unprettyPrint(tarEntryDescriptions), ex);
        }
    }

    private void checkTarBufferingTimeout(TarBufferingTimedOutMessage tarBufferingTimedOutMessage) throws QueueProcessingException {
        if (this.currentTarAppender == null || !this.currentTarAppender.getTarId().equals(tarBufferingTimedOutMessage.getTarId())) {
            return;
        }
        try {
            LOGGER.info("Finalizing tar file {} after timeout {} {}", new Object[]{this.currentTempTarFilePath, this.tarBufferingTimeout, this.tarBufferingTimeUnit});
            this.finalizeTarFile();
        }
        catch (IOException ex) {
            throw new QueueProcessingException(QueueProcessingException.RetryPolicy.FATAL_SHUTDOWN, "An error occurred while archiving file to tar", ex);
        }
    }

    private void checkTarBufferingTimeout(String tarId) {
        this.addFirst(new TarBufferingTimedOutMessage(tarId));
    }

    public boolean containsTar(String tarId) {
        Path tempTarPath = this.fileBucketStoragePath.resolve(tarId + ".tmp");
        if (Files.exists(tempTarPath, new LinkOption[0])) {
            LOGGER.debug(String.valueOf(tempTarPath) + " found");
            return true;
        }
        Path readyTarPath = this.fileBucketStoragePath.resolve(tarId);
        if (Files.exists(readyTarPath, new LinkOption[0])) {
            LOGGER.debug(String.valueOf(readyTarPath) + " found");
            return true;
        }
        LOGGER.info("Tar file " + tarId + " could not be located. Concurrent delete?");
        return false;
    }

    public Optional<FileInputStream> tryReadTar(String tarId) {
        Path readyTarPath;
        Path tempTarPath = this.fileBucketStoragePath.resolve(tarId + ".tmp");
        if (Files.exists(tempTarPath, new LinkOption[0])) {
            try {
                FileInputStream fileInputStream = new FileInputStream(tempTarPath.toFile());
                return Optional.of(fileInputStream);
            }
            catch (FileNotFoundException e) {
                LOGGER.info("Could not open " + String.valueOf(tempTarPath) + ". Concurrent rename?", (Throwable)e);
            }
        }
        if (Files.exists(readyTarPath = this.fileBucketStoragePath.resolve(tarId), new LinkOption[0])) {
            try {
                FileInputStream fileInputStream = new FileInputStream(readyTarPath.toFile());
                return Optional.of(fileInputStream);
            }
            catch (FileNotFoundException e) {
                LOGGER.info("Could not open " + String.valueOf(readyTarPath) + ". Concurrent delete?", (Throwable)e);
            }
        }
        LOGGER.info("Tar file " + tarId + " could not be located. Concurrent delete?");
        return Optional.empty();
    }

    @Override
    public void addToQueue(TarCreatorMessage message) {
        super.addToQueue(message);
        if (message instanceof InputFileToProcessMessage) {
            ((Gauge.Child)InputFilesMetrics.QUEUED_INPUT_FILES_COUNT.labels(new String[]{this.bucketId})).inc();
            ((Gauge.Child)InputFilesMetrics.QUEUED_INPUT_FILES_SIZE.labels(new String[]{this.bucketId})).inc((double)((InputFileToProcessMessage)message).getSize());
        }
    }
}

