/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.cas;

import com.google.common.collect.ImmutableMap;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.storage.tapelibrary.FileBucketConfiguration;
import fr.gouv.vitam.common.storage.tapelibrary.TapeLibraryBucketConfiguration;
import fr.gouv.vitam.common.storage.tapelibrary.TapeLibraryTopologyConfiguration;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.utils.ContainerUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class BucketTopologyHelper {
    public static final String DEFAULT = "default";
    public static final String BACKUP_BUCKET = "backup";
    public static final String BACKUP_FILE_BUCKET = "backup-db";
    private final Map<Pair<Integer, DataCategory>, String> containerToFileBucketMap;
    private final Map<String, String> fileBucketToBucketMap;
    private final Map<String, Integer> tarBufferingTimeoutInMinutesByBucketId;
    private final Set<String> fileBucketIdsToKeepForeverInCache;

    public BucketTopologyHelper(TapeLibraryTopologyConfiguration configuration) {
        Map<String, FileBucketConfiguration> fileBuckets = this.getFileBucketsConfigurationOrDefault(configuration);
        this.validateFileBuckets(fileBuckets);
        this.validateBucketConfiguration(configuration);
        Map<String, List> buckets = configuration.getBuckets().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((TapeLibraryBucketConfiguration)entry.getValue()).getTenants()));
        Map<DataCategory, String> dataCategoryToFileBucketMap = Arrays.stream(DataCategory.values()).collect(Collectors.toMap(dataCategory -> dataCategory, dataCategory -> fileBuckets.entrySet().stream().filter(entry -> ((FileBucketConfiguration)entry.getValue()).getDataCategories().contains(dataCategory.getFolder())).map(Map.Entry::getKey).findFirst().orElse(DEFAULT)));
        HashMap<ImmutablePair, String> containerToFileBucketMap = new HashMap<ImmutablePair, String>();
        HashMap<String, String> fileBucketIdToBucketMap = new HashMap<String, String>();
        for (Map.Entry<String, List> bucketEntry : buckets.entrySet()) {
            String bucketId = bucketEntry.getKey();
            for (Integer tenant : bucketEntry.getValue()) {
                for (DataCategory dataCategory2 : DataCategory.values()) {
                    String fileBucketId = BucketTopologyHelper.getFileBucketId(bucketId, dataCategoryToFileBucketMap.get(dataCategory2));
                    containerToFileBucketMap.put(new ImmutablePair((Object)tenant, (Object)dataCategory2), fileBucketId);
                    fileBucketIdToBucketMap.put(fileBucketId, bucketId);
                }
            }
        }
        this.containerToFileBucketMap = MapUtils.unmodifiableMap(containerToFileBucketMap);
        this.fileBucketToBucketMap = MapUtils.unmodifiableMap(fileBucketIdToBucketMap);
        this.tarBufferingTimeoutInMinutesByBucketId = configuration.getBuckets().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((TapeLibraryBucketConfiguration)entry.getValue()).getTarBufferingTimeoutInMinutes()));
        HashSet<String> fileBucketIdToKeepForeverInCache = new HashSet<String>();
        for (Map.Entry<String, List> bucketEntry : buckets.entrySet()) {
            String bucketId = bucketEntry.getKey();
            for (Map.Entry<String, FileBucketConfiguration> fileBucketEntry : fileBuckets.entrySet()) {
                String fileBucket = fileBucketEntry.getKey();
                String fileBucketId = BucketTopologyHelper.getFileBucketId(bucketId, fileBucket);
                FileBucketConfiguration fileBucketConfiguration = fileBucketEntry.getValue();
                if (!fileBucketConfiguration.getKeepForeverInCache().booleanValue()) continue;
                fileBucketIdToKeepForeverInCache.add(fileBucketId);
            }
        }
        this.fileBucketIdsToKeepForeverInCache = SetUtils.unmodifiableSet(fileBucketIdToKeepForeverInCache);
    }

    public static String getFileBucketId(String bucket, String fileBucket) {
        return bucket + "-" + fileBucket;
    }

    private Map<String, FileBucketConfiguration> getFileBucketsConfigurationOrDefault(TapeLibraryTopologyConfiguration configuration) {
        if (configuration == null) {
            throw new VitamRuntimeException("Invalid conf. Missing file-bucket topology configuration");
        }
        Map fileBuckets = configuration.getFileBuckets();
        if (fileBuckets == null) {
            fileBuckets = ImmutableMap.of((Object)"metadata", (Object)new FileBucketConfiguration().setDataCategories(Arrays.asList(DataCategory.UNIT.getFolder(), DataCategory.OBJECTGROUP.getFolder())).setKeepForeverInCache(Boolean.valueOf(true)), (Object)"objects", (Object)new FileBucketConfiguration().setDataCategories(Collections.singletonList(DataCategory.OBJECT.getFolder())).setKeepForeverInCache(Boolean.valueOf(false)), (Object)DEFAULT, (Object)new FileBucketConfiguration().setDataCategories(Collections.emptyList()).setKeepForeverInCache(Boolean.valueOf(true)));
        }
        return fileBuckets;
    }

    private void validateFileBuckets(Map<String, FileBucketConfiguration> fileBuckets) throws VitamRuntimeException {
        if (fileBuckets.isEmpty()) {
            throw new VitamRuntimeException("Invalid conf. File buckets must not be null");
        }
        if (fileBuckets.containsKey(BACKUP_FILE_BUCKET)) {
            throw new VitamRuntimeException("Reserved backup-db file bucket");
        }
        if (fileBuckets.containsValue(null)) {
            throw new VitamRuntimeException("Null file bucket configuration");
        }
        if (fileBuckets.values().stream().map(FileBucketConfiguration::getDataCategories).anyMatch(Objects::isNull)) {
            throw new VitamRuntimeException("Null file bucket data categories");
        }
        if (fileBuckets.values().stream().map(FileBucketConfiguration::getKeepForeverInCache).anyMatch(Objects::isNull)) {
            throw new VitamRuntimeException("Missing file bucket cache configuration");
        }
        if (fileBuckets.values().stream().map(FileBucketConfiguration::getDataCategories).anyMatch(dataCategories -> dataCategories.contains(null))) {
            throw new VitamRuntimeException("Null file bucket data categories");
        }
        Stream fileBucketDataCategories = fileBuckets.values().stream().map(FileBucketConfiguration::getDataCategories).flatMap(Collection::stream);
        if (BucketTopologyHelper.hasDuplicates(fileBucketDataCategories)) {
            throw new VitamRuntimeException("Duplicates found in file bucket configuration");
        }
        if (!fileBuckets.containsKey(DEFAULT) || !fileBuckets.get(DEFAULT).getDataCategories().isEmpty()) {
            throw new VitamRuntimeException("Expecting default file bucket with empty set");
        }
        Set folderNames = Arrays.stream(DataCategory.values()).map(DataCategory::getFolder).collect(Collectors.toSet());
        for (Map.Entry<String, FileBucketConfiguration> entry : fileBuckets.entrySet()) {
            boolean isDefault = DEFAULT.equals(entry.getKey());
            if (!isDefault && entry.getValue().getDataCategories().isEmpty()) {
                throw new VitamRuntimeException("Expected non empty file bucket configuration " + entry.getKey());
            }
            for (String folderName : entry.getValue().getDataCategories()) {
                if (folderNames.contains(folderName)) continue;
                throw new VitamRuntimeException("Invalid folder name in bucket configuration '" + folderName + "'");
            }
        }
    }

    private void validateBucketConfiguration(TapeLibraryTopologyConfiguration configuration) throws VitamRuntimeException {
        Map buckets = configuration.getBuckets();
        if (buckets == null) {
            throw new VitamRuntimeException("Invalid conf. Missing buckets configuration");
        }
        for (TapeLibraryBucketConfiguration bucketConfiguration : buckets.values()) {
            if (bucketConfiguration == null) {
                throw new VitamRuntimeException("Missing bucket configuration");
            }
            if (CollectionUtils.isEmpty((Collection)bucketConfiguration.getTenants())) {
                throw new VitamRuntimeException("Missing bucket tenants");
            }
            if (bucketConfiguration.getTarBufferingTimeoutInMinutes() > 0) continue;
            throw new VitamRuntimeException("Tar buffering timeout must be positive");
        }
        if (BucketTopologyHelper.hasDuplicates(buckets.values().stream().map(TapeLibraryBucketConfiguration::getTenants).flatMap(Collection::stream))) {
            throw new VitamRuntimeException("Duplicates found in file bucket configuration");
        }
        if (buckets.containsKey(BACKUP_BUCKET)) {
            throw new VitamRuntimeException("Reserved backup bucket");
        }
        Set fileBucketTenants = buckets.values().stream().map(TapeLibraryBucketConfiguration::getTenants).flatMap(Collection::stream).collect(Collectors.toSet());
        HashSet vitamTenants = new HashSet(VitamConfiguration.getTenants());
        SetUtils.SetView missingTenants = SetUtils.difference(vitamTenants, fileBucketTenants);
        if (!missingTenants.isEmpty()) {
            throw new VitamRuntimeException("Missing tenants " + String.valueOf(missingTenants));
        }
        SetUtils.SetView unknownTenants = SetUtils.difference(fileBucketTenants, vitamTenants);
        if (!unknownTenants.isEmpty()) {
            throw new VitamRuntimeException("Unknown tenants " + String.valueOf(unknownTenants));
        }
    }

    public String getFileBucketFromContainerName(String containerName) {
        int tenant = ContainerUtils.parseTenantFromContainerName((String)containerName);
        DataCategory dataCategory = ContainerUtils.parseDataCategoryFromContainerName((String)containerName);
        return this.containerToFileBucketMap.get(ImmutablePair.of((Object)tenant, (Object)dataCategory));
    }

    public String getBucketFromFileBucket(String fileBucket) {
        if (BACKUP_FILE_BUCKET.equals(fileBucket)) {
            return BACKUP_BUCKET;
        }
        return this.fileBucketToBucketMap.get(fileBucket);
    }

    public Set<String> listFileBuckets() {
        return new HashSet<String>(this.containerToFileBucketMap.values());
    }

    public boolean isValidFileBucketId(String fileBucketId) {
        return this.fileBucketToBucketMap.containsKey(fileBucketId);
    }

    public Set<String> listContainerNames(String fileBucketId) {
        return this.containerToFileBucketMap.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(fileBucketId)).map(entry -> ContainerUtils.buildContainerName((DataCategory)((DataCategory)((Pair)entry.getKey()).getRight()), (String)((Integer)((Pair)entry.getKey()).getLeft()).toString())).collect(Collectors.toSet());
    }

    public Integer getTarBufferingTimeoutInMinutes(String bucketId) {
        return this.tarBufferingTimeoutInMinutesByBucketId.get(bucketId);
    }

    public boolean keepFileBucketIdForeverInCache(String fileBucketId) {
        return this.fileBucketIdsToKeepForeverInCache.contains(fileBucketId);
    }

    private static <T> boolean hasDuplicates(Stream<T> stream) {
        HashSet set = new HashSet();
        return !stream.allMatch(set::add);
    }
}

