/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.cas;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import com.mongodb.MongoException;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.database.server.mongodb.BsonHelper;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.storage.engine.common.model.TapeAccessRequestReferentialEntity;
import fr.gouv.vitam.storage.engine.common.model.TapeLibraryObjectReferentialId;
import fr.gouv.vitam.storage.offers.tape.exception.AccessRequestReferentialException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.ListUtils;
import org.bson.Document;
import org.bson.conversions.Bson;

public class AccessRequestReferentialRepository {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AccessRequestReferentialRepository.class);
    private final MongoCollection<Document> collection;
    private final int bulkSize;

    public AccessRequestReferentialRepository(MongoCollection<Document> collection) {
        this(collection, VitamConfiguration.getBatchSize());
    }

    @VisibleForTesting
    AccessRequestReferentialRepository(MongoCollection<Document> collection, int bulkSize) {
        this.collection = collection;
        this.bulkSize = bulkSize;
    }

    public void insert(TapeAccessRequestReferentialEntity accessRequestReferentialEntity) throws AccessRequestReferentialException {
        try {
            this.collection.insertOne((Object)this.toBson(accessRequestReferentialEntity));
        }
        catch (MongoException ex) {
            throw new AccessRequestReferentialException("Could not insert access requests referential for id " + accessRequestReferentialEntity.getRequestId(), ex);
        }
    }

    public Optional<TapeAccessRequestReferentialEntity> findByRequestId(String requestId) throws AccessRequestReferentialException {
        try {
            TapeAccessRequestReferentialEntity accessRequestReferentialEntity = (TapeAccessRequestReferentialEntity)this.collection.find(Filters.eq((String)"_id", (Object)requestId)).map(this::toModel).first();
            return Optional.ofNullable(accessRequestReferentialEntity);
        }
        catch (MongoException ex) {
            throw new AccessRequestReferentialException("Could not find read request by id " + requestId, ex);
        }
    }

    public List<TapeAccessRequestReferentialEntity> findByRequestIds(Set<String> requestIds) throws AccessRequestReferentialException {
        try {
            if (requestIds.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<TapeAccessRequestReferentialEntity> results = new ArrayList<TapeAccessRequestReferentialEntity>();
            for (List requestIdsBulk : IteratorUtils.asIterable((Iterator)Iterators.partition(requestIds.iterator(), (int)this.bulkSize))) {
                this.collection.find(Filters.in((String)"_id", (Iterable)requestIdsBulk)).map(this::toModel).forEach(results::add);
            }
            return results;
        }
        catch (MongoException ex) {
            throw new AccessRequestReferentialException("Could not find read request by ids", ex);
        }
    }

    public long countNonReadyAccessRequests() throws AccessRequestReferentialException {
        try {
            return this.collection.countDocuments(Filters.and((Bson[])new Bson[]{Filters.exists((String)"unavailableArchiveIds"), Filters.ne((String)"unavailableArchiveIds", Collections.emptyList())}));
        }
        catch (MongoException ex) {
            throw new AccessRequestReferentialException("Could not count non-ready access requests", ex);
        }
    }

    public long countReadyAccessRequests() throws AccessRequestReferentialException {
        try {
            String now = LocalDateUtil.nowFormatted();
            return this.collection.countDocuments(Filters.gte((String)"expirationDate", (Object)now));
        }
        catch (MongoException ex) {
            throw new AccessRequestReferentialException("Could not count ready access requests", ex);
        }
    }

    public long countExpiredAccessRequests() throws AccessRequestReferentialException {
        try {
            String now = LocalDateUtil.nowFormatted();
            return this.collection.countDocuments(Filters.lt((String)"expirationDate", (Object)now));
        }
        catch (MongoException ex) {
            throw new AccessRequestReferentialException("Could not count expired access requests", ex);
        }
    }

    public List<TapeAccessRequestReferentialEntity> findNonReadyAccessRequests() throws AccessRequestReferentialException {
        try {
            ArrayList<TapeAccessRequestReferentialEntity> results = new ArrayList<TapeAccessRequestReferentialEntity>();
            this.collection.find(Filters.and((Bson[])new Bson[]{Filters.exists((String)"unavailableArchiveIds"), Filters.ne((String)"unavailableArchiveIds", Collections.emptyList())})).map(this::toModel).forEach(results::add);
            return results;
        }
        catch (MongoException ex) {
            throw new AccessRequestReferentialException("Could not find read request by ids", ex);
        }
    }

    public List<TapeAccessRequestReferentialEntity> findByUnavailableArchiveId(String archiveId) throws AccessRequestReferentialException {
        try {
            ArrayList<TapeAccessRequestReferentialEntity> results = new ArrayList<TapeAccessRequestReferentialEntity>();
            this.collection.find(Filters.in((String)"unavailableArchiveIds", (Object[])new String[]{archiveId})).map(this::toModel).forEach(results::add);
            return results;
        }
        catch (MongoException ex) {
            throw new AccessRequestReferentialException("Could not find read request by ids", ex);
        }
    }

    public boolean deleteAccessRequestById(String accessRequestId) throws AccessRequestReferentialException {
        try {
            DeleteResult deleteResult = this.collection.deleteOne(Filters.eq((String)"_id", (Object)accessRequestId));
            if (deleteResult.getDeletedCount() == 0L) {
                LOGGER.warn("No such AccessRequest: " + accessRequestId + ". Concurrent delete?");
                return false;
            }
            LOGGER.warn("Access request deleted successfully: " + accessRequestId);
            return true;
        }
        catch (MongoException ex) {
            throw new AccessRequestReferentialException("Could not delete access request for " + accessRequestId, ex);
        }
    }

    public List<TapeAccessRequestReferentialEntity> cleanupAndGetExpiredAccessRequests() throws AccessRequestReferentialException {
        try {
            String now = LocalDateUtil.nowFormatted();
            ArrayList<TapeAccessRequestReferentialEntity> expiredAccessRequests = new ArrayList<TapeAccessRequestReferentialEntity>();
            try (MongoCursor expiredAccessRequestCursor = this.collection.find(Filters.lt((String)"purgeDate", (Object)now)).cursor();){
                expiredAccessRequestCursor.forEachRemaining(document -> expiredAccessRequests.add(this.toModel((Document)document)));
            }
            for (TapeAccessRequestReferentialEntity expiredAccessRequest : expiredAccessRequests) {
                LOGGER.warn("Deleting expired access request " + expiredAccessRequest.getRequestId() + ", lastUpdateDate: " + expiredAccessRequest.getReadyDate());
            }
            for (List accessRequestBulkToDelete : ListUtils.partition(expiredAccessRequests, (int)VitamConfiguration.getBatchSize())) {
                this.collection.deleteMany(Filters.in((String)"_id", (Iterable)accessRequestBulkToDelete.stream().map(TapeAccessRequestReferentialEntity::getRequestId).collect(Collectors.toList())));
            }
            return expiredAccessRequests;
        }
        catch (MongoException ex) {
            throw new AccessRequestReferentialException("Could not purge expired access requests.", ex);
        }
    }

    public Set<String> excludeArchiveIdsStillRequiredByAccessRequests(Set<String> archiveIdsToCheck) {
        if (archiveIdsToCheck.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> inUseArchiveIds = new HashSet<String>(archiveIdsToCheck);
        for (List archiveIdsBulk : IteratorUtils.asIterable((Iterator)Iterators.partition(archiveIdsToCheck.iterator(), (int)this.bulkSize))) {
            DistinctIterable distinct = this.collection.distinct("unavailableArchiveIds", Filters.in((String)"unavailableArchiveIds", (Iterable)archiveIdsBulk), String.class);
            distinct.forEach(inUseArchiveIds::remove);
        }
        return inUseArchiveIds;
    }

    public boolean updateAccessRequest(TapeAccessRequestReferentialEntity updatedAccessRequestEntity, int expectedVersion) throws AccessRequestReferentialException {
        try {
            UpdateResult updateResult = this.collection.replaceOne(Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)updatedAccessRequestEntity.getRequestId()), Filters.eq((String)"_v", (Object)expectedVersion)}), (Object)this.toBson(updatedAccessRequestEntity));
            return updateResult.getMatchedCount() != 0L;
        }
        catch (MongoException e) {
            throw new AccessRequestReferentialException("Could not update access request " + updatedAccessRequestEntity.getRequestId(), e);
        }
    }

    public CloseableIterator<TapeLibraryObjectReferentialId> listObjectIdsForActiveAccessRequests() throws AccessRequestReferentialException {
        try {
            String now = LocalDateUtil.nowFormatted();
            List<Bson> aggregatePipeline = List.of(Aggregates.match((Bson)Filters.or((Bson[])new Bson[]{Filters.eq((String)"expirationDate", null), Filters.gte((String)"expirationDate", (Object)now)})), Aggregates.project((Bson)new Document().append("_id", (Object)0).append("objectNames", (Object)1).append("containerName", (Object)1)), Aggregates.unwind((String)"$objectNames"), Aggregates.group((Object)new Document().append("containerName", (Object)"$containerName").append("objectName", (Object)"$objectNames"), (BsonField[])new BsonField[0]));
            AggregateIterable aggregate = this.collection.aggregate(aggregatePipeline).allowDiskUse(Boolean.valueOf(true));
            final MongoCursor iterator = aggregate.iterator();
            return new CloseableIterator<TapeLibraryObjectReferentialId>(){

                public void close() {
                    iterator.close();
                }

                public boolean hasNext() {
                    return iterator.hasNext();
                }

                public TapeLibraryObjectReferentialId next() {
                    Document docId = (Document)((Document)iterator.next()).get((Object)"_id", Document.class);
                    return new TapeLibraryObjectReferentialId(docId.getString((Object)"containerName"), docId.getString((Object)"objectName"));
                }
            };
        }
        catch (MongoException e) {
            throw new AccessRequestReferentialException("Could not fetch archive ids required by active access requests", e);
        }
    }

    private Document toBson(TapeAccessRequestReferentialEntity object) {
        return Document.parse((String)JsonHandler.unprettyPrint((Object)object));
    }

    private TapeAccessRequestReferentialEntity toModel(Document document) throws IllegalStateException {
        try {
            return (TapeAccessRequestReferentialEntity)BsonHelper.fromDocumentToObject((Document)document, TapeAccessRequestReferentialEntity.class);
        }
        catch (InvalidParseOperationException e) {
            throw new IllegalStateException("Could not parse document from DB " + document.toJson(), e);
        }
    }
}

